{$asmmode intel}
unit ubump;

interface

procedure bump_init;
procedure bump_action(counter: longint);
procedure bump_close;

implementation

uses
  ivs_sys,ivs_var,crt;

Var Light      : Pointer;
    Normals    : Pointer;
    BackGround : Pointer;
    texture : Pointer;
    counter: longint;

  korder,vorder,aorder,row:byte;
  term:boolean;

{$include bump_tex.inc}
{$include bump_lig.inc}
{$include bump_map.inc}

Function Rad(Value : Real) : Real;
Begin
 Rad:=Value * (Pi / 180);
End;

Procedure InitLightSource;
var
  f:file;
Begin
  light:=@bump_light;
End;

procedure convertimage(image:pointer;size:dword);
begin
  asm
    mov esi,[image]
    mov edi,[image]
    mov eax,4
    mov ebx,size
    dec ebx
    mul ebx
    add edi,eax
    mov eax,3
    mul ebx
    add esi,eax
    mov ecx,size
   @loop0:
    mov eax,[esi]
    mov bh,ah
    ror eax,16
    mov ah,bh
    mov [edi],eax
    sub esi,3
    sub edi,4
    loop @loop0
  end;
end;

Procedure InitBackGround;
type
  pdword = ^dword;
var
  f:file;
  counter:dword;
  lofasz:dword;
Begin
  background:=@bump_map;
  for counter:=0 to 259999 do begin
    lofasz:=pdword(@bump_tex[counter*4])^;
    asm
      mov eax,lofasz
      bswap eax
      ror eax,8
      mov lofasz,eax
    end;
    pdword(texture)[counter]:=lofasz;
  end;
End;

Procedure InitNormals; Assembler;
Var LineCounter : Word;
Asm
 XOR EBX,EBX
 MOV ESI,Normals
 MOV EDI,BackGround
 MOV ECX,200
 @CycleHead:
  MOV LineCounter,CX
  MOV CX,320
  @CycleHead2:
   XOR AX,AX
   MOV AL,[EDI+EBX+1]
   MOV AH,AL
   SUB AL,[EDI+EBX]
   SUB AH,[EDI+EBX+320]
   PUSH CX
   SHR CX,1
   MOV DL,CL
   MOV CX,LineCounter
   SHR CX,1
   MOV DH,CL
   POP CX
   ADD AX,DX
   MOV [ESI+EBX*2],AX
   INC EBX
   DEC CX
  JNZ @CycleHead2
  MOV CX,LineCounter
  DEC CX
 JNZ @CycleHead
End;

Procedure WaitRetrace; Assembler;
Asm
 MOV DX,3DAH
 @VERT1:
  IN   AL,DX
  TEST AL,8
 JZ @VERT1
 @VERT2:
  IN   AL,DX
  TEST AL,8
 jnz @vert2
End;

Procedure Bump(XPos, YPos : Byte);
Begin
 Asm
  XOR EDX,EDX
  XOR EBX,EBX
  MOV DL,XPos
  MOV DH,YPos
  MOV ESI,Normals
  MOV EDI,IVS_VirtualScreen
  MOV ECX,64000
  @CycleHead:
   MOV BX,[ESI]
   add BX,DX
   ADD ESI,2
   PUSH ESI
   mov esi,[texture]
   mov eax,64000
   sub eax,ecx
   shl eax,2
   add esi,eax
   mov eax,[esi]
   MOV ESI,Light
   MOV BL,[ESI+EBX]
   add al,bl
   jnc @ok0
   mov al,255
   @ok0:
   add ah,bl
   jnc @ok1
   mov ah,255
   @ok1:
   ror eax,16
   add al,bl
   jnc @ok2
   mov al,255
   @ok2:
   ror eax,16
   stosd
   POP ESI
  loop @CycleHead
 End;
End;

procedure bump_init;
begin
 GetMem(Normals,128000);
 GetMem(texture,256000);
 InitLightSource;
 InitBackGround;
 InitNormals;
// convertimage(texture,64000);
end;

procedure bump_action(counter: longint);
begin
  Bump(Round(Sin(Rad((Counter mod 90)*8))*40)+50,
       Round(Cos(Rad((Counter mod 90)*4))*25)+80);
end;

procedure bump_close;
begin
 FreeMem(Normals,128000);
 freeMem(texture,256000);
end;

begin
end.
