{Ŀ}
{  IVS_VESA.PAS - VESA BIOS Driver - 320x200 32bit include file           }
{                  Work started     : 1998.08.01.                          }
{                  Last modification: 2001.07.02.                          }
{             OS - GO32V2                                                  }
{                                                                          }
{            IVS - Inquisition Video Server for Free Pascal                }
{                  Code by Karoly Balogh (a.k.a. Charlie/iNQ) and          }
{                          Marton Ekler (a.k.a. mrc!/iNQ)                  }
{                  Copyright (C) 1998-2001 Inquisition                     }
{}

Procedure VESA_Copy32Bit_Linear; Assembler;
Asm
 CMP VESA_BGRMode,1
 JNE @RGB_Copy

 {  BGR Mode  }
 @BGR_Copy:
  PUSH ES
  MOV  ESI,IVS_VirtualScreen
  MOV  ES,VESA_SegLFB
  MOV  EDI,VESA_PhysScrAddr
  MOV  ECX,64000
  CLD
  REP  MOVSD
  POP  ES
 JMP @Exit

 {  RGB Mode  }
 @RGB_Copy:
  PUSH ES
  MOV  ESI,IVS_VirtualScreen
  MOV  ES,VESA_SegLFB
  MOV  EDI,VESA_PhysScrAddr
  MOV  ECX,64000
  CLD
  @CycleHead:
   LODSD
   BSWAP EAX
   SHR   EAX,8
   STOSD
  LOOP @CycleHead
  POP  ES

 @Exit:
End;

Procedure VESA_Copy32Bit_Banked; Assembler;
Var CurrentBank : Word;
Asm
 CMP VESA_BGRMode,1
 JNE @RGB_Copy

 {  BGR Mode  }
 @BGR_Copy:
  XOR  EDX,EDX
  MOV  EAX,VESA_PhysScrAddr
  DIV  VESA_WinSize
  MOV  CurrentBank,AX
  PUSH EDX

  PUSH CurrentBank
  CALL VESA_SwitchBank
  POP  EDX
  PUSH GS
  MOV  ESI,IVS_VirtualScreen
  MOV  GS,VESA_SegA000
  MOV  EDI,EDX

  CLD
  MOV  EDX,VESA_WinSize
  MOV  EBX,200
  @CycleHead1:
    MOV  ECX,320
    @CycleHead2:
      MOV  EAX,[ESI]
      MOV  GS:[EDI],EAX
      ADD  EDI,4
      ADD  ESI,4
      CMP  EDI,EDX
      JB   @NoBankSwitch
       INC CurrentBank
       PUSHAD
       PUSH CurrentBank
       CALL VESA_SwitchBank
       MOV  GS,VESA_SegA000
       POPAD
       XOR EDI,EDI
      @NoBankSwitch:
      DEC  ECX
    JNZ  @CycleHead2
    SUB  EDI,320*4
    ADD  EDI,VESA_ScanlineLength
    DEC  EBX
  JNZ  @CycleHead1
  POP  GS
 JMP @Exit

 {  RGB Mode  }
 @RGB_Copy:
  XOR  EDX,EDX
  MOV  EAX,VESA_PhysScrAddr
  DIV  VESA_WinSize
  MOV  CurrentBank,AX
  PUSH EDX

  PUSH CurrentBank
  CALL VESA_SwitchBank
  POP  EDX
  PUSH GS
  MOV  ESI,IVS_VirtualScreen
  MOV  GS,VESA_SegA000
  MOV  EDI,EDX

  CLD
  MOV  EDX,VESA_WinSize
  MOV  EBX,200
  @CycleHead3:
    MOV  ECX,320
    @CycleHead4:
      MOV   EAX,[ESI]
      BSWAP EAX
      SHR   EAX,8
      MOV   GS:[EDI],EAX
      ADD   EDI,4
      ADD   ESI,4
      CMP   EDI,EDX
      JB    @NoBankSwitch2
       INC    CurrentBank
       PUSHAD
       PUSH   CurrentBank
       CALL   VESA_SwitchBank
       MOV    GS,VESA_SegA000
       POPAD
       XOR    EDI,EDI
      @NoBankSwitch2:
      DEC   ECX
    JNZ  @CycleHead4
    SUB  EDI,320*4
    ADD  EDI,VESA_ScanlineLength
    DEC  EBX
  JNZ  @CycleHead3
  POP  GS

 @Exit:
End;

{  320x200/32bit truecolor  }
Const VESA_LowResTrueColor32 : IVS_TVideoMode =
           (VMWidth  :320; VMHeight  :200;
            VMBFWidth:320; VMBFHeight:200;
            VMColours:16777216; VMBPP:32;
            VMName:'truecolor';
            VMMode:0;
            VMDoubleBuf:IVS_VMEnabled;
            VMVSync    :IVS_VMDisabled;
            VMAvailable:True;
            VMCopy_Banked:(CP_Normal  :@VESA_Copy32Bit_Banked;
                           CP_Scaled  :@IVS_DummyProc;
                           CP_Laced   :@IVS_DummyProc;
                           CP_Bilinear:@IVS_DummyProc);
            VMCopy_Linear:(CP_Normal  :@VESA_Copy32Bit_Linear;
                           CP_Scaled  :@IVS_DummyProc;
                           CP_Laced   :@IVS_DummyProc;
                           CP_Bilinear:@IVS_DummyProc));

{  VBE_LO32.PAS - (C) 1998-2001 Charlie/Inquisition et. al.  }
