{Ŀ}
{  IVS_VESA.PAS - VESA BIOS Driver - 640x480 32bit include file           }
{                  Work started     : 1998.08.01.                          }
{                  Last modification: 2001.07.02.                          }
{             OS - GO32V2                                                  }
{                                                                          }
{            IVS - Inquisition Video Server for Free Pascal                }
{                  Code by Karoly Balogh (a.k.a. Charlie/iNQ) and          }
{                          Marton Ekler (a.k.a. mrc!/iNQ)                  }
{                  Copyright (C) 1998-2001 Inquisition                     }
{}

Procedure VESA_CopyHi32Bit_Banked_Scaled; Assembler;
Var CurrentBank : Word;
Asm
 XOR  EDX,EDX
 MOV  EAX,VESA_PhysScrAddr
 DIV  VESA_WinSize
 MOV  CurrentBank,AX
 PUSH EDX

 PUSH CurrentBank
 CALL VESA_SwitchBank
 POP  EDX

 PUSH GS
 MOV  ESI,IVS_VirtualScreen
 MOV  GS,VESA_SegA000
 MOV  EDI,EDX
 MOV  EDX,VESA_WinSize

 CMP VESA_BGRMode,1
 JNE @RGB_Copy

 {  BGR Mode  }
 @BGR_Copy:
  MOV  ECX,200
  CLD
  @CycleHead1:
   PUSH  ECX
   MOV   ECX,2
   @CycleHead2:
    PUSH ECX
    MOV  ECX,320
    @CycleHead3:
     MOV   EAX,[ESI]
     MOV   GS:[EDI],EAX
     MOV   GS:[EDI+4],EAX
     ADD   EDI,8
     CMP   EDI,EDX
     JB    @NoBankSwitch
       INC CurrentBank
       PUSHAD
       PUSH CurrentBank
       CALL VESA_SwitchBank
       MOV  GS,VESA_SegA000
       POPAD
       XOR EDI,EDI
     @NoBankSwitch:
     ADD   ESI,4
    LOOP @CycleHead3
    SUB  ESI,320*4
    POP  ECX
   LOOP @CycleHead2
   ADD  ESI,320*4
   POP  ECX
  LOOP @CycleHead1
 JMP  @Exit

 {  RGB Mode  }
 @RGB_Copy:
  MOV  ECX,200
  CLD
  @CycleHead4:
   PUSH  ECX
   MOV   ECX,2
   @CycleHead5:
    PUSH ECX
    MOV  ECX,320
    @CycleHead6:
     MOV   EAX,[ESI]
     BSWAP EAX
     SHR   EAX,8
     MOV   GS:[EDI],EAX
     MOV   GS:[EDI+4],EAX
     ADD   EDI,8
     CMP   EDI,EDX
     JB    @NoBankSwitch2
       INC CurrentBank
       PUSHAD
       PUSH CurrentBank
       CALL VESA_SwitchBank
       MOV  GS,VESA_SegA000
       POPAD
       XOR EDI,EDI
     @NoBankSwitch2:
     ADD   ESI,4
    LOOP @CycleHead6
    SUB  ESI,320*4
    POP  ECX
   LOOP @CycleHead5
   ADD  ESI,320*4
   POP  ECX
  LOOP @CycleHead4

 @Exit:
 POP  GS
End;

Procedure VESA_CopyHi32Bit_Banked_Laced; Assembler;
Var CurrentBank : Word;
Asm
 XOR  EDX,EDX
 MOV  EAX,VESA_PhysScrAddr
 DIV  VESA_WinSize
 MOV  CurrentBank,AX
 PUSH EDX

 PUSH CurrentBank
 CALL VESA_SwitchBank
 POP  EDX

 PUSH GS
 MOV  ESI,IVS_VirtualScreen
 MOV  GS,VESA_SegA000
 MOV  EDI,EDX
 MOV  EDX,VESA_WinSize

 CMP VESA_BGRMode,1
 JNE @RGB_Copy

 {  BGR Mode  }
 @BGR_Copy:
  MOV  ECX,200
  CLD
  @CycleHead1:
   PUSH ECX
   MOV  ECX,320
   @CycleHead2:
    MOV  EAX,[ESI]
    MOV  GS:[EDI],EAX
    MOV  GS:[EDI+4],EAX
    ADD  EDI,8
    CMP  EDI,EDX
    JB   @NoBankSwitch
     INC CurrentBank
     PUSHAD
     PUSH CurrentBank
     CALL VESA_SwitchBank
     MOV  GS,VESA_SegA000
     POPAD
     XOR EDI,EDI
    @NoBankSwitch:
    ADD  ESI,4
   LOOP @CycleHead2
   ADD  EDI,320*4*2
   CMP  EDI,EDX
   JB   @NoBankSwitch2
    INC CurrentBank
    PUSHAD
    PUSH CurrentBank
    CALL VESA_SwitchBank
    MOV  GS,VESA_SegA000
    POPAD
    SUB EDI,EDX
   @NoBankSwitch2:
   POP  ECX
  LOOP @CycleHead1
 JMP  @Exit

 {  RGB Mode  }
 @RGB_Copy:
  MOV  ECX,200
  CLD
  @CycleHead3:
   PUSH ECX
   MOV  ECX,320
   @CycleHead4:
    MOV   EAX,[ESI]
    BSWAP EAX
    SHR   EAX,8
    MOV   GS:[EDI],EAX
    MOV   GS:[EDI+4],EAX
    ADD   EDI,8
    CMP   EDI,EDX
    JB    @NoBankSwitch3
     INC CurrentBank
     PUSHAD
     PUSH CurrentBank
     CALL VESA_SwitchBank
     MOV  GS,VESA_SegA000
     POPAD
     XOR EDI,EDI
    @NoBankSwitch3:
    ADD   ESI,4
   LOOP @CycleHead4
   ADD  EDI,320*4*2
   CMP  EDI,EDX
   JB   @NoBankSwitch4
    INC CurrentBank
    PUSHAD
    PUSH CurrentBank
    CALL VESA_SwitchBank
    MOV  GS,VESA_SegA000
    POPAD
    SUB EDI,EDX
   @NoBankSwitch4:
   POP  ECX
  LOOP @CycleHead3

 @Exit:
 POP  GS
End;

Procedure VESA_CopyHi32Bit_Linear_Scaled; Assembler;
Asm
 CMP VESA_BGRMode,1
 JNE @RGB_Copy

 {  BGR Mode  }
 @BGR_Copy:
  PUSH ES
  MOV  ESI,IVS_VirtualScreen
  MOV  ES,VESA_SegLFB
  MOV  EDI,VESA_PhysScrAddr
  MOV  ECX,200
  CLD
  @CycleHead1:
   MOV  EDX,320
   @CycleHead2: {  First Scanline  }
    LODSD
    STOSD
    STOSD
    DEC EDX
   JNZ  @CycleHead2
   SUB  ESI,320*4
   MOV  EDX,320
   @CycleHead3: {  Second Scanline  }
    LODSD
    STOSD
    STOSD
    DEC EDX
   JNZ  @CycleHead3
   DEC  ECX
  JNZ  @CycleHead1
  POP  ES
 JMP @Exit

 {  RGB Mode  }
 @RGB_Copy:
  PUSH ES
  MOV  ESI,IVS_VirtualScreen
  MOV  ES,VESA_SegLFB
  MOV  EDI,VESA_PhysScrAddr
  MOV  ECX,200
  CLD
  @CycleHead4:
   MOV  EDX,320
   @CycleHead5: {  First Scanline  }
    LODSD
    BSWAP EAX
    SHR   EAX,8
    STOSD
    STOSD
    DEC EDX
   JNZ  @CycleHead5
   SUB  ESI,320*4
   MOV  EDX,320
   @CycleHead6: {  Second Scanline  }
    LODSD
    BSWAP EAX
    SHR   EAX,8
    STOSD
    STOSD
    DEC EDX
   JNZ  @CycleHead6
   DEC  ECX
  JNZ  @CycleHead4
  POP  ES

 @Exit:
End;

Procedure VESA_CopyHi32Bit_Linear_Laced; Assembler;
Asm
 CMP VESA_BGRMode,1
 JNE @RGB_Copy

 {  BGR Mode  }
 @BGR_Copy:
  PUSH ES
  MOV  ESI,IVS_VirtualScreen
  MOV  ES,VESA_SegLFB
  MOV  EDI,VESA_PhysScrAddr
  MOV  ECX,200
  CLD
  @CycleHead1:
   MOV  EDX,320
   @CycleHead2: {  First Scanline  }
    LODSD
    STOSD
    STOSD
    DEC EDX
   JNZ  @CycleHead2
   ADD  EDI,320*4*2
   DEC  ECX
  JNZ  @CycleHead1
  POP  ES
 JMP @Exit

 {  RGB Mode  }
 @RGB_Copy:
  PUSH ES
  MOV  ESI,IVS_VirtualScreen
  MOV  ES,VESA_SegLFB
  MOV  EDI,VESA_PhysScrAddr
  MOV  ECX,200
  CLD
  @CycleHead4:
   MOV  EDX,320
   @CycleHead5: {  First Scanline  }
    LODSD
    BSWAP EAX
    SHR   EAX,8
    STOSD
    STOSD
    DEC EDX
   JNZ  @CycleHead5
   ADD  EDI,320*4*2
   DEC  ECX
  JNZ  @CycleHead4
  POP  ES

 @Exit:
End;

{  640x480/32bit hicolor  }
Const VESA_HighResTrueColor32 : IVS_TVideoMode =
           (VMWidth  :640; VMHeight  :480;
            VMBFWidth:320; VMBFHeight:200;
            VMColours:16777216; VMBPP:32;
            VMName:'doubled truecolor';
            VMMode:0;
            VMDoubleBuf:IVS_VMEnabled;
            VMVSync    :IVS_VMDisabled;
            VMAvailable:True;
            VMCopy_Banked:(CP_Normal  :@IVS_DummyProc;
                           CP_Scaled  :@VESA_CopyHi32Bit_Banked_Scaled;
                           CP_Laced   :@VESA_CopyHi32Bit_Banked_Laced;
                           CP_Bilinear:@IVS_DummyProc);
            VMCopy_Linear:(CP_Normal  :@IVS_DummyProc;
                           CP_Scaled  :@VESA_CopyHi32Bit_Linear_Scaled;
                           CP_Laced   :@VESA_CopyHi32Bit_Linear_Laced;
                           CP_Bilinear:@IVS_DummyProc));

{  VBE_HI32.PAS - (C) 1998-2001 Charlie/Inquisition et. al.  }
