{Ŀ}
{  IVS_VESA.PAS - VESA BIOS Driver - VBE Utility Functions (Include File) }
{                  Work started     : 1998.08.01.                          }
{                  Last modification: 2001.07.02.                          }
{             OS - GO32V2                                                  }
{                                                                          }
{            IVS - Inquisition Video Server for Free Pascal                }
{                  Code by Karoly Balogh (a.k.a. Charlie/iNQ) and          }
{                          Marton Ekler (a.k.a. mrc!/iNQ)                  }
{                  Copyright (C) 1998-2001 Inquisition                     }
{}

{  Sets screen position on the video memory using VESA call  }
Function VESA_SetDisplayStart(X, Y : Word) : Boolean;
Var Regs : TRealRegs;
Begin
 Regs.EAX:=$4F07;
 Regs.ECX:=X;
 Regs.EDX:=Y;
 Regs.EBX:=0;
 RealIntr($10,Regs);
 VESA_SetDisplayStart:=(Regs.EAX And $FF)=$4F;
End;

{  Returns VESA mode info from the specified mode  }
Function VESA_GetModeInfo(Mode : Word; Var Info : VESA_TModeInformation) : Boolean;
Var Regs     : TRealRegs;
    Linear   : DWord;
    Segment  : Word;
    Selector : Word;
Begin
 {  Init Variables for DOS (below 640K) memory access  }
 Linear:=Global_DOS_Alloc(256);
 Segment:=Word(Linear Shr 16);
 Selector:=Word(Linear And $FFFF);

 {  Calling BIOS to get VESA mode info  }
 FillChar(Regs,SizeOf(Regs),0);
 Regs.EAX:=$4F01;
 Regs.ES:=Segment;
 {  Limiting mode number below $4000 (LFB) because of buggy BIOSes...  }
 Regs.ECX:=(Mode And $3FFF);
 RealIntr($10,Regs);

 {  Copy modeinfo record from DOS memory to FPC Heap  }
 DOSMemGet(Segment,0,Info,256);
 Global_DOS_Free(Selector);

 {  Checking if call was successful  }
 VESA_GetModeInfo:=(Regs.EAX And $FF)=$4F;
End;

{  Sets the specified VESA mode  }
Function VESA_SwitchMode(Mode : Word) : Boolean;
Var Regs : TRealRegs;
Begin
 Regs.EAX:=$4F02;
 Regs.EBX:=Mode;
 RealIntr($10,Regs);
 VESA_SwitchMode:=(Regs.EAX And $FF)=$4F;
End;

{  Switches to the specified videomemory bank  }
Procedure VESA_SwitchBank(Bank : Word);
Var Regs : TRealRegs;
Begin
 Regs.AX:=$4F05;
 Regs.BX:=0;
 Regs.DX:=Bank Shl VESA_GranShift;
 RealIntr($10,Regs);
End;

{  Returns a string from the DOS memory  }
Function VESA_GetRealString(StringPtr : DWord) : String;
Var CopyBuffer : Array[1..255] Of Char;
    BufString  : String;
    Segment    : Word;
    Selector   : Word;
    Counter    : Word;
Begin

 {  Init Variables for DOS (below 640K) memory access  }
 Segment:=Word(StringPtr Shr 16);
 Selector:= Word(StringPtr);

 {  Copying buffer from DOS memory to FPC Heap  }
 DOSMemGet(Segment,Selector,CopyBuffer,SizeOf(CopyBuffer));

 {  Copying buffer to a string variable  }
 Counter:=1;
 BufString:='';
 While (Counter<=SizeOf(CopyBuffer)) And (CopyBuffer[Counter]<>#0) Do Begin
   BufString:=BufString+CopyBuffer[Counter];
   Inc(Counter);
  End;

 VESA_GetRealString:=BufString;
End;

{  VBE_UTIL.PAS - (C) 1998-2001 Charlie/Inquisition et. al.  }
