{Ŀ}
{  IVS_DUMP.PAS - Unit for easy screenshot making                         }
{                  Work started     : 1998.08.01.                          }
{                  Last modification: 2001.07.02.                          }
{             OS - Platform Independent.                                   }
{                                                                          }
{            IVS - Inquisition Video Server for Free Pascal                }
{                  Code by Karoly Balogh (a.k.a. Charlie/iNQ) and          }
{                          Marton Ekler (a.k.a. mrc!/iNQ)                  }
{                  Copyright (C) 1998-2001 Inquisition                     }
{}
{$INCLUDE IVS_SET.INC}
{$ASMMODE INTEL}
{$MODE FPC}

{$NOTES OFF} {  Enable this if you modify the source!  }
{$HINTS OFF} {  Enable this if you modify the source!  }
Unit IVS_Dump;

Interface

Uses IVS_Var,IVS_Sys
     {$IFDEF _IVS_DUMP_BEEPENABLED_}
      ,CRT
     {$ENDIF};

Const IVS_DumpName : String[4] = 'DUMP';
      IVS_DumpNum  : Word = 1;

{  Saves a DUMP*.TGA screenshot to the current directory  }
Function IVS_DumpScreen : Boolean;

Implementation

{  Saves a DUMP*.TGA screenshot to the current directory  }
{  Note: System. prefixes before the IO calls are necessary to avoid  }
{  conflicts with packages redefining the IO routines such as ZipFS.  }
Function IVS_DumpScreen : Boolean;
Const TGAHeader : Array[0..17] Of Byte=($00,$00,$02,$00,$00,$00,$00,$00,$00,
                                        $00,$02,$00,$40,$01,$C8,$00,$18,$00);
Var DumpFile     : File;
    DumpFileName : String[12];
    DumpStr      : String;
    DumpBuffer   : Pointer;
Begin
 IVS_DumpScreen:=False;
 Str(IVS_DumpNum,DumpStr);
 DumpFileName:=IVS_DumpName+DumpStr+'.TGA';

 System.Assign(DumpFile,DumpFileName);
 System.Rewrite(DumpFile,1); If System.IOResult<>0 Then Exit;
 System.BlockWrite(DumpFile,TGAHeader,18);
 If System.IOResult<>0 Then Begin System.Close(DumpFile); Exit; End;

 GetMem(DumpBuffer,64000*3);
 Asm
  MOV EDI,DumpBuffer
  MOV ESI,IVS_VirtualScreen
  ADD ESI,254720
  MOV ECX,200
  @Loop_Y:
   MOV EDX,ECX
   MOV ECX,320
   @Loop_X:
    MOV EAX,[ESI]
    ADD ESI,4
    MOV [EDI],AX
    ROR EAX,16
    MOV [EDI+2],AL
    ADD EDI,3

    DEC ECX
   JNZ @Loop_X

   SUB ESI,2560

   MOV ECX,EDX
   DEC ECX
  JNZ @Loop_Y
 End;
 System.BlockWrite(DumpFile,DumpBuffer^,320*200*3);
 If System.IOResult<>0 Then Begin System.Close(DumpFile); Exit; End;

 FreeMem(DumpBuffer,64000*3);
 System.Close(DumpFile);
 Inc(IVS_DumpNum);

 {$IFDEF _IVS_DUMP_BEEPENABLED_}
  Sound(900); Delay(250); NoSound; {  Beep if saving completted  }
 {$ENDIF};
 IVS_DumpScreen:=True;
End;

Begin
End.
{  IVS_DUMP.PAS - (C) 1998-2001 Charlie/Inquisition et. al.  }

{  History:  }
{  1.0.2 - Header changes [2001.07.02 Charlie]                           }
{  1.0.1 - Filename length fixed [2001.01.17 Charlie]                    }
{  1.0.0 - Initial version [2000.08.29. Charlie]                         }
