
;****************************************************************
;*								*
;*	ST-SYS:							*
;*	System resident ST pour recevoir des BIN PC.		*
;*	(C)OXYGENE 1995 by Leonard.				*
;*								*
;*	Modifs pour system relogeable et download a adresse	*
;*	non fixe Fev 96.					*
;*								*
;****************************************************************

CMD_READ	equ	8
CMD_WRITE	equ	9
LDEBUG		equ	1

BLOCK_SIZE	equ	2048
BLOCK_INFO_SIZE	equ	32

LOAD_ONLY	equ	0
LOAD_AND_RUN	equ	1
BLOCK_RUN	equ	2
BLOCK_SAVE	equ	3
FILE_COPY	equ	4


		clr.l	-(sp)
		move.w	#32,-(sp)
		trap	#1

		pea	txt_intro(pc)
		move.w	#9,-(sp)
		trap	#1
		move.w	#7,-(sp)
		trap	#1
		addq.l	#8,sp
		cmpi.b	#'e',d0
		beq.s	Write

		clr.w	-(sp)
		trap	#1

Write
		pea	txt_write(pc)
		move.w	#9,-(sp)
		trap	#1
		addq.l	#6,sp

		clr.l	$200-8.w

	;--------------------------------------------
	; Write boot sector.
	;--------------------------------------------
		bsr	Write_Boot


	;--------------------------------------------
	; Write system
	;--------------------------------------------
		bsr	Write_Sys


	;--------------------------------------------
	; Return to GEM.
	;--------------------------------------------
		lea	txt_presskey,a0
		bsr	ins_print

		move.w	#7,-(sp)
		trap	#1
		addq.w	#2,sp

		clr.w	-(sp)
		trap	#1




;************************************************************************
; FONCTIONS
;************************************************************************

ins_print
		pea	(a0)
		move.w	#9,-(sp)
		trap	#1
		addq.l	#6,sp
		rts





Write_Boot

		move.w	#(finboot-My_Boot),d0
		cmpi.w	#480-2,d0
		bls.s	.ok

		lea	txt_boottroplong,a0
		bsr	ins_print
		rts

.ok:		lea	txt_writeboot,a0
		bsr	ins_print

		lea	boot_buffer,a0
		moveq	#0,d0		; piste
		moveq	#0,d1		; face
		moveq	#1,d2		; 1 secteur
		moveq	#CMD_READ,d3
		bsr	Track_Acces
		lea	My_Boot,a0
		lea	boot_buffer,a1
		move.w	#$601e,(a1)	; BRA.S du boot.
		lea	32(a1),a1
		moveq	#480/4-1,d0
.copy:		move.l	(a0)+,(a1)+
		dbf	d0,.copy
		lea	boot_buffer,a0
		moveq	#0,d0
		move.w	#510/2-1,d1
.count:		add.w	(a0)+,d0
		dbf	d1,.count
		move.w	#$1234,d1
		sub.w	d0,d1
		move.w	d1,(a0)
		lea	boot_buffer,a0
		moveq	#0,d0		; piste
		moveq	#0,d1		; face
		moveq	#1,d2		; 1 secteur
		moveq	#CMD_WRITE,d3
		bsr	Track_Acces
		rts




Write_Sys
		lea	txt_writesys,a0
		bsr	ins_print
		clr.w	-(sp)		; Attribut normal.
		pea	sysname
		move.w	#$3c,-(sp)	; FCREATE
		trap	#1
		addq.l	#8,sp
		tst.l	d0
		bpl.s	.ok
		lea	txt_writesyserror,a0
		bsr	ins_print
		rts
.ok:		move.w	d0,d7		; handle
		pea	My_Sys			; Adresse buffer.
		move.l	#(finsys-My_Sys),-(sp)	; Taille system.
		move.w	d7,-(sp)
		move.w	#$40,-(sp)		; FWRITE
		trap	#1
		lea	12(sp),sp
		move.w	d7,-(sp)
		move.w	#$3e,-(sp)		; FCLOSE
		trap	#1
		addq.l	#4,sp
		rts



; D0: Track
; D1: Side
; D2: Nb sector
; D3: Command (8=read,9=write)
; A0: Buffer adress.
Track_Acces	cmpi.w	#CMD_READ,d3
		beq.s	.ok
		cmpi.w	#CMD_WRITE,d3
		bne.s	.non
.ok:		and.w	#1,d1
		move.w	d2,-(sp)	; Count
		move.w	d1,-(sp)	; Side
		move.w	d0,-(sp)	; Track
		move.w	#1,-(sp)	; Secteur deb
		clr.w	-(sp)		; Drive A:
		clr.l	-(sp)
		pea	(a0)		; buffer
		move.w	d3,-(sp)	; Command
		trap	#14
		lea	20(sp),sp
.non:		rts



txt_intro
		dc.b	27,'E'
		dc.b	'ATARI-PC system installator.',10,13
		dc.b	'(C)OXYGENE 95 by Leonard.',10,13,10,13
		dc.b	'Ce prog va creer un boot secteur',10,13
		dc.b	'et un fichier LEO_PC.SYS sur la',10,13
		dc.b	'disquette A:',10,13
		dc.b	'Appuyez sur "e" pour ecrire.',10,13,7,0

txt_write	dc.b	'Writing system...',10,13,0
txt_error	dc.b	'Error on writing track 80,10 sectors.',10,13,0
txt_size	dc.b	'ERROR: System is too large.',10,13,0
txt_boottroplong
		dc.b	'BOOT trop long. ( >  478 octets).',10,13,0
txt_writeboot
		dc.b	'Ecriture du boot-secteur...',10,13,0
txt_writesys
		dc.b	'Creation du fichier system LEO_PC.SYS',10,13,0
txt_writesyserror
		dc.b	'ERROR in writing LEO_PC.SYS',10,13,0
txt_presskey
		dc.b	10,13
		dc.b	'Press a key to return to GEM.',10,13,0


		even


boot_buffer	ds.b	512








;********************************************************************
;********************************************************************
;********************************************************************
;********************************************************************


;**************************************
;
;	Boot Secteur system.
;
;**************************************

My_Boot
		addq.l	#4,4(sp)		; Skip le BSR du wait disk dur en ROM.
						; (fast boot)
		cmpi.l	#'LEO!',$200.w
		bne.s	boot_sys

nosys:		clr.l	$200.w
		lea	normaltxt(pc),a0

print		pea	(a0)
		move.w	#9,-(sp)
		trap	#1
		addq.l	#6,sp
		rts

boot_sys:
		lea	sysloadtxt(pc),a0
		bsr.s	print

	;------------------------------------------------------
	;	Fast load.
	;------------------------------------------------------
		cmpi.l	#'LEO!',($200-8).w
		bne.s	.loading
		move.l	($200-4).w,a6		; Adresse du bin.
		cmpi.l	#'LEO!',2(a6)		; Second check
		bne.s	.loading
		jmp	(a6)
		
	;------------------------------------------------------
	; Lecture du fichier system.
	;------------------------------------------------------
.loading:	clr.w	-(sp)		; Lecture uniquement.
		pea	sysname(pc)
		move.w	#$3d,-(sp)	; FOPEN
		trap	#1
		addq.l	#8,sp
		tst.l	d0
		bpl.s	.ok
		lea	errortxt(pc),a0
		bsr.s	print
		bra.s	nosys

.ok:		move.w	d0,d7		; handle
		move.l	$436.w,a6	; Max memoire utilisateur.
		sub.l	#(finsys-My_Sys),a6
		pea	(a6)
		pea	(finsys-My_Sys)	; Taille maxi a charger.
		move.w	d7,-(sp)	; handle
		move.w	#$3f,-(sp)	; FREAD
		trap	#1
		lea	12(sp),sp
		move.l	d0,d6		; Taille reelle du system
		move.w	d7,-(sp)	; handle
		move.w	#$3e,-(sp)	; FCLOSE
		trap	#1
		addq.l	#4,sp
		move.l	#'LEO!',($200-8).w
		move.l	a6,($200-4).w
		jmp	(a6)

hellotxt	dc.b	27,'E'
		dc.b	'ATARI-PC system.',10,13
		dc.b	'(C)OXYGENE 1995 by Leonard.',10,13,10,13,0

errortxt	dc.b	7,'LEO_PC.SYS not found.',10,13,0

normaltxt
		dc.b	'SYSTEM skipped, starting',10,13
		dc.b	'normal ST boot...',0

sysloadtxt	dc.b	'Installing, please wait.',10,13,0

sysname		dc.b	'LEO_PC.SYS',0

		even
finboot:
	rept	480/8
	dc.b	'LEONARD!'
	endr
	even


;*******************************************************************

;*******************************************************************






;*******************************************************************
;*******************************************************************
;*******************************************************************
;*******************************************************************
;*******************************************************************
;*******************************************************************
;*******************************************************************

FLAGSTE		equ	0
RAMTOP		equ	2
SCREEN_SYS	equ	6
TOWER_AD	equ	10


READ_WAIT_MI	macro
		move.w	(a5),d0		; 02
		bmi.s	*-2		; 02
		move.w	(a5),d0		; 02
;		bmi.s	*-6
		bmi.s	*-2
		endm
READ_WAIT_PL	macro
		move.w	(a5),d0		; 02
		bpl.s	*-2		; 02
		move.w	(a5),d0		; 02
;		bpl.s	*-6
		bpl.s	*-2
		endm


My_Sys
		bra.s	.start
		dc.b	'LEO!'
.start:

	IFNE	LDEBUG
		bsr	ldebuger
	ENDC
	;----------------------------------------------
	; STE ou STF ??
	;----------------------------------------------
		lea	mybss(pc),a6
		sf	FLAGSTE(a6)
		movea.w	#$820d,a0
		clr.b	(a0)
		add.b	#8,(a0)
		cmpi.b	#8,(a0)
		bne.s	.stf
		sub.b	#8,(a0)
		bne.s	.stf
		st	FLAGSTE(a6)
.stf:

	;----------------------------------------------
	; Cherche le TOP physique de la RAM.
	;----------------------------------------------

		lea	My_Sys(pc),a0
		move.l	a0,d0
		eor.b	d0,d0			; TOP RAM multiple de 256 octets.
		move.l	d0,RAMTOP(a6)
		subi.l	#32000,d0
		move.l	d0,SCREEN_SYS(a6)
		subi.l	#65536,d0
		move.l	d0,TOWER_AD(a6)

Reset

		lea	binaryOk(pc),a6
		sf	(a6)
		bsr	Set_Screen

	;*****************************************************

		lea	txt_welcome(pc),a0
		bsr	Sys_Print
		bsr	built_tower
		bra	wait_send


True_Reset:	move.l	#'LEO!',$200.w
		clr.l	$426.w
		clr.l	$42a.w
		move.l	$4.w,a0
		jmp	(a0)

Set_Screen
		lea	mybss(pc),a6
		move.l	SCREEN_SYS(a6),a0
		move.w	#1,-(sp)
		pea	(a0)
		pea	(a0)
		move.w	#5,-(sp)
		trap	#14
		lea	12(sp),sp
		move.l	#$0fff0000,$ffff8240.w
		clr.l	$ffff8244.w
		pea	.txt(pc)
		move.w	#9,-(sp)
		trap	#1
		addq.l	#6,sp
		rts
.txt:		dc.b	27,'E',0
		even



wait_send
		lea	txt_wait(pc),a0
		bsr	Sys_Print

		move.w	#$2700,sr

		lea	$ffff8800.w,a6
		moveq	#BLOCK_INFO_SIZE/2-1,d1			; 8octets pour block_info.
		lea	tempInfos(pc),a1

		lea	$ffff9202,a5
.wait_255:	cmpi.b	#57,$fffffc02.w
		beq	True_Reset
		move.w	(a5),d0
		bmi.s	.wait_255


	;------------------------------------------------
	; reception du block info
	;------------------------------------------------
.w1:		READ_WAIT_MI
		move.b	d0,(a1)+
		READ_WAIT_PL
		move.b	d0,(a1)+
		dbf	d1,.w1


	;------------------------------------------------
	; Reception du block binaire.
	;------------------------------------------------
;		lea	txt_receive(pc),a0
;		bsr	Sys_Print

;		move.w	binaryMode(pc),d0
		move.w	tempInfos+10(pc),d0
		lea	binaryMode(pc),a0
		move.w	d0,(a0)
		cmpi.w	#BLOCK_RUN,d0
		beq	blockRun
		cmpi.w	#BLOCK_SAVE,d0
		beq	blockSave
		
		movem.l	tempInfos(pc),d0-d7
		lea	info_block(pc),a0
		movem.l	d0-d7,(a0)

		bsr	printBlockInfos
		
		move.l	binarySize(pc),d7
		move.l	d7,$200.w
		move.l	binaryAd(pc),a2		; Adresse de chargement.
		lea	$ffff9202.w,a5

		move.w	#$400,$ffff8240.w	; ROUGE: Debut de reception.

		moveq	#0,d6
		add.l	#BLOCK_SIZE-1,d7
	IFEQ	(BLOCK_SIZE-2048)
		lsr.l	#8,d7
		lsr.l	#3,d7
	ELSEIF
		fail
	ENDC

		lea	end_receive(pc),a4
		lea	mybss(pc),a6
		move.l	TOWER_AD(a6),a6
		jmp	(a6)

end_receive
		move.w	#$2300,sr
		move.w	#$0fff,$ffff8240.w

	;-------------------------------------------------
	; Checksum
	;-------------------------------------------------
		lea	txt_check(pc),a0
		bsr	Sys_Print

		move.l	binaryAd(pc),a0
		move.l	binarySize(pc),d7
		moveq	#0,d0
		moveq	#0,d1
.chk:		move.b	(a0)+,d0
		add.w	d0,d1
		subq.l	#1,d7
		bne.s	.chk

		move.w	binaryCheck(pc),d0
		move.w	d0,$204.w
		move.w	d1,$206.w
		cmp.w	d0,d1
		beq	CheckOk

		lea	txt_check_error(pc),a0
		bsr	Sys_Print
		move.w	#7,-(sp)
		trap	#1
		addq.w	#2,sp
		bra	Reset


CheckOk		lea	binaryOk(pc),a6
		st	(a6)

		move.w	binaryMode(pc),d0
		cmpi.w	#LOAD_ONLY,d0
		beq	wait_send
		cmpi.w	#FILE_COPY,d0
		beq	blockSave

blockRun:
		lea	binaryOk(pc),a0
		tst.b	(a0)
		beq	binaryNoOk
	IFNE	LDEBUG
		bsr	ldebuger
	ENDC
		lea	oldtrap+2(pc),a0
		tst.l	(a0)
		bne.s	.ok
		move.l	$84.w,(a0)
.ok:		lea	myTrap(pc),a0
		move.l	a0,$84.w
		move.l	binaryAd(pc),a0
		jmp	(a0)
		
myTrap:		move.w	6(sp),d0
		bne.s	oldtrap
		move.w	#$2300,sr
		addq.l	#6+2,sp
		bra	Reset
oldtrap:	jmp	$0


blockSave	lea	binaryOk(pc),a0
		tst.b	(a0)
		beq	binaryNoOk
		
		lea	.txt(pc),a0
		bsr	Sys_Print
		lea	.txt3(pc),a0
		move.l	binarySize(pc),d0
		bsr	printNumber
		lea	info_block+16(pc),a0
		bsr	Sys_Print
		lea	.txt2(pc),a0
		bsr	Sys_Print

		lea	info_block+16(pc),a0
		bsr	writeFile		
		
		bra	wait_send
		

	;**********************************************************		

.txt:		dc.b	'Writing file "',0
.txt2:		dc.b	'" ($'
.txt3:		dc.b	'xxxxxxxx bytes)...',10,13,0
		even		

writeFile:	clr.w	-(sp)		; Attribut normal.
		pea	(a0)		; Nom du fichier
		move.w	#$3c,-(sp)	; FCREATE
		trap	#1
		addq.l	#8,sp
		tst.l	d0
		bmi.s	.error
		move.w	d0,d7		; handle
		move.l	binaryAd(pc),-(sp)
		move.l	binarySize(pc),-(sp)
		move.w	d7,-(sp)
		move.w	#$40,-(sp)		; FWRITE
		trap	#1
		lea	12(sp),sp
		tst.l	d0
		bmi.s	.error
		move.w	d7,-(sp)
		move.w	#$3e,-(sp)		; FCLOSE
		trap	#1
		addq.l	#4,sp
		tst.l	d0
		bmi.s	.error
		rts
		
	;**********************************************************		
.error:		lea	.txtError(pc),a0
		bsr	Sys_Print
		bra	wait_send

.txtError:	dc.b	'BIOS Fwrite failed.',10,13,0
		even
		

binaryNoOk	lea	.txt(pc),a0
		bsr	Sys_Print
		bra	wait_send
.txt:		dc.b	'RUN ERROR:No binary block in memory.',10,13,0
		even


vbl		addq.l	#1,$466.w
		rte


;******************************************************************************

printBlockInfos	move.l	binarySize(pc),d0
		lea	.txt2(pc),a0
		bsr	printNumber
		move.l	binaryAd(pc),d0
		lea	.txt3(pc),a0
		bsr	printNumber
		lea	.txt(pc),a0
		bsr	Sys_Print
		rts

.txt:		dc.b	'Loading $'
.txt2:		dc.b	'xxxxxxxx bytes at '
.txt3:		dc.b	'xxxxxxxx adress...',10,13,0
		even

printNumber	movem.l	d1-d2,-(sp)
		moveq	#8-1,d1
.loop:		rol.l	#4,d0
		moveq	#15,d2
		and.w	d0,d2
		move.b	.tab(pc,d2.w),(a0)+
		dbf	d1,.loop
		movem.l	(sp)+,d1-d2
		rts

		rts
.tab:		dc.b	'0123456789ABCDEF'
		even

Sys_Print	pea	(a0)
		move.w	#9,-(sp)
		trap	#1
		addq.l	#6,sp
		rts

built_tower
		lea	mybss(pc),a6
		move.l	TOWER_AD(a6),a6
		move.l	a6,d7
		move.w	#BLOCK_SIZE/2-1,d0
.loop:		lea	inst1(pc),a0
.copy:		move.w	(a0)+,(a6)+
		tst.w	(a0)
		bne.s	.copy
		dbf	d0,.loop
		move.w	inst4(pc),(a6)+
		move.w	inst5(pc),(a6)+
		move.l	a6,d0
		sub.l	d0,d7
		move.w	d7,(a6)+
		move.w	inst6(pc),(a6)+
		rts

inst1:
		READ_WAIT_MI
		move.b	d0,(a2)+
		READ_WAIT_PL
		move.b	d0,(a2)+
		dc.w	0

inst4		subq.l	#1,d7		; 1 mot lu.
inst5		bne	inst1
inst6		jmp	(a4)



;save		dcb.l	8,0
;		dcb.l	8,0
;		dcb.l	8,0
;mfp		dcb.b	16,0
;		even
;xp		dc.w	0
;		dc.w	0
binaryOk:	dc.b	0
		even
info_block:
binarySize:	dc.l	0
binaryCheck:	dc.w	0
binaryAd:	dc.l	0
binaryMode:	dc.w	0
		ds.b	BLOCK_INFO_SIZE
		even
tempInfos	ds.b	BLOCK_INFO_SIZE
		even


;****************************************************************

mybss		ds.b	16

;****************************************************************
;font88		incbin	"griff.fnt"
;		even

txt_welcome	dc.b	'ST-PC System.',10,13
		dc.b	'(C)OXYGENE 1995 by Leonard.',10,13
		dc.b	'ST BIOS & XBIOS...: Installed.',10,13
		dc.b	'Leonard Debugger..: '
	IFNE	LDEBUG
		dc.b	'Installed.',10,13
	ELSEIF
		dc.b	'Not installed.',10,13
	ENDC
		dc.b	10,13,0
txt_wait	dc.b	'Waiting for PC command...(Press space to skip)',10,13,0
txt_check	dc.b	'Calculating checksum...',10,13,0
txt_check_error dc.b	'CHECKSUM ERROR.',10,13,0
		dc.b	'SPACE to restart.',0
		even
	IFNE	LDEBUG
ldebuger	incbin	"ldebug.bin"
		even
	ENDC
finsys:



	END


