/*
 * $Id: scroller_state.hpp 150 2007-11-08 23:44:59Z ehaase $
 *
 * What We Are
 *
 * Copyright (C) 1994 - 2007 Enver Haase
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */



#ifndef SCROLLER_STATE_HPP
#define SCROLLER_STATE_HPP

#include "main.hpp"
#include "state.hpp"
#include "bitmap/bitmap.hpp"
#include "timer.hpp"

class scroller_state :
	public state
{
public:
	scroller_state(void);
	~scroller_state(void);
	virtual void enterState(void) throw (GameException);
	virtual void exitState(void)  throw (GameException);
	virtual void update(void);
private:
    // "overkill" top animation
    static const unsigned int NUM_LOGO_FRAMES = 22;
    Bitmap *bitmaps[NUM_LOGO_FRAMES];

    Timer audio_timer;
    Timer overkill_timer; // A timer!
    DWORD lastElapsed;

    // "is what we are"
    Bitmap *isWhatWeAre;

    // scrolling member list
    Bitmap *members;

    // Frame for the members list
    RECT members_source_rect;
    RECT members_dest_rect;

    static const int MEMBERS_FROMLINE = 95;     // for dest rectangle
    static const int MEMBERS_NUMLINES = 130;

    static const int MEMBERS_BG_IDX = 252;      // members background color
    static const int BLINK_COL_IDX  = 253;
    PALETTEENTRY members_blinker[16];           // 16 colors used in one blinking palette index

    int             membersFrame(DWORD millisElapsed)   throw (GameException);
    unsigned int    overkillFrame(DWORD millisElapsed)  throw (GameException);
    unsigned int    colorFrame(DWORD millisElapsed)     throw (GameException);
};

#endif
