/*
 * $Id: compat.hpp 163 2007-11-14 18:39:08Z ehaase $
 *
 * What We Are
 *
 * Copyright (C) 1994 - 2007 Enver Haase
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */


#ifndef COMPAT_HPP
#define COMPAT_HPP

/* This header file allows compilation under older Visual C++ without
 * "safe" *_s functions in their standard environment.
 */

#if (_MSC_VER < 1400) /* If < version 8.0 */
#define _itoa_s(a, b, c, d) _itoa(a, b, d)
#define _ltoa_s _ltoa
// variadic macros were only introduced with MSVC8(or "2005"), part of C99 standard (*sigh*)
// #define sprintf_s(a, b, ...) sprintf(a, __VA_ARGS__)
#define sprintf_s(a,b,c,d,e,f,g,h,i,j,k) sprintf(a,c,d,e,f,g,h,i,j,k)
#define fopen_s(a,b,c) {*a = fopen(b,c);}
#define strncpy_s(dest, destSize, source, count) strncpy(dest, source, (destSize<count?destSize:count))
#define _TRUNCATE -1
#endif

#endif
