*****************************************************************************
* twist a gain
*
* a small 256 byte twister (including file header)
* for amiga ocs with sound...
*
* ultra^orb 20110526
*
*****************************************************************************

release         equ     1
plane           equ     $1f10
sinus           equ     $2000

bgcolor         equ     (79>>4)<<8+(111>>4)<<4+151>>4
barcolor1       equ     (223>>4)<<8+(189>>4)<<4+135>>4
barcolor2       equ     (143>>4)<<8+(121>>4)<<4+87>>4

        section shortig, code_c
*****************************************************************************
start
        ;create sin

        lea     copper+sinus(pc),a5
        move    #$385>>1,d4
        clr.l   d1

        ;stuff for the gfx generation
        move    #plane,a4
        moveq   #-8,d0
        clr.l   d5

        moveq   #127,d3
createsin
        add     d4,d1
        move.l  d1,d2
        asr     #7,d2
        move.b  d2,(a5)+
        neg     d2
        move.b  d2,128-1(a5)

        ;gfx generation
        move.l  d5,(a4)+
        move.l  d0,(a4)+
        add.l   d0,d0
        addx.l  d5,d5

        subq    #7,d4
        dbf     d3,createsin


mainloop:
        moveq   #$3b,d7
        clr     d6
        move    d5,d3
drawloop:
        lea     $dff000+$e0,a6
        lea     copper(pc),a0
        move.l  a0,$80-$e0(a6)

        ;get sin value for the current line
        ext.w   d3
        move.b  (a5,d3),d2
        add     d6,d2

        ;set audio buffer ptr... creates some kind of bassline
        ;ok nearly ;)

        ext.w   d2
        lea     (a5,d2),a4
        move.l  a4,$a0-$e0(a6)

sync
        cmp.b   $06-$e0(a6),d7
        bne.s   sync

        move    #plane,d0

        ;calc which of pregenerated gfx part
        ;should be used
        move.b  (a4),d1
        asr.b   #3,d1

        ;sub -$10 this is a bit tricky bitplane is at xx10
        sub.b   d0,d1
        bpl.s   ispos
        neg.b   d1
ispos
        lsl     #3,d1

        ;set bitplane pointers
        add     d1,d0
        move.l  d0,(a6)+

        move    #plane+(31*8),d0
        sub     d1,d0
        move.l  d0,(a6)

        ;handle priority of the bars via the color reg
        ;this reuses the colors which are set in the copper list
        ;to save some space
        addq    #2,a0
        add.b   #$44,d2
        bmi.s   isneg
        addq    #4,a0
isneg
        move    (a0),$186-$e4(a6)
        addq.b  #2,d6
        subq.b  #1,d3

        addq.b  #1,d7
        bcc.s   drawloop

        ;some sin movement
        subq    #2,d5

        if      release
        bra.s   mainloop
        else
        btst    #6,$bfe001
        bne.s   mainloop
        illegal
        endc

*****************************************************************************
;       dc.w    barcolor1,barcolor2
copper
        dc.w    $0182,barcolor1
        dc.w    $0184,barcolor2
        dc.w    $009a,$7fff             ; irqs off

        ; audio stuff
        dc.w    $00a4,$0010             ; len
        dc.w    $00a6,$0220             ; period
        dc.w    $00a8,$0030             ; volume
        dc.w    $0096,$8001             ; chan 1 on

        ; colors

        ; screen setup
        dc.w    $0096,$0020             ; sprites off
        dc.w    $008e,$3b81             ; window start
        dc.w    $0090,$ffd1             ; window stop
        dc.w    $0092,$0060-6           ; fetch start
        dc.w    $0094,$0060+84-6        ; fetch stop
        dc.w    $0100,$2200             ; 2 bitplanes

        ; bg color rasterlines
        dc.w    $3b01,$fffe
        dc.w    $0180,bgcolor
        dc.w    $ff01,$fffe
        dc.w    $0180,$0000
        dc.l    -2

*****************************************************************************
        printt  "size:"
        printv  *-start
*****************************************************************************
        end