//*****************************************************************************
//* tVIsteC 20
//*
//* 256 byte twister for vc 20 with sound
//* assembles fine with kickassembler
//*
//* ultra^orb 20131115
//*
//* (c) 2013 orb
//*****************************************************************************

.pc = $1001 "Basic Program"
:BasicUpstart($100d)
	
.pc =$100d "Program"

.var tmp1 = $40
.var scrpos = $40
.var tmp2 = $44
.var tmp3 = $42
.var adr1 = $46
.var tmp4 = $48
.var tmp5 = $49
.var tmp6 = $4a
.var incy = $4b

.var off1 = 108
.var off2 = 105
.var colorram = $9600
.var delbuf1 = $1200
.var delbuf2 = $1300
.var delbuf3 = $1400
.var sinpostab = $1500
.var sinbittab = $1600
.var sintab = $1700

.var screenmem = $0200
.var charmem = $1800

// use bittabe from the char rom... saves 8 bytes
.var bittab = $8268

start:
	sei
	// init memory
	// clears $1200-$8000
	// inits color ram
	// and fills the screen memory with the correct chars
	lda	#$12
	sta	adr1+1

	ldy #$00
	tya
initmem:
	sta	colorram,y
	sta	(adr1),y
	pha
	tya
	sta	screenmem,y
	pla
	dey
	bne	initmem
	inc	adr1+1
	bpl	initmem
	iny
	sty	tmp1+1

	// creates the 3 sin tables
	// a normal sintable
	// a bit set sintable
	// and a position sintable
	// that speeds up drawing alot
	ldx	#128
	stx	$900f
		
createsin:
	// tmp1 = tmp1 - 4
	// tmp2 = tmp2 + tmp1
	lda	tmp1
	sbc	#4
	sta	tmp1
	bcs	*+4
	dec	tmp1+1
	adc	tmp2
	sta	tmp2
	lda	tmp2+1
	adc	tmp1+1
	sta	tmp2+1

	// save sine value
	jsr	storesin
	txa
	pha
	ora	#$80
	tax
	
	// create neg sine value
	lda	tmp2+1
	eor #$ff
	jsr	storesin
	pla
	tax
	
	dex
	bne	createsin

mainloop:
	
	
	// setup screen
	ldx	#6
setup:
	lda vdat-1,x
	sta	$9000-1,x
	dex
	bne setup

	// setup draw loop
	stx	scrpos
	ldx	#32
	stx	tmp2+1
	ldx	#>charmem
	stx	scrpos+1

	lda	incy
	adc	#3
	sta incy
	
drawer2:
	lda #08
	sta	tmp2
drawer:
	
	//clear old stuff
	ldx	tmp4
	lda	#0
	ldy	delbuf1,x
	sta	(scrpos),y
	ldy	delbuf2,x
	sta	(scrpos),y
	ldy	delbuf3,x
	sta	(scrpos),y
	
	lda	incy
	adc	sintab,x
    sta $900c
	sta	tmp5
 
	// draw the 3 lines
	jsr	plot
	sta	delbuf1,x
    sta $900e

	lda	tmp5
	adc	#85
	jsr	plot
	sta	delbuf2,x

	lda	tmp5
	adc	#170
	jsr	plot
	sta	delbuf3,x

	inc	scrpos		//next line
	inc	tmp4
	dec	incy
	dec	tmp2
	bne	drawer		//loop 8 lines
	
	lda	scrpos		//next char block
	clc
	adc	#64-8
	sta	scrpos
	bcc	*+4
	inc	scrpos+1

	dec	tmp2+1		//loop 32 lines
	bne	drawer2
	beq	mainloop

storesin:
	sta	sintab-1,x
	clc
	adc	#$20
	pha
	and	#$7
	tay
	lda	bittab,y
	sta	sinbittab-1,x
	pla
	and	#$f8
	sta	sinpostab-1,x
	rts
plot:
	tax
	sec
	sbc	#off1
	cmp	#256-off2-off1
	bcc	nodraw
	lda	sintab,x
	ldy	sinpostab,x
	lda	sinbittab,x
	sta	(scrpos),y
nodraw:
	tya
	ldx	tmp4
	rts

vdat:	
	.byte $1a,$17,$88,32<<1,$00,$8e

end:
	.print end-start
	.print end-$1001+2