;*****************************************************************************
;* pet video mode
;*
;* code:    ultra
;* created: 10.11.2010
;*
;* assembled with dasm
;*
;*****************************************************************************
screen60Hz	equ	0
screencenter	equ	0

;-----------------------------------------------------------------------------
;some words about the video chip....
;
;the pet has a crtc it's an old video chip find some docs about it here:
;http://www.6502.org/users/andre/hwinfo/crtc/crtc.html
;
;a modified version of the crtc is also build in in the cpc 464...
;pet has some extra video memory starting at $8000... on 4032
;it's only 1 kb... this is why the effects are that small...
;the 8032 has 2 kb of screen memory...
;
;the video chip itself is for it's time quite flexibel...
;you can create the syncs where you want to have them and so on...
;so be careful...
;do not mess the horizontal and vertical timing...!
;otherwise the 4032 screen will not sync...
;
;esp. the regs:
;  r0 hor. total
;  r2 sync position
;  r4 vert. total
;  r7 vert. sync
;  r5 vert. adjust
;
;only change these values if you know what you are doing ! ;)
;as you can see this is why the demo works only on 50hz... because
;i'm changing the timing of the video chip
;
;
;how the video mode works...
;
;every pixel on screen is 2*3 pixels big...
;
;after reading the docs you surely have recognised that you can change
;the char height of each charater... (reg 9)
;i'm changing the height to 3 lines...
;
;which means every char on screen is shrinked to 3 lines on screen...
;if you find some more or less fitting chars you can create some kind
;of hi res... so each byte in screen memory represents 4 pixels on screen
;find at the bottom my selected chars...
;
;if you want to use it jsr one of the setup routines...
;like:
;
;			
;	jsr setup128_32	;switching the resolution
;
;	ldx #%0011	;4 pixels 
;	lda b2ctab,x	;convert it to chars
;	sta $8000	;write to screen
;
;
;as you maybe seen the displayed chars in x and y you can set with
;
;  r1 hor. displ
;  r6 vert. displ
;
;so you can create any "resolution" you want so far it fits into
;the 1kb screen memory...
;
;if the screen is bigger the 4032 will mirror the stuff...
;this is for example how the endscroll works by setting
;the screen mem position and the pet mirrors the stuff...
;quite useful...
;btw. setting the screen works only once a vbl
;
;but i really recommend to read the docs of the crtc... !
;
;
;screen60Hz	equ	0
;screencenter	equ	0
;
;screencenter... is only for testing things... unforunately centering (v and h sync pos)
;is not emulated in vice... i could not test so i always leave them to 0
;60hz seems to work... the twister video was recorded in 60hz...

;*****************************************************************************
setregcrtc:
;a reg
;x value
        sta     $e880
        stx     $e881
        rts
;*****************************************************************************
setupnormal:
;grabbed from the roms

	ldy #$11
setnormalloop
	lda ($c7),y	; pointer: tape buffer/ screen scrolling
	sty $e880	; 6545/6845 crt					chip
	sta $e881
	dey
	bpl setnormalloop
	rts
normvid
	dc.b $31, $28, $29, $0F, $31, $00, $19, $25  ;1().1..%
	dc.b $00, $07, $00, $00, $10, $00, $00, $00  ;........
	dc.b $00                       ;.
;*****************************************************************************
setup128_32:
	jsr     switchchartable1

;       -------------------
;       screen size
;       -------------------

        ;R0 (hor. total)
        ;org value 49
        lda     #0
        ldx     #49
        jsr     setregcrtc

        ;R1 (hor. displ)
        ;org value 40
        lda     #1
        ldx     #32
        jsr     setregcrtc

	if screencenter
        ;R2 sync position
        ;org value 41
        lda     #2
        ldx     #41-10
        jsr     setregcrtc
        else
        ;R2 sync position
        ;org value 41
        lda     #2
        ldx     #41
        jsr     setregcrtc
        endif

;       -------------------
;       vertical timing
;       -------------------
;scanlines total
; old timing
; (R9+1)*(R4+1)+R5



	if screen60Hz

; 	new timing 60 hz 333 lines
; 	(2+1)*(103+1)+21 = 401 ?

        ;R4 (vert. total)
        ;org value 39
        lda     #4
        ldx     #103-1
        jsr     setregcrtc

        ;R7 (vert. sync)
        ;org value 32
        ;80 centered ?
        lda     #7
        ldx     #70
        jsr     setregcrtc
        ;R5 (vert. adjust)
        ;org value 0
        lda     #5
        ldx     #24
        jsr     setregcrtc

	else

; 	new timing 50 hz 400 lines
; 	(2+1)*(124+1)+26 = 401 ?

        ;R4 (vert. total)
        ;org value 39
        lda     #4
        ldx     #124
        jsr     setregcrtc

        ;R7 (vert. sync)
        ;org value 32
        ;80 centered ?
        lda     #7
        ldx     #80
        jsr     setregcrtc

        ;R5 (vert. adjust)
        ;org value 0
        lda     #5
        ldx     #25
        jsr     setregcrtc

	endif



        ;R6 (vert. displ)
        ;org value 25
        lda     #6
        ldx     #32
        jsr     setregcrtc


        ;R9 (scanlines/char-1)
        ;org value 8
        lda     #9
        sta     $e880
        lda     #2
        sta     $e881

        rts
;*****************************************************************************
setup80_50:
	jsr     switchchartable1
;       -------------------
;       screen size
;       -------------------

        ;R0 (hor. total)
        ;org value 49
        lda     #0
        ldx     #49
        jsr     setregcrtc

        ;R1 (hor. displ)
        ;org value 40
        lda     #1
        ldx     #20
        jsr     setregcrtc

	if screencenter
        ;R2 sync position
        ;org value 41
        lda     #2
        ldx     #41-10
        jsr     setregcrtc
        else
        ;R2 sync position
        ;org value 41
        lda     #2
        ldx     #41
        jsr     setregcrtc
        endif

;       -------------------
;       vertical timing
;       -------------------
;scanlines total
; old timing
; (R9+1)*(R4+1)+R5



	if screen60Hz

; 	new timing 60 hz 333 lines
; 	(2+1)*(103+1)+21 = 401 ?

        ;R4 (vert. total)
        ;org value 39
        lda     #4
        ldx     #103-1
        jsr     setregcrtc

        ;R7 (vert. sync)
        ;org value 32
        ;80 centered ?
        lda     #7
        ldx     #70
        jsr     setregcrtc
        ;R5 (vert. adjust)
        ;org value 0
        lda     #5
        ldx     #24
        jsr     setregcrtc

	else

; 	new timing 50 hz 400 lines
; 	(2+1)*(124+1)+26 = 401 ?

        ;R4 (vert. total)
        ;org value 39
        lda     #4
        ldx     #124
        jsr     setregcrtc

        ;R7 (vert. sync)
        ;org value 32
        ;80 centered ?
        lda     #7
        ldx     #80
        jsr     setregcrtc

        ;R5 (vert. adjust)
        ;org value 0
        lda     #5
        ldx     #25
        jsr     setregcrtc

	endif



        ;R6 (vert. displ)
        ;org value 25
        lda     #6
        ldx     #50
        jsr     setregcrtc


        ;R9 (scanlines/char-1)
        ;org value 8
        lda     #9
        sta     $e880
        lda     #2
        sta     $e881

        rts
;*****************************************************************************
setup64_64:
	jsr     switchchartable1
;       -------------------
;       screen size
;       -------------------

        ;R0 (hor. total)
        ;org value 49
        lda     #0
        ldx     #49
        jsr     setregcrtc

        ;R1 (hor. displ)
        ;org value 40
        lda     #1
        ldx     #16
        jsr     setregcrtc

	if screencenter
        ;R2 sync position
        ;org value 41
        lda     #2
        ldx     #41-10
        jsr     setregcrtc
        else
        ;R2 sync position
        ;org value 41
        lda     #2
        ldx     #41
        jsr     setregcrtc
        endif

;       -------------------
;       vertical timing
;       -------------------
;scanlines total
; old timing
; (R9+1)*(R4+1)+R5



	if screen60Hz

; 	new timing 60 hz 333 lines
; 	(2+1)*(103+1)+21 = 401 ?

        ;R4 (vert. total)
        ;org value 39
        lda     #4
        ldx     #103-1
        jsr     setregcrtc

        ;R7 (vert. sync)
        ;org value 32
        ;80 centered ?
        lda     #7
        ldx     #70
        jsr     setregcrtc
        ;R5 (vert. adjust)
        ;org value 0
        lda     #5
        ldx     #24
        jsr     setregcrtc

	else

; 	new timing 50 hz 400 lines
; 	(2+1)*(124+1)+26 = 401 ?

        ;R4 (vert. total)
        ;org value 39
        lda     #4
        ldx     #124
        jsr     setregcrtc

        ;R7 (vert. sync)
        ;org value 32
        ;80 centered ?
        lda     #7
        ldx     #80
        jsr     setregcrtc

        ;R5 (vert. adjust)
        ;org value 0
        lda     #5
        ldx     #25
        jsr     setregcrtc

	endif



        ;R6 (vert. displ)
        ;org value 25
        lda     #6
        ldx     #64
        jsr     setregcrtc


        ;R9 (scanlines/char-1)
        ;org value 8
        lda     #9
        sta     $e880
        lda     #2
        sta     $e881

        rts

 	endif

;*****************************************************************************
switchchartable1:
        lda     #12
        sta     $E84C
        rts
switchchartable2:
        lda     #12
        sta     $E84C
        rts
;*****************************************************************************
b2ctab:
;bitmap to char tab

;       00000000
        dc.b    $20

;       00000011
        dc.b    $6a

;       00001100
        dc.b    $48     ;hmhmm

;       00001111
        dc.b    $ff

;       00110000
        dc.b    $47     ;hmhmm

;       00110011
        dc.b    $22     ;hmmhmm

;       00111100
        dc.b    $42     ;hmmmhmmhmmm

;       00111111
        dc.b    $f4

;       11000000
        dc.b    $74

;       11000011
        dc.b    $c2     ;hmmmhmmhmmm

;       11001100
        dc.b    $a2     ;hmmhmm

;       11001111
        dc.b    $c7     ;hmhmm

;       11110000
        dc.b    $7f

;       11110011
        dc.b    $c8     ;hmhmm

;       11111100
        dc.b    $ea

;       11111111
        dc.b    $a0