
; PET soundz
;
; Compiles with DASM
;
; Music driver. This, however, you do need.
; 
; jsr orgaddress   - setup player.
; jsr orgaddress+3 - call each frame.
		
rst = $00
c_1 = $01
cs1 = $02
d_1 = $03
ds1 = $04
e_1 = $05
f_1 = $06
fs1 = $07
g_1 = $08
gs1 = $09
a_1 = $0a
as1 = $0b
b_1 = $0c
c_2 = $0d
cs2 = $0e
d_2 = $0f
ds2 = $10
e_2 = $11
f_2 = $12
fs2 = $13
g_2 = $14 
gs2 = $15
a_2 = $16
as2 = $17
b_2 = $18
c_3 = $19
cs3 = $1a
d_3 = $1b
ds3 = $1c
e_3 = $1d
f_3 = $1e
fs3 = $1f
g_3 = $20 
gs3 = $21
a_3 = $22
as3 = $23
b_3 = $24
c_4 = $25
cs4 = $26
d_4 = $27
ds4 = $28
e_4 = $29
f_4 = $2a
fs4 = $2b
g_4 = $2c 
gs4 = $2d
a_4 = $2e
as4 = $2f
b_4 = $30
off = $ff

in0 = $00
in1 = $01
in2 = $02
in3 = $03
in4 = $04
in5 = $05
in6 = $06
in7 = $07
in8 = $08
in9 = $09
ina = $0a
inb = $0b
inc = $0c
ind = $0d
ine = $0e
inf = $0f


		jmp songsetup
		jmp songstart
		
songsetup

		lda #0
		sta $e848
		lda #$10
		sta 59467
		
		rts
		
songstart

	lda tempo
	cmp #$ff
	beq newtempo
	jmp justinstrument

newtempo
	lda pattpos
	cmp #$10
	bne stillpattern

	lda #$00
	sta pattpos
	
	lda songloop
	cmp #$ff
	beq nopattloop
	dec songloop
	bpl restartsong
	
nopattloop
	inc songpos	
restartsong
	ldy songpos
	lda songtab,y
	cmp #$ff
	bne nosongreset
	; if you need the song to restart at a different position change this #$00
	lda #$00
	sta songpos
	bpl restartsong
	
nosongreset

	sta mustemp
	and #$0f
	asl
	asl
	asl
	asl
	sta pattoffset
	lda songloop
	cmp #$ff
	bne stillpattern
	lda mustemp
	and #$f0
	lsr
	lsr
	lsr
	lsr
	sta songloop

stillpattern

	clc
	lda pattpos
	adc pattoffset
	tay
	ldx pattnotetab,y
	cpx #$ff

	bne notrest
	txa
	jmp itsrest
notrest
	cpx #$00
	beq useprevious
	lda notelo,x

itsrest
	sta currnote
	lda pattinsttab,y

	sta currinst
	asl
	asl
	asl
	sta instoffset
	ldy currinst
	lda instlength,y
	sta notelength
	lda instrepeat,y
	sta instmax
	lda instsweep,y
	sta currsweep
	lda #$00
	sta instpos
	sta sweepfreq
useprevious	
	inc pattpos
	

	inc currtemp
	lda currtemp
	and #$01
	sta currtemp
	tay
	lda tempolist,y
	sta tempo

justinstrument

	lda notelength
	cmp #$00
	bne keepnote
	jmp silencenote

keepnote	
	lda currnote
	cmp #$ff
	bne playnote
silencenote
	lda #$00

	sta $e848

	jmp dontplaynote

playnote
	clc
	lda instoffset
	adc instpos
	tay
	lda currnote
	adc sweepfreq
	sta $e848
	lda instwavetab,y
	sta 59466
	
	clc
	lda sweepfreq
	adc currsweep
	sta sweepfreq
	
	dec notelength
	lda notelength
	cmp #$ff
	bne dontsilence
	lda #$00
	sta currnote
dontsilence
	
	inc instpos
	lda instpos
	cmp #$08
	bne dontplaynote
	lda instmax
	sta instpos
	
	;sta $e848
	;lda #$10
	;sta 59467
	;lda #35
	;sta 59466

dontplaynote

	dec tempo
	
	rts	
	
songtab
			
		.byte $02,$13
		.byte $44,$35,$30,$15,$04,$01
		.byte $06,$01,$07,$01
		.byte $06,$00,$07,$01
		.byte $35,$30,$15,$04,$01
		.byte $06,$01,$07,$01
		.byte $06,$00,$07,$01	
		.byte $08,$03
		.byte $39
		.byte $2a,$01
		.byte $2b,$01,$2b,$01
		.byte $06,$00,$07,$01
		.byte $06,$00,$07,$01
		.byte $08,$03
		.byte $02,$03
		.byte $1c,$1d,$1c,$1d
		.byte $1e,$1f,$1e,$1f
		.byte $1c,$1d,$1c,$1d
		.byte $ff
		
		
pattnotetab

;                                              beat number
;                      0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f
;                                                                                      pattern number
		.byte c_1,rst,rst,c_2,e_1,ds2,c_1,c_2,c_1,ds1,as1,c_2,e_1,ds2,g_2,c_2 ;0
		.byte c_1,f_1,rst,g_2,e_1,g_2,ds1,g_2,c_1,f_1,g_2,g_2,e_1,g_2,e_1,e_1 ;1
		.byte c_1,rst,rst,rst,rst,rst,rst,rst,rst,rst,rst,rst,rst,rst,rst,rst ;2 ; tv noise
		.byte rst,rst,rst,rst,rst,rst,rst,rst,rst,rst,rst,rst,rst,rst,rst,rst ;3 ; tv noise silence
		.byte g_1,rst,rst,c_2,rst,rst,g_1,rst,rst,c_2,rst,rst,g_1,as1,rst,rst ;4 ; intro
		.byte c_1,g_1,c_1,c_2,f_2,c_1,g_1,c_1,c_1,c_2,rst,c_1,f_2,as1,rst,c_2 ;5 ; intro with drums
		.byte fs1,f_1,ds1,c_1,f_2,rst,g_2,g_2,c_1,g_2,g_2,c_1,f_2,rst,c_1,rst ;6
		.byte f_1,fs1,g_1,as1,f_2,rst,g_2,g_2,c_1,g_2,g_2,c_1,f_2,rst,a_1,rst ;7
		.byte c_3,rst,rst,rst,rst,rst,rst,rst,rst,rst,rst,rst,rst,rst,rst,rst ;8 ; mega noise
		.byte c_1,c_3,c_1,rst,f_2,g_2,c_2,g_3,c_1,c_3,c_1,rst,f_2,f_2,c_3,as1 ;9 ; serious
		.byte c_1,c_3,c_1,c_1,c_1,g_1,f_2,g_2,c_1,c_3,c_1,c_3,c_1,f_1,c_2,as2 ;a ; more serious
		.byte c_1,c_3,c_1,c_1,c_1,g_1,f_2,g_2,c_1,c_3,c_1,c_3,c_1,c_3,c_2,as2 ;b ; more serious snare
 		.byte c_3,b_2,e_2,c_1,f_2,c_3,c_1,b_2,c_1,g_2,e_2,c_1,b_2,f_2,g_2,c_2 ;c ; middle c maj
 		.byte cs3,b_2,e_2,a_1,f_2,cs3,a_1,b_2,a_1,gs2,e_2,a_1,b_2,f_2,e_1,a_2 ;d ; middle a maj
 		.byte g_3,c_1,c_1,f_3,f_2,c_2,e_3,c_1,c_2,b_2,c_1,c_2,f_2,c_1,c_2,c_1 ;e ; middle 2 c maj
 		.byte gs3,a_1,c_1,fs3,f_2,a_2,e_3,c_1,a_1,gs2,c_1,a_1,f_2,c_1,a_1,a_2 ;f ; middle 2 f maj

pattinsttab

;                                              beat number
;                      0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f
;                                                                                      pattern number
		.byte in0,in0,in1,in4,in2,in4,in3,in4,in8,in3,in4,in4,in2,in4,in1,in3 ;0
		.byte in8,in3,in1,in1,in2,in1,in3,in1,in0,in3,in1,in1,in2,in1,in2,in2 ;1
		.byte in5,in0,in0,in0,in0,in0,in0,in0,in0,in0,in0,in0,in0,in0,in0,in0 ;2
		.byte in0,in0,in0,in0,in0,in0,in0,in0,in0,in0,in0,in0,in0,in0,in0,in0 ;3
		.byte in6,in6,in6,in6,in6,in6,in6,in6,in6,in6,in6,in6,in6,in6,in6,in6 ;4
		.byte in8,in6,in3,in7,in2,in3,in6,in3,in8,in6,in6,in3,in2,in7,in6,in3 ;5
		.byte in9,in9,in9,in9,in2,in0,in1,in1,in8,in1,in1,in8,in2,in0,in1,in0 ;6
		.byte in9,in9,in9,in9,in2,in0,in1,in1,in8,in1,in1,in8,in2,in0,in0,in0 ;7
		.byte ina,in0,in0,in0,in0,in0,in0,in0,in0,in0,in0,in0,in0,in0,in0,in0 ;8
		.byte in3,in4,inb,in0,in2,in3,in4,in3,in3,in4,inb,in0,in2,in3,in4,in3 ;9
		.byte inc,in4,inb,in8,inc,in3,in1,in3,inc,in4,inb,in1,inc,in3,in7,in4 ;a
		.byte inc,in4,inb,in8,in2,in3,in1,in3,inc,in4,inb,in1,in2,in3,in7,in4 ;b
 		.byte ind,ind,ind,in8,in2,ind,in3,ind,in8,ind,ind,in3,ind,in2,ind,in3 ;c
 		.byte ind,ind,ind,in8,in2,ind,in3,ind,in8,ind,ind,in3,ind,in2,ind,in3 ;d
 		.byte ine,in3,in8,ine,in2,in3,ine,in8,in3,ine,in8,in3,in2,inc,in3,in3 ;e
 		.byte ine,in3,in8,ine,in2,in4,ine,in8,inb,ine,in8,in3,in2,inc,in3,in4 ;f

			
instwavetab
;							instrument number
		.byte $3c,$3a,$38,$36,$34,$32,$30,$2e ; 0 long bd
		.byte $3c,$11,$00,$00,$00,$00,$00,$00 ; 1 cowbell
		.byte $3c,$3c,$3c,$3c,$3c,$3c,$3c,$3c ; 2 snare
		.byte $3c,$0f,$0f,$19,$05,$04,$05,$3c ; 3 bass
		.byte $01,$02,$03,$04,$c2,$c1,$c0,$bf ; 4 short bass
		.byte $01,$3c,$03,$02,$04,$01,$00,$02 ; 5 tv noise
		.byte $3c,$55,$55,$03,$02,$01,$00,$00 ; 6 melody lead
		.byte $07,$06,$05,$04,$03,$02,$01,$01 ; 7 melody lead 2
		.byte $3c,$3c,$3c,$3c,$00,$00,$00,$00 ; 8 bdrum
		.byte $55,$11,$35,$34,$33,$32,$31,$30 ; 9 horn 
		.byte $11,$11,$11,$11,$11,$11,$11,$11 ; a mega noise
		.byte $3c,$11,$05,$55,$07,$03,$02,$1f ; b long bass
		.byte $3c,$3c,$3c,$3c,$3c,$3c,$3c,$3c ; c long bd2
		.byte $5c,$0c,$03,$3c,$5c,$00,$00,$00 ; d middle lead
		.byte $3c,$3c,$00,$04,$05,$00,$00,$00 ; e middle lead 2


                   ;    0   1   2   3   4   5   6   7   8   9   a   b   c   d   e
instlength
		.byte $1f,$02,$1c,$05,$03,$ff,$0f,$1f,$01,$3f,$ff,$0f,$02,$1f,$1f
instrepeat
		.byte $00,$00,$00,$07,$04,$00,$00,$02,$03,$07,$03,$01,$01,$03,$00
instsweep
		.byte $0f,$7f,$11,$00,$00,$97,$00,$00,$0f,$00,$81,$00,$07,$00,$00
		
		
songpos
		.byte $ff
songloop
		.byte $00
pattpos
		.byte $10
pattoffset
		.byte $00
currtemp
		.byte $01
tempo
		.byte $ff
tempolist
		.byte $05,$05		
currnote
		.byte $00
notelength
		.byte $00
currinst
		.byte $00
instpos
		.byte $00
instoffset
		.byte $00
instmax
		.byte $00
currsweep
		.byte $00	
sweepfreq
		.byte $00		
mustemp
		.byte $00
		
notelo 
		.byte 00,251,238,224,210,199,188,177,168,158,149,140,133
		.byte 125,118,110,104,99,93,88,83,78,74,69,65
		.byte 62,59,55,52,49,46,44,41,39,37,34,32
		.byte 31,29,27,26,24,23,22,20,19,18,17,16
