*****************************************************************************
* Benot
*
* a small 252 mandelbrot (including file header)
* for amiga ocs...
*
* ultra^orb 20150409
*
*****************************************************************************
release         equ     1
plane           equ     $1f00
planelen	equ	40*170
minIm           equ     -1
maxIm           equ     1
minRe           equ     -2
maxRe           equ     1
xSize           equ    	320
ySize           equ    	160

fixedmul	equ	$100
fixedshift	equ	8

        section shortig, code_c
*****************************************************************************
; a0 = x
; a1 = y
; d1 = im
; d2 = re
; d3 = zi
; a6 = zr
; d5 = a
; d6 = b
; d7 = bits
start
        if      release=0
        moveq   #1,d0
        moveq   #1,d4
        lea     start-4,a3
        endc
        lea     copper(pc),a0
        lea     $dff080,a6
        move.l  a0,(a6)

        ;clear bitplane
        move    #plane+(planelen*3),a5
        move    #(planelen*3/4)-1,d0
clr
        clr.l   -(a5)
        dbf     d0,clr

        moveq	#$021,d0
setcol:
        move	d0,$100(a6)
	addq	#2,a6
        add	#$210,d0
        cmp	#$10a1,d0
        bne.s	setcol

        move	#minIm*fixedmul+$10,d1
        ;for y
	sub.l	a1,a1
	moveq	#$10,d7
yloop:

	move	#minRe*fixedmul+$60,d2
	;for x
	sub.l	a0,a0
xloop:

        ;zr = re
        move	d2,a6
        ;zi = im
        move	d1,d3

        ; for n
        moveq	#0,d4
nloop
        ; a=zr*zr;

        move	a6,d5
        muls	d5,d5
        asr.l	#fixedshift,d5

        ; b=zi*zi;
        move	d3,d0
        muls	d0,d0
        asr.l	#fixedshift,d0
        move	d0,d6
	add	d5,d0
	cmp	#2*fixedmul,d0
	bgt.s	stop

	;Zi=2*Zr*Zi+Im;
	move	a6,d0
	add	d0,d0
	muls	d0,d3
        asr.l	#fixedshift,d3
	add	d1,d3

	;Zr=a-b+Re;
	sub	d6,d5
	add	d2,d5
	move	d5,a6
	addq	#1,d4
	cmp	#14,d4
	bne.s	nloop

stop:
	lsr	#2,d4
	roxl	(a5)
	roxr	d4
	roxl	planelen(a5)
	roxr	d4
	roxl	planelen*2(a5)

	subq	#1,d7
	bne.s	nores
	moveq	#$10,d7
	addq.l	#2,a5
nores
        addq    #((maxRe-minRe)*fixedmul)/xSize,d2
	addq.w	#1,a0
	cmp	#xSize,a0
	bne.s	xloop
        addq    #((maxIm-minIm)*fixedmul)/ySize,d1

	addq	#1,a1
	cmp	#ySize,a1
	bne.s	yloop
mainloop:

        if      release
        bra.s   mainloop
        else
        btst    #6,$bfe001
        bne.s   mainloop
        illegal
        endc

*****************************************************************************

copper
        ;colors
	dc.w	$0108,$0000
	dc.w	$010a,$0000
        dc.w    $009a,$7fff             ; irqs off
	dc.w	$00e0,plane>>16
	dc.w	$00e2,plane&$ffff
	dc.w	$00e4,plane>>16
	dc.w	$00e6,(plane&$ffff)+planelen
	dc.w	$00e8,plane>>16
	dc.w	$00ea,(plane&$ffff)+planelen*2
        ;screen setup
        dc.w    $0096,$0020             ; sprites off
        dc.w    $008e,$4b81             ; window start
        dc.w    $0090,$f0d1             ; window stop
        dc.w    $0092,$0038             ; fetch start
        dc.w    $0094,$00d0         	; fetch stop
        dc.w    $0100,$3200


*****************************************************************************
        printt  "size:"
        if      release=1
        printv  *-start
        printv  *-start+38
        else
        printv  *-start-20
        printv  *-start-20+38
        endc
*****************************************************************************

        end