/*
 * Andreas 'Yup' Schneider's Vertical Blanc Interrupt
 *
 * VBI working under DOS and WIN95 !!!
 *
 * Copyright (C) Andreas 'Yup' Schneider. All Rights Reserved.
 *
 * E-Mail   : yup@mindless.com
 *
 * Homepage : http://privat.swol.de/AndreasSchneider/
 *
 */

#ifndef __AYS_VBI_H
#define __AYS_VBI_H

#ifdef __cplusplus
extern "C" {
#endif

// Functions

extern int	TimerIrqInit();
#pragma aux TimerIrqInit parm [eax ebx] value [eax];
extern void	TimerIrqClose();
extern void	CheckDosWinTimer();

// Variables

extern char cIfTimerDos;
extern long lFrameCount;
extern short VBLTimerWert;


// inline Function

int	GetTimer0(void);
#pragma aux GetTimer0 =\
		"cli",\
		"xor	eax,eax",\
		"mov	al,00000100b",\
		"out	43h,al",\
		"nop",\
		"nop",\
		"in	al,40h",\
		"mov	ah,al",\
		"nop",\
		"in	al,40h",\
		"xchg	al,ah",\
		"sti",\
		modify [ax] value [eax];


#ifdef __cplusplus
};
#endif

#endif
