                .286
                .model tiny
;		.stack 200h
;                 jumps
;                 smart
                 version t250
.data
  ScrMaxX     EQU  320
  ScrMaxY     EQU  200

  R           db   100 ; optimized !! ;  R           dw   100 
  P_Min       dd   -2.25
  P_Step      dd   0.0109375	; (P_max - P_Min) / ScrMaxX
  Q_Max       dd   1.50		; Q = Q_Max
  Q_Step      dd   0.015	; (Q_Max - Q_Min) / ScrMaxY


.code
  org 	  100h

  mov     ax, 0013h
  int     10h

;  cld
  mov     dx, 3c8h
  mov     al, 0
  out     dx, al
  inc     dx
@l:
  out     dx, al
  out     dx, al
  out     dx, al
  inc     al
  jnz     @l

;  cli
  push    0a000h
  pop     es
  xor     bx, bx  
  mov     si, ScrMaxX
  mov     di, ScrMaxY

  fninit
  fild    word ptr R
  fld     Q_Max
  fld     P_Min
  fld     P_Step

@NextPixel:
  xor     cl, cl
  fldz
  fldz

@NextIteration:
  fadd    st, st(0)
  fadd    st, st(4)
  fld     st(0)
  fmul    st, st
  fld     st(0)
  fxch    st(3)
  fadd    st, st(5)
  fmul    st(2), st
  fmul    st, st
  fsubr   st(3), st
  faddp   st(1), st(0)
  fcomp   st(6)
  fstsw   ax
  sahf
  ja      @GetOut
  dec     cl
  jnz     @NextIteration

@GetOut:
  fcompp  st(1)			; pop two regs
  fadd    st(1), st

  add     cl, 64
  mov     byte ptr es:[bx], cl
  inc     bx
  dec     si
  jnz     @NextPixel		; End of line ? NO->JUMP

  fcompp  st(1)
  fsub    Q_Step
  fld     P_Min
  fld     P_Step

  mov     si, ScrMaxX
  dec     di
  jnz     @NextPixel

;  sti
  xor     ax, ax
  int     16h
  mov     ax, 0003h
  int     10h
  ret
end