/*****************************************************************************
 *
 * File: vguigad.c, Fredrik Kling 1997
 * Desc: This file holds all main gadget handling routines...
 *
 * Updates:
 * -- Date -- | ----- Name ----- |-- Did what....
 * 1997-08-11 | Fredrik Kling    | Implementation
 *
 ****************************************************************************/
#include "system/xstdio.h"
#include "vgui/vguigad.h"
#include "vgui/vguiwin.h"
#include "vgui/vgui.h"
#include "system/xstdlib.h"
//#include <malloc.h>

VGUIGADGET *vguigad_gadfrmhand (int handle)
{
	VGUIWIN *win = vgui_activewin ();
	VGUIGADGET *gad;
	int i;

	gad = win -> gadgetlist;
	for (i=0;i<win->numgadget;i++)
	{
		if  (handle == gad->handle) return gad;
		gad = gad -> next;
	}

	return NULL;
}
int vguigad_disposelist (void)
{
	VGUIWIN *win = vgui_activewin ();
	VGUIGADGET *next,*gad;
	int i;

	if (win->gadgetlist==NULL) return FALSE;
	next = win->gadgetlist;
	for (i=0;i<win->numgadget;i++)
	{
		gad = next;
		next = gad->next;

		switch (gad->type)
		{
			case VGUIGAD_CBOX : xfree (gad->cbox); break;
			case VGUIGAD_SBOX : xfree (gad->sbox); break;
		}
		xfree (gad);
	}
	win->tabnum = 0;
	win->tabpos = 0;
	win->numgadget = 0;
	win->gadgetlist = NULL;

	return TRUE;
}
VGUIGADGET *vguigad_insert (int x1, int y1, int x2, int y2, char *caption, int type, int handle)
{
	VGUIWIN *win = vgui_activewin ();
	VGUIGADGET *gad;
	int s,ofs;
	int yofs;

	ofs = win->numgadget;
	win->numgadget++;

	if (win->gadgetlist == NULL)
	{
		gad = win->gadgetlist = (VGUIGADGET *) xmalloc (sizeof (VGUIGADGET));
	} else
	  {
			gad = win -> gadgetlist;
			while (gad->next != NULL) gad=gad->next;
			gad->next = (VGUIGADGET *) xmalloc (sizeof (VGUIGADGET));
			gad = gad -> next;
	  }

	gad -> handle = handle;
	gad -> type = type;

	yofs=4;
	if (win->caption!=NULL) yofs+=12;
	if (win->mbar!=NULL) yofs+=12;

	gad -> x1 = x1+win->x1+2;
	gad -> x2 = x2+win->x1+2;
	gad -> y1 = y1+win->y1+yofs;

	if ((y2+win->y1+yofs) > win->y2) gad->y2 = win->y2-4;
		else gad -> y2 = y2+win->y1+yofs;

	gad -> next = NULL;

	sprintf (gad->caption,"%s",caption);

	switch (type)
	{
		case VGUIGAD_DAB :
				gad->dab = (VGUIDAB *) xmalloc (sizeof (VGUIDAB));
				gad->dab->buff = vguidab_init (vgui_getdriver(),gad->x1,gad->y1,gad->x2,gad->y2);
				vguidab_clear (vgui_getdriver (), gad->dab->buff);
				break;

		case VGUIGAD_TBOX :
				gad->tbox = (VGUITEXTBOX *)xmalloc (sizeof (VGUITEXTBOX));
				gad->tbox->text = NULL;
				break;
		case VGUIGAD_BUTT :
				vgui_addtabstop (VGS_COMMAND,VGC_BUTTON,handle,0);
				break;
		case VGUIGAD_CBOX :
				vgui_addtabstop (VGS_COMMAND,VGC_CHECK,handle,0);
				gad->cbox = (VGUICHECKBOX *) xmalloc (sizeof (VGUICHECKBOX));
				gad->cbox->state = 0;
				gad->cbox->flags = 0;
				break;
		case VGUIGAD_SBOX :
				gad->sbox = (VGUISTRINGBOX *) xmalloc (sizeof (VGUISTRINGBOX));
				gad->sbox->string[0]='\0';
				vgui_addtabstop (VGS_COMMAND,VGC_SBOX,handle,0);
				break;
		case VGUIGAD_LBOX :
				gad->lbox = (VGUILISTBOX *) xmalloc (sizeof (VGUILISTBOX));
				vguilbox_init (gad->lbox);
				vgui_addtabstop (VGS_COMMAND,VGC_SBOX,handle,0);
				break;
	} // Switch
	return gad;
}
void vguigad_draw (int handle)
{
	//VGUIWIN *win = vgui_activewin ();
	VGUIGADGET *gad;

	gad = vguigad_gadfrmhand (handle);

	switch (gad->type)
	{
		case VGUIGAD_BUTT :
						vguibutt_draw (gad->x1, gad->y1, gad->x2, gad->y2, gad->caption);
						vgui_postmessage (VGS_GADUPDATE,handle,0,0);
						break;
		case VGUIGAD_SBOX :
						vguisbox_draw (gad->x1, gad->y1, gad->x2, gad->y2, gad->caption,gad->sbox->string);
						vgui_postmessage (VGS_GADUPDATE,handle,0,0);
						break;
		case VGUIGAD_BORD :
						vguibord_draw (gad->x1, gad->y1, gad->x2, gad->y2, gad->caption);
						vgui_postmessage (VGS_GADUPDATE,handle,0,0);
						break;
		case VGUIGAD_CBOX :
						vguicbox_draw (gad->x1, gad->y1, gad->x2, gad->y2, gad->caption,gad->cbox->state);
						vgui_postmessage (VGS_GADUPDATE,handle,0,0);
						break;
		case VGUIGAD_TBOX :
						vguitext_draw (gad->x1, gad->y1, gad->x2, gad->y2, gad->caption,gad->tbox->text);
						//vgui_postmessage (VGS_GADREDRAW,handle,0,0);
						vgui_postmessage (VGS_GADUPDATE,handle,0,0);
						break;
		case VGUIGAD_LBOX :
						vguilbox_draw (gad->x1, gad->y1, gad->x2, gad->y2, gad->caption,gad->lbox);
						vgui_postmessage (VGS_GADUPDATE,handle,0,0);
						break;
		case VGUIGAD_DAB  :
						vguidab_redraw (vgui_getdriver (),gad->dab->buff,gad->x1,gad->y1);
//						vgui_postmessage (VGS_GADREDRAW,handle,0,0);
						break;
		default : return;
	}
}

void vguigad_highlight (int handle)
{
	//VGUIWIN *win = vgui_activewin ();
	VGUIGADGET *gad;

	gad = vguigad_gadfrmhand (handle);

	switch (gad->type)
	{
		case VGUIGAD_BUTT :
				vguibutt_highlight (gad->x1, gad->y1, gad->x2, gad->y2, gad->caption);
				vgui_postmessage (VGS_GADUPDATE,handle,0,0);
				break;
		case VGUIGAD_SBOX :
				vguisbox_highlight (gad->x1, gad->y1, gad->x2, gad->y2, gad->caption,gad->sbox->string);
				vgui_postmessage (VGS_GADUPDATE,handle,0,0);
				break;
		case VGUIGAD_LBOX :
				vguilbox_highlight (gad->x1, gad->y1, gad->x2, gad->y2, gad->caption,gad->lbox);
				vgui_postmessage (VGS_GADUPDATE,handle,0,0);
 				break;
		case VGUIGAD_CBOX :
				vguicbox_highlight (gad->x1, gad->y1, gad->x2, gad->y2, gad->caption);
				vgui_postmessage (VGS_GADUPDATE,handle,0,0);
				break;
		default : return;
	}
}
void vguigad_select (int handle)
{
	//VGUIWIN *win = vgui_activewin ();
	VGUIGADGET *gad;

	gad = vguigad_gadfrmhand (handle);

	switch (gad->type)
	{
		case VGUIGAD_BUTT :
				vguibutt_select (gad->x1, gad->y1, gad->x2, gad->y2, gad->caption);
			 	vgui_postmessage (VG_COMMAND, VGC_BUTTON,handle, 0);
				vgui_postmessage (VGS_GADUPDATE,handle,0,0);
				break;
		case VGUIGAD_SBOX :
				vguisbox_select (gad->x1, gad->y1, gad->x2, gad->y2, gad->caption,gad->sbox->string);
				vgui_postmessage (VG_COMMAND, VGC_SBOX, handle, 0);
				vgui_postmessage (VGS_GADUPDATE,handle,0,0);
				break;
		case VGUIGAD_CBOX :
				if (gad->cbox->state) gad->cbox->state = 0;
					else gad->cbox->state = 1;
				vguicbox_select (gad->x1, gad->y1, gad->x2, gad->y2, gad->caption, gad->cbox->state);
				vgui_postmessage (VG_COMMAND, VGC_CHECK, handle, 0);
				vgui_postmessage (VGS_GADUPDATE,handle,0,0);
				break;
		case VGUIGAD_LBOX :
				vguilbox_select (gad->x1, gad->y1, gad->x2, gad->y2, gad->caption,gad->lbox,handle);
				vgui_postmessage (VGS_GADUPDATE,handle,0,0);
				break;

		default : return;
	}

}




