/*****************************************************************************
 *
 * File: vguibutt.c, Fredrik Kling 1997
 * Desc: This file holds all main button handling routines...
 *
 * Updates:
 * -- Date -- | ----- Name ----- |-- Did what....
 * 1997-08-12 | Fredrik Kling    | Implementation
 *
 ****************************************************************************/
#include "vgui/vgui.h"
#include "vgui/vguibutt.h"

void vguibutt_draw (int x1, int y1, int x2, int y2, char *caption)
{
	int xp,yp;
	vgui_bar (x1,y1,x2,y2,VG_CMEDIUM);

	vgui_line (x1, y1,x2,y1,VG_CBLACK);
	vgui_line (x1, y1,x1,y2,VG_CBLACK);
	vgui_line (x1, y2,x2+1,y2,VG_CBLACK);
	vgui_line (x2, y1,x2,y2,VG_CBLACK);

	vgui_line (x1+1, y1+1,x2-1,y1+1,VG_CLIGHT);
	vgui_line (x1+1, y1+1,x1+1,y2-1,VG_CLIGHT);
	vgui_line (x1+1, y2-1,x2,y2-1,VG_CDARK);
	vgui_line (x2-1, y1+1,x2-1,y2-1,VG_CDARK);

	xp = 2+((x2 - x1) - vgui_strlen (caption))/2;

	yp = 2+((y2 - y1) - 8) / 2; // 10 = font Y-size

	vgui_printfxyc (x1+xp,y1+yp,VG_CBLACK,"%s",caption);
}

void vguibutt_highlight (int x1, int y1, int x2, int y2, char *caption)
{
	int xp,yp;
	vgui_bar (x1,y1,x2,y2,VG_CMEDIUM);

	vgui_line (x1, y1,x2,y1,VG_CBLACK);
	vgui_line (x1, y1,x1,y2,VG_CBLACK);
	vgui_line (x1, y2,x2+1,y2,VG_CBLACK);
	vgui_line (x2, y1,x2,y2,VG_CBLACK);

	vgui_line (x1+1, y1+1,x2-1,y1+1,VG_CLIGHT);
	vgui_line (x1+1, y1+1,x1+1,y2-1,VG_CLIGHT);
	vgui_line (x1+1, y2-1,x2,y2-1,VG_CDARK);
	vgui_line (x2-1, y1+1,x2-1,y2-1,VG_CDARK);

	xp = 2+((x2 - x1) - vgui_strlen (caption))/2;

	yp = 2+((y2 - y1) - 8) / 2; // 10 = font Y-size

	vgui_printfxyc (x1+xp,y1+yp,VG_CWHITE,"%s",caption);
}
void vguibutt_select (int x1, int y1, int x2, int y2, char *caption)
{
	int xp,yp;
	vgui_bar (x1,y1,x2,y2,VG_CMEDIUM);

	vgui_line (x1, y1,x2,y1,VG_CBLACK);
	vgui_line (x1, y1,x1,y2,VG_CBLACK);
	vgui_line (x1, y2,x2+1,y2,VG_CBLACK);
	vgui_line (x2, y1,x2,y2,VG_CBLACK);

	vgui_line (x1+1, y1+1,x2-1,y1+1,VG_CDARK);
	vgui_line (x1+1, y1+1,x1+1,y2-1,VG_CDARK);
	vgui_line (x1+1, y2-1,x2,y2-1,VG_CDARK);
	vgui_line (x2-1, y1+1,x2-1,y2-1,VG_CDARK);

	xp = ((x2 - x1) - vgui_strlen (caption))/2;
	yp = ((y2 - y1) - 8) / 2; // 10 = font Y-size
	vgui_printfxyc (x1+xp+3,y1+yp+3,VG_CWHITE,"%s",caption);

}


