#include "system/xstdio.h"
#include "system/xstddef.h"
#include "system/xstring.h"
#include "formats/v3d.h"
#include "formats/vio.h"
#include "vmath/vmath.h"
#include "vmath/matrix.h"
#include "render/rnddrv.h"
#include "drivers/drv8.h"
#include "misc/col.h"
//#include "debug/mono.h"
#include "vgui/vgui.h"

#if defined(__DOS__)
#define DRIVER vesaDRV
#elif defined(__NT__)
#define DRIVER dxDRV
#endif

extern DRV DRIVER;
static DRV *drv = &DRIVER;
static BUFF *buff = NULL;

#define RENDER scpDRV

extern RNDDRV RENDER;
static RNDDRV *render = &RENDER;


RGB palette[256];

void mymain (int,int,int,int);

VGUIWIN mywin;
VGUIWIN app2;

#define MBAR_DRIVER 1000
	#define MBAR_DRIVER_GFX 1010
	#define MBAR_DRIVER_RND 1012
	#define MBAR_DRIVER_PRC 1014

#define MBAR_HELP 1100
	#define MBAR_HELP_ABOUT 1101

KEYL mxklist[]={{VG_XALT_D,VGS_COMMAND,VGC_MBAR,MBAR_DRIVER,0},
								{VG_XALT_S,VGS_COMMAND,VGC_MBAR,2,0},
								{VG_XALT_H,VGS_COMMAND,VGC_MBAR,3,0}};

KEYL a2xklist[]={{VG_XALT_T,VGS_COMMAND,VGC_MBAR,1,0}};

char *info="Hello\nTesting this\nehh\nSkriv inte for\nmycket text i rutan...\n\nFiskben";
char *about_text="\n\nExempel pa gui...\n\n\nKnappen sie bitte...\n\nFisk 1997!!";

static void gfx_driver (void)
{
  vguiwin_clearUA();

	vguigad_disposelist ();
	vguigad_insert (10,10,150,150,"Graphics:",VGUIGAD_BORD,0);
	vguigad_insert (20,20,90,40  ,"Vesa 2.0 Hi-res",VGUIGAD_CBOX,1);
	vguigad_insert (20,45,90,65  ,"Vesa 2.0 Low-res",VGUIGAD_CBOX,2);
	vguigad_insert (20,70,90,90  ,"Win 32 Dx 3.0",VGUIGAD_CBOX,3);
	vguigad_insert (20,95,90,115 ,"Mystique Native",VGUIGAD_CBOX,4);
	vguigad_insert (20,120,90,140,"MCGA 320x200",VGUIGAD_CBOX,5);
}
static void rnd_driver (void)
{
	vguiwin_clearUA();
	vguigad_disposelist ();

	vguigad_insert (10,10,150,150,"Rendering:",VGUIGAD_BORD,0);
	vguigad_insert (20,20,90,40  ,"Realtime Z-buffer.",VGUIGAD_CBOX,1);
	vguigad_insert (20,45,90,65  ,"Realtime Z-sorting.",VGUIGAD_CBOX,2);
	vguigad_insert (20,70,90,90  ,"Raytraceing (good)",VGUIGAD_CBOX,3);
	vguigad_insert (20,95,90,115 ,"Raytraceing (poor)",VGUIGAD_CBOX,4);
	vguigad_insert (20,120,90,140,"Wireframe.",VGUIGAD_CBOX,5);
}
static void prc_driver (void)
{
	vguiwin_clearUA();
	vguigad_disposelist ();

	vguigad_insert (10,10,150,165,"Processor:",VGUIGAD_BORD,0);
	vguigad_insert (20,20,90,40  ,"Pentium PRO",VGUIGAD_CBOX,1);
	vguigad_insert (20,45,90,65  ,"AMD K6",VGUIGAD_CBOX,2);
	vguigad_insert (20,70,90,90  ,"Pentium II",VGUIGAD_CBOX,3);
	vguigad_insert (20,95,90,115 ,"Pentium MMX",VGUIGAD_CBOX,4);
	vguigad_insert (20,120,90,140,"Pentium (normal)",VGUIGAD_CBOX,5);
	vguigad_insert (20,145,90,165,"486 or lower",VGUIGAD_CBOX,6);

}
static void my_about (void)
{
	VGUIGADGET *gad;
	vguiwin_clearUA ();
	vguigad_disposelist ();

	gad = vguigad_insert (10,4,150,150,"About:",VGUIGAD_TBOX,1);
	gad -> tbox -> text = about_text;

}
void app2init (void)
{
	VGUIGADGET *gad;
	app2.mbar = vguimbar_create ();
	vguimbar_insertbaritem (app2.mbar,1,"Test");
	vguimbar_insertlistitem (app2.mbar,1,10,"Heja",0);
	vguimbar_insertlistitem (app2.mbar,1,11,"App2",0);


	vguiwin_resize (NULL,320,200);

	vguigad_insert (10,05,80,20,"KNAPP!",VGUIGAD_BUTT,1);
	vguigad_insert (10,30,140,50,"Skriv:",VGUIGAD_SBOX,2);
	gad = vguigad_insert (10,60,150,180,"textbox",VGUIGAD_TBOX,3);
	gad->tbox->text = info;

	vgui_setxkeylist (a2xklist,1);

}
void myinit (void)
{
	mywin.mbar = vguimbar_create ();
	vguimbar_insertbaritem (mywin.mbar,MBAR_DRIVER,"Drivers");
	vguimbar_insertbaritem (mywin.mbar,2,"Scene");
	vguimbar_insertbaritem (mywin.mbar,3,"Help");

	vguimbar_insertlistitem (mywin.mbar,2,30,"Wheels (in the factory)",0);
	vguimbar_insertlistitem (mywin.mbar,2,31,"Engine (hi-speed)",0);
	vguimbar_insertlistitem (mywin.mbar,2,0,"",VGUIMBAR_SEPARATOR);
	vguimbar_insertlistitem (mywin.mbar,2,32,"Worm",0);
	vguimbar_insertlistitem (mywin.mbar,2,33,"Live in love",0);

	vguimbar_insertlistitem (mywin.mbar,MBAR_DRIVER,MBAR_DRIVER_GFX,"Graphical drivers",0);
	vguimbar_insertlistitem (mywin.mbar,MBAR_DRIVER,MBAR_DRIVER_RND,"Rendring drivers",0);
	vguimbar_insertlistitem (mywin.mbar,MBAR_DRIVER,MBAR_DRIVER_PRC,"Processor settings",0);
	vguimbar_insertlistitem (mywin.mbar,MBAR_DRIVER,0,"",VGUIMBAR_SEPARATOR);
	vguimbar_insertlistitem (mywin.mbar,MBAR_DRIVER,12,"Save config",0);
	vguimbar_insertlistitem (mywin.mbar,MBAR_DRIVER,13,"Restore config",0);
	vguimbar_insertlistitem (mywin.mbar,MBAR_DRIVER,0,"",VGUIMBAR_SEPARATOR);
	vguimbar_insertlistitem (mywin.mbar,MBAR_DRIVER,VGS_EXIT,"Quit (no save)",0);

	vguimbar_insertlistitem (mywin.mbar,3,MBAR_HELP_ABOUT,"About SAGA",0);
	vguimbar_insertlistitem (mywin.mbar,3,21,"Help (what is this?)",0);
	vguimbar_insertlistitem (mywin.mbar,3,22,"Gurkmajones",0);

	vgui_setxkeylist (mxklist,3);
	vguiwin_resize (NULL,180,200);
}

void mymain (int mess, int p1,int p2,int p3)
{
	switch (mess)
	{
		case VG_COMMAND : switch (p1)
											{
												case VGC_MBAR :
																vguiwin_clearUA();
																switch (p2)
																{
																	case MBAR_DRIVER_GFX : gfx_driver (); break;//vguiwin_printfxy (0,10,"File-open"); break;
																	case MBAR_DRIVER_RND : rnd_driver (); break;//vguiwin_printfxy (0,10,"File-close"); break;
																	case MBAR_DRIVER_PRC : prc_driver (); break;
																	case MBAR_HELP_ABOUT : my_about (); break;
																	case VGS_EXIT : vgui_postmessage (VGS_EXIT,0,0,0); break;
																}
																break;
/*

												case VGC_BUTTON :
																switch (p2)
																{
																	case VG_ID_OK :
																			vguiwin_clearUA ();
																			vguigad_disposelist();
																			break;
																}
																break;
*/
											}
											break;
/*
		case VG_KEYPRESS :vguiwin_clearUA();
											if (p1) vguiwin_printfxy (0,0,"key: %i    ",p1);
												else vguiwin_printfxy (0,0,"xkey: %i  ",p2);
										 break;
*/
		case VG_HELLOW : myinit ();
										 break;
	}
}
void app2main (int mess,int p1,int p2, int p3)
{
	switch (mess)
	{
		case VG_HELLOW :
			app2init ();
			break;
	}
}
void close (void)
{
	drv->exit ();
	mathclose ();
}

void init (void)
{
  int i;


	if (!drv->setup ())
	{
    printf ("[!] Error: Driver setup failed!\n");
		exit (1);
	} else {
           printf(" Available modes:\n");
					 for( i=0; i<drv->modes; i++)
             printf("  - %dx%d\n", drv->modelist[i].width, drv->modelist[i].height);
				 }

  //if(!drv->init(drv->modelist[0].width, drv->modelist[0].height, 0))
  if(!drv->init(640, 480, 0))
	{
    printf("[!] Error: Unable to initilize %s.(%s)\n", drv->name, drv->geterror());
		exit(0);
	}
  if (!drv->mouseinit( 0, 0, drv->width - 1, drv->height - 1))
	{
		drv->exit();
    printf("[!] Error: Unable to initilize mousedriver.\n");
		exit(0);
	}
  buff = drv->createbuff( drv->width, drv->height);
	drv->setbuff( buff);

	for (i=0;i<255;i++)
	{
		palette[i].r = 255;
		palette[i].g = 255;
		palette[i].b = 255;
	}
  drv->setpalette( palette);
}


void main (void)
{
	init ();

	// Preset some default values...

	vguiwin_setup (&mywin);

	mywin.handle = 1;
	mywin.caption = (char *)xmalloc (sizeof (char) * 256);
	sprintf (mywin.caption,"Testa");
	mywin.vgui_main = &mymain;


	vguiwin_setup (&app2);

	app2.x1 = 160;
	app2.y1 = 20;
	app2.x2 = 320;

	app2.handle = 2;
	app2.caption = (char *)xmalloc (sizeof (char) * 256);
	sprintf (app2.caption,"App2");
	app2.vgui_main = &app2main;


	vgui_init (drv,FALSE);
	vgui_register (&mywin);
	vgui_register (&app2);
	vguiwin_update (NULL);
	vgui_main ();
	close ();
}


