/*--------------------------------------------------------------------------
 * File: xyclip.c
 * Written by: Alexander Boczar, 1996-xx-xx
 * Description: Clipper for X/Y-axis
 *
 * Updates:
 * -- Date -- | ----- Name ----- |-- Did what....
 * 1996-xx-xx | Alexander Boczar |
 *
 * Todo:
 *
 -------------------------------------------------------------------------------*/

#include "system/xstddef.h"
#include "misc/clip.h"

#define X1 p1[0]
#define X2 p2[0]
#define Y1 p1[1]
#define Y2 p2[1]
#define XD td[0]
#define YD td[1]

int xyclip( int count, float *p1, float *p2, int minx, int maxx, int miny, int maxy)
{
	float t,td[16];
	int i;

/* Klipp frst med hnsyn till X */

	if ((X1 > maxx) || (X1 < minx) || (X2 > maxx) || (X2 < minx))
	{
		for( i=0; i<count; i++)
			td[i] = p2[i] - p1[i];

		if ((X1 > maxx) || (X1 < minx))
		{
			if (X1 > maxx)
			{
				if (X2>maxx)
					return( FALSE);
				t = (maxx - X1) / XD;
				for( i=0; i<count; i++)
					p1[i] += td[i] * t;
			}
			if (X1 < minx)
			{
				if (X2<minx)
					return( FALSE);
				t = (minx - X1) / XD;
				for( i=0; i<count; i++)
					p1[i] += td[i] * t;
			}
		}
		if ((X2 > maxx) || (X2 < minx))
		{
			if (X2 > maxx)
			{
				t = (maxx - X2) / XD;
				for( i=0; i<count; i++)
					p2[i] += td[i] * t;
			}
			if (X2 < minx)
			{
				t = (minx - X2) / XD;
				for( i=0; i<count; i++)
					p2[i] += td[i] * t;
			}
		}

	}

/* Klipp nu med hnsyn till Y */

	if ((Y1>maxy) || (Y1<miny) || (Y2>maxy) || (Y2<miny))
	{
		for( i=0; i<count; i++)
			td[i] = p2[i] - p1[i];

		if ((Y1>maxy) || (Y1<miny))
		{
			if (Y1>maxy)
			{
				if (Y2>maxy)
					return( FALSE);
				t = (maxy - Y1) / YD;
				for( i=0; i<count; i++)
					p1[i] += td[i] * t;
			}
			if (Y1<miny)
			{
				if (Y2<miny)
					return( FALSE);
				t = (minx - Y1) / YD;
				for( i=0; i<count; i++)
					p1[i] += td[i] * t;
			}
		}
		if ((Y2>maxy) || (Y2<miny))
		{
			if (Y2>maxy)
			{
				t = (maxy - Y2) / YD;
				for( i=0; i<count; i++)
					p2[i] += td[i] * t;
			}
			if (Y2<miny)
			{
				t = (miny - Y2) / YD;
				for( i=0; i<count; i++)
					p2[i] += td[i] * t;
			}
		}

	}
	return( TRUE);
}

