#pragma once

//#ifndef __COL_H
//#define __COL_H

#ifdef __WATCOMC__
#pragma library("misc.lib")
#endif

#ifdef __cplusplus
extern "C" {
#endif

//---------------------------------------------------------------------------//

#include "system/xstddef.h"

#define LIGHTLEVELS 64

typedef struct s_RGB RGB;
typedef struct s_BGR BGR;
typedef struct s_RGBA RGBA;
typedef struct s_BGRA BGRA;
typedef struct s_RGBC RGBC;

#pragma pack( push, 1)

struct s_RGB
{
	unsigned char r;
	unsigned char g;
	unsigned char b;
};


struct s_BGR
{
	unsigned char b;
	unsigned char g;
	unsigned char r;
};

struct s_RGBA
{
	unsigned char r;
	unsigned char g;
	unsigned char b;
	unsigned char a;
};

struct s_BGRA
{
  unsigned char b;
	unsigned char g;
  unsigned char r;
  unsigned char a;
};

struct s_RGBC
{
	unsigned char r;
	unsigned char g;
	unsigned char b;
	unsigned char c;
};

#pragma pack( pop)

int findcolor( RGB *palette, RGB color);
void remapdata( RGB *palette, RGB *imgpal, BYTE *imgdata, int width, int height);
int convert24to8( RGB *palette, RGB *image24, BYTE *image8, DWORD size);
int convert32to8( RGB *palette, RGBA *image32, BYTE *image8, DWORD size);
int makepalette( RGB *palette, RGB *list, int colors);
int makelighttab( BYTE *lighttab, RGB *palette, RGB ambient, RGB light);
int maketranstab( BYTE *transtab, RGB *palette, float left, float right);
int inittab();
int addlighttab( BYTE *lighttab, RGB ambient, RGB light);
int addtranstab( BYTE *transtab, float left, float right);
int maketab( RGB *palette);

//---------------------------------------------------------------------------//

#ifdef __cplusplus
}
#endif
//#endif
