/**************************************************************************
 * File: vector.c
 * Version: SAGA 4.0
 * Written by: Fredrik Kling, 1997-05-03
 * Description: Mathroutines for vector calculations..
 *
 * Updates: Alot, mainly fixes with the camera.
 * -- Date -- | --- Name ---- |-- Did what....
 * 1997-05-03 | Fredrik Kling | Tog ver det som fanns i gamla saga...
 * 1997-05-07 | Fredrik Kling | translate,scale + ndrade namn p funktioner...
 *
 ****************************************************************************/

#include "system/xmath.h"
#include "system/xstdio.h"
#include "system/xstdlib.h"
#include "vmath/vector.h"
#include "vmath/vmath.h"

float vector_length (VECTOR *v)
{
  return( (float)sqrt (SQR (v->x) + SQR (v->y) + SQR (v->z)));
}

#ifndef __WATCOMC__
float dotproduct (VECTOR *v1,VECTOR *v2)
{
  return (v1->x*v2->x+v1->y*v2->y+v1->z*v2->z);
}
#endif

//#ifndef __WATCOMC__
void vector_crossprod (VECTOR *v1, VECTOR *v2, VECTOR *dv)
{
  dv->x = v1->y*v2->z - v1->z*v2->y;
  dv->y = v1->z*v2->x - v1->x*v2->z;
  dv->z = v1->x*v2->y - v1->y*v2->x;
}
//#endif

void vector_normalize (VECTOR *v)
{
  float len;
  len = vector_length (v);
  v->x=v->x/len;
  v->y=v->y/len;
  v->z=v->z/len;
}
float vector_angle (VECTOR *v1,VECTOR *v2)
{
  return (dotproduct (v1,v2)/(vector_length (v1)*vector_length (v2)));
}
void vector_translate (VECTOR *v,float a, float b, float c)
{
	v->x+=a;
	v->y+=b;
	v->z+=c;
}
void vector_scale (VECTOR *v,float f)
{
	v->x*=f;
	v->y*=f;
	v->z*=f;
}
void vector_create (int x1, int y1, int z1, int x2, int y2, int z2,VECTOR *v)
{
	v->x = x2 - x1;
	v->y = y2 - y1;
	v->z = z2 - z1;
}

void vector_sub (VECTOR *v1, VECTOR *v2)
{
	v2->x -= v1->x;
	v2->y -= v1->y;
	v2->z -= v1->z;
}
void vector_add (VECTOR *v1, VECTOR *v2)
{
	v2->x += v1->x;
	v2->y += v1->y;
	v2->z += v1->z;
}