/*****************************************************************************
 *
 * File: vguitext.c, Fredrik Kling 1997
 * Desc: Simple text window..  static texts only....
 *
 * Updates:
 * -- Date -- | ----- Name ----- |-- Did what....
 * 1997-08-12 | Fredrik Kling    | Implementation
 *
 ****************************************************************************/
#include "vgui/vgui.h"
#include "vgui/vguitext.h"


void vguitext_draw (int x1, int y1, int x2, int y2, char *caption, char *text)
{
	int len;

	len = vgui_strlen (caption);

	vgui_bar (x1,y1,x2,y2,VG_CMEDIUM);

	vgui_printfxyc (x1+8,y1,VG_CBLACK,caption);
	y1+=4;

	vgui_line (x1,y1,x1+6,y1,VG_CDARK);
	vgui_line (x1+10+len,y1,x2,y1,VG_CDARK);

	vgui_line (x1,y1-1,x1+6,y1-1,VG_CLIGHT);
	vgui_line (x1+10+len,y1-1,x2+1,y1-1,VG_CLIGHT);

	vgui_line (x1,y1,x1,y2,VG_CLIGHT);
	vgui_line (x1+1,y1,x1+1,y2,VG_CDARK);

	vgui_line (x1+1,y2-1,x2,y2-1,VG_CDARK);
	vgui_line (x2-1,y1,x2-1,y2,VG_CDARK);

	vgui_line (x1,y2,x2+1,y2,VG_CLIGHT);
	vgui_line (x2,y1,x2,y2,VG_CLIGHT);

	if (text!=NULL)	vgui_printfxyc (x1+4,y1+4,VG_CBLACK,text);

}


