/*--------------------------------------------------------------------------
 * File: plot16.c
 * Written by: Fredrik Kling, 1997-11-16
 * Description: Plotter function for 16bits drivers.. based on Alexander Boczar's code..
 *
 * Updates:
 * -- Date -- | ----- Name ----- |-- Did what....
 * 1997-11-16 | Fredrik Kling    | Converted the plotter to 16bits..
 * 1997-04-02 | Alexander Boczar | Snabbade upp ngt med constanta varibler
 *
 -------------------------------------------------------------------------------*/

#include "drivers/drv16.h"
#include "system/xmath.h"
#include "misc/col.h"
/*
	the texture-mapper...
	idea:

	esi - 16 bit texture offset
	edi - screen image

				mov	x_add,<texture_xadd>
				mov	y_add,<texture_yadd>
t_loop:

				mov	ax,[esi + ebx*2]	; read texture value..
				mov	[edi],ax

x_add		add	edx,0000
y_add		add
				add	edi,2
				dec	ecx
				jne	t_loop


*/

void plot16( BUFF *buff, XYZ p, RGBA col )
{
	int offset_b;
  RGBA *image;
  int *zbuffer;
  int x = fchop( p.x) , y = fchop( p.y), z;

  if ( (x < buff->minx) || (x > buff->maxx) || (y < buff->miny) || (y > buff->maxy) )
		return;

	offset_b = x + y * 640;
	image = &buff->image[offset_b];

	if( buff->zbuffer != NULL)
	{
    z = fchop( p.z * 65536);
    zbuffer = &buff->zbuffer[ offset_b];
    if ( z < *zbuffer )
		{
      *zbuffer = z;
			*image = col;
/*
			__asm
			{
				push edi
				push ebx
				mov	edi,image
				mov	ebx,offset_b
				mov	eax,color
				mov	word ptr [edi+ebx*2],ax
				pop	edi
				pop	ebx
			}
*/
		}
	}
	else
	{
		*image = col;
	}
}






















