/*--------------------------------------------------------------------------
 * File: ex.c
 * Written by: Gnilk
 * Description: Exempel for 8bit DirectX application
 * Notes:
 *			This one expects thats you have read or understood the other exemples.
 *
 -------------------------------------------------------------------------------*/


#include "system/xstring.h"
#include "system/xmath.h"
#include "vmath/vmath.h"
#include "system/xstdio.h"
#include "drivers/drv8.h"
#include "render/rnddrv.h"
#include "objects/object.h"


// just antoher way of doing it...
#define DRIVER dxDRV;
extern DRV DRIVER;
DRV *drv = &DRIVER;

BUFF *buff;
RGB ambient = {255,255,255};
RGB light = {127,127,127};
OBJECT object;

VIO *bgpic;

RGB imgpal[256];


BYTE lighttab[ LIGHTLEVELS * 256];
RGB palette[256];
static int xv,yv,zv,xva,yva,zva,red_col;

void update_ang (void)
{
	xv = (xv + xva) & (SINESIZE -1);
	yv = (yv + yva) & (SINESIZE -1);
	zv = (zv + zva) & (SINESIZE -1);
}
static void my_project (VECTOR *v, float xo, float yo, float zo, float d)
{
	float t;
	v->z += zo;

	t = d - v->z;
	t = d/t;

	v->x = (xo+v->x) * t;
	v->y = (yo+v->y) * t;
}
void doit (V3O *obj,float z_pos)
{
	MATRIX m;
	int i;
	XYZ p1,p2,p3;
	V3OSURFACE *sf = obj->surface;

	update_ang ();
	buildrotationmatrix (xv,yv,zv,&m);
	for (i=0;i<obj->numvertex;i++)
	{
		vecmul (&m,&obj->orgvertex[i],&obj->rotvertex[i]);

		my_project (&obj->rotvertex[i],0,0,z_pos,400);
		obj->rotvertex[i].x += buff->xorigo;
		obj->rotvertex[i].y += buff->yorigo;
	}
	p1.l = p2.l = p3.l = 32;
	for (i=0;i<obj->numsurface;i++)
	{
		//if (render_ishidden (obj, &sf[i]))
//		if ((p1.z>400) && (p2.z>400) && (p3.z>400))
		{
			p1.x = obj->rotvertex[sf[i].v1].x;
			p1.y = obj->rotvertex[sf[i].v1].y;
			p1.z = obj->rotvertex[sf[i].v1].z;

			p2.x = obj->rotvertex[sf[i].v2].x;
			p2.y = obj->rotvertex[sf[i].v2].y;
			p2.z = obj->rotvertex[sf[i].v2].z;

			p3.x = obj->rotvertex[sf[i].v3].x;
			p3.y = obj->rotvertex[sf[i].v3].y;
			p3.z = obj->rotvertex[sf[i].v3].z;

			drv->poly (p1,p2,p3,red_col);
		}
	}

}
static void testa (void)
{
	XYZ p1,p2,p3;

	p1.x = 10;
	p1.y = 10;
	p1.z = 0;

	p2.x = 160;
	p2.y = 20;
	p2.z = 0;

	p3.x = 40;
	p3.y = 180;
	p3.z = 0;

	drv->poly (p1,p2,p3,255);

}

/* ######################################################################### */
int main( int argc, char *argv[])
{
	int i;
	float z_pos = 500;
	int speed=0;
	RGB red_org = {255,0,0};

	if ((bgpic = vio_load ("back.vio"))==NULL)
	{
		printf ("Unable to load picture!\n");
	}
 	for( i=0; i<256; i++)
	{
		imgpal[i].r = bgpic->palette[i].r;
		imgpal[i].g = bgpic->palette[i].g;
		imgpal[i].b = bgpic->palette[i].b;
	}

	/* load a .V3O object */
	object.type = T_V3O;
	if (object_load (&object,"saga.v3o","./")==NULL)
	{
		printf ("Unable to load object...\n");
		exit (1);
	}
	/* center object, than scale it a bit...  */
	v3o_center (object.v3o);
	v3o_scale (object.v3o,32,80,32);
	/*
	 * okej...  lets flip it...  otherwise it might look strange...
	 * this is because we dont use a camera....
	 */
	for (i=0;i<object.v3o->numvertex;i++)
	{
		object.v3o->orgvertex[i].y *= -1.0;
		object.v3o->orgvertex[i].x *= -1.0;
	}
	// Dump contents...   use "v3o_dump (object.v3o, 1, 1)" to control
	// information level....
	v3o_dump (object.v3o, 0,0);
 //	exit(1);

	mathinit ();
  if( !drv->setup())
	{
		printf("Driver setup failed(%s)\n", drv->geterror());
		exit( 1);
	}
	else
	{
		printf("Available modes:\n");
		for( i=0; i<drv->modes; i++)
			printf("%dx%d\n", drv->modelist[i].width, drv->modelist[i].height);
	}


  if( !drv->init(320,240, 0))
	{
		printf("Unable to initilize %s.(%s)\n", drv->name, drv->geterror());
		exit(0);
	}


	xv = yv = zv = 0;
	xva = -36;
	yva = 32;
	zva = 48;


	if ((buff = drv->createbuff( 320, 240))==NULL)
	{
		printf ("Unable to create buffer!!\n");
		exit (1);
	}

	/*
	 * this is the nice palette handling...
	 * read more about palette handling in palette.doc
	 */

	makepalette( palette, imgpal , 256);
	remapdata( palette, imgpal, bgpic->image8, 320,240);

  drv->setpalette( palette);
	drv->setbuff( buff);
	buff->lighttab = NULL;
	red_col = findcolor (palette,red_org);

	while( !drv->kbhit())
	{
		drv->vsync();
		drv->copybuff (0,0);
		memcpy4 (buff->image,bgpic->image8,320*240>>2);
		doit (object.v3o,z_pos);
		if ((z_pos+=5)>700) z_pos = 700;
	}

	drv->destroybuff( buff);
	drv->exit();
	printf ("and off we go!\n");
	return( 0);
}
