/*--------------------------------------------------------------------------
 * File: ex.4
 * Written by: Gnilk
 * Description:
 *		Simple exemple how to use the Lightwave player.
 *
 -------------------------------------------------------------------------------*/


#include "system/xstring.h"
#include "system/xmath.h"
#include "system/xstdio.h"
#include "drivers/drv16.h"
#include "formats/vio.h"
#include "vmath/vmath.h"
#include "vmath/matrix.h"
#include "vmath/vector.h"
#include "render16/rnddrv.h"


extern DRV vesa16DRV;
static DRV *drv = &vesa16DRV;


#define RENDER scpDRV;
extern RNDDRV RENDER;
static RNDDRV *render = &RENDER;

static BYTE lighttab[LIGHTLEVELS * 256];

static BUFF *buffrnd;


static V3D *v3d;
static float v3d_speed = 0.5;


/* ######################################################################### */
/*
 * Routine to calculate at lighttable...
 *
 */
static void local_lighttable (BYTE light, BYTE ambient)
{
	int i,j;
	int col,c;
	float add;

	for (j=0;j<256;j++)
	{
		col = j;
		add = (col - ambient)/(float)(LIGHTLEVELS/2.0);
		for (i=0;i<LIGHTLEVELS/2.0;i++)
		{
			c = ambient + add*i;
			lighttab[j+i*256]=c;
		}
		add = (light - col) / (float)(LIGHTLEVELS/2.0);
		for (i=0;i<LIGHTLEVELS/2.0;i++)
		{
			c = col + add*i;
	//		if (c>255) c = 255;
			lighttab[j+(i+LIGHTLEVELS/2)*256]=c;

		}
	}
}

/* ######################################################################### */
void init_driver (void)
{
	int i;

  if( !drv->setup())
	{
		printf("Driver setup failed(%s)\n", drv->geterror());
		exit( 1);
	}
	else
	{
		printf("Available modes:\n");
		for( i=0; i<drv->modes; i++)
			printf("%dx%d\n", drv->modelist[i].width, drv->modelist[i].height);
	}

  if( !drv->init(320,240, DRVCFG_ZBUFFER | DRVCFG_16BITS))
	{
		printf("Unable to initilize %s.(%s)\n", drv->name, drv->geterror());
		exit(0);
	}

}


/* ######################################################################### */
int main( int argc, char *argv[])
{
	RGBA cl_col = {0,0,0,0};


	init_driver ();
	mathinit ();

	local_lighttable (255,0);
  buffrnd = drv->createbuff(320,200);

	/*
	 *  Load 3d-scene...   params:  (scene, object_path, texture_path)
	 */
  if ((v3d = v3d_load("wheels\\wheels.v3d", "wheels\\","wheels\\" ))==NULL)
	{
		printf ("[!] - %s\n",v3d_geterror ());
		exit (1);
	}
	/*
	 * Setup vievport camera and buffer...
	 */
	render->setviewport (buffrnd,v3d->activecamera);

	// make buffer active
	drv->setbuff( buffrnd);
	/*
	 *  set buffer lighttable
	 */
	buffrnd->lighttab = lighttab;


	while(!drv->kbhit())
	{
		drv->vsync();
		drv->movebuff (0,0,cl_col);

		/*
		 *  perpare a scene for rendring...
		 *  it updates all animations and such...
		 */
	  render->prepare (v3d);
		/*
		 * render current scene...  with respect to the viewport camera and buffer
		 */
		render->render (v3d);

		/*
		 * increase framecounter... its FLOAT!!!
		 */
		v3d->framecounter += v3d_speed;
	}

	drv->destroybuff( buffrnd);
	drv->exit();

	return( 0);
}
