/*--------------------------------------------------------------------------
 * File: ex3.c
 * Written by: Gnilk
 * Description:
 *
 *	Displaying a .VIO image on the screen and the use of multipla virtual
 *  one buffer is used to draw the cube, antoher is used for the image...
 *  Cube code is the same as for exempel2...
 *
 *
 * Note:
 *		Get rid of all comments to make the code look less complicated....
 *
 -------------------------------------------------------------------------------*/

#include "formats/vio.h"

#include "vmath/vmath.h"
#include "vmath/matrix.h"
#include "vmath/vector.h"
#include "system/xstdio.h"
#include "system/xmath.h"
#include "drivers/drv16.h"

/*
 * Define the driver as an external...
 */
extern DRV vesa16DRV;
static DRV *drv = &vesa16DRV;

/* define the buffers */
static BUFF *cube_buffer;
static BUFF *picture_buffer;

/* define the picture */
static VIO *picture;


/*
 * Define The Cube!!!!!!!
 */
static VECTOR cube_vertex[8]={-80,80,80, 80,80,80, 80,-80,80, -80,-80,80,
											 -80,80,-80, 80,80,-80, 80,-80,-80, -80,-80,-80};
static VECTOR rot_vertex[8];
static int surftable[6][4]={{0,1,2,3},{7,6,5,4},{0,3,7,4},{5,1,0,4},{6,2,1,5},{3,2,6,7}};
static RGBA surface_col[6]={192,0,0,0, 0,142,0,0, 0,0,142,0, 142,0,142,0, 142,142,0,0, 0,142,142,0};
static int xv,yv,zv,xva,yva,zva;


/*
 *  Just two local routines to make it look nicer....
 */
static void my_project (VECTOR *v, float xo, float yo, float zo, float d)
{
	float t;
	v->z += zo;

	t = d - v->z;
	t = d/t;

	v->x = (xo+v->x) * t;
	v->y = (yo+v->y) * t;
}
static void docube (void)
{
	MATRIX m;
	XYZ pts[4];
	int i,j;
	xv = (xv + xva) & (SINESIZE -1);
	yv = (yv + yva) & (SINESIZE -1);
	zv = (zv + zva) & (SINESIZE -1);

	buildrotationmatrix (xv,yv,zv, &m);

	for (i=0;i<8;i++)
	{
		vecmul (&m,&cube_vertex[i],&rot_vertex[i]);
		my_project (&rot_vertex[i],0,0,800,400);
		rot_vertex[i].x += cube_buffer->xorigo;
		rot_vertex[i].y += cube_buffer->yorigo;
	}

	for (i=0;i<5;i++)
	{
		for (j=0;j<4;j++)
		{
			pts[j].x = rot_vertex[surftable[i][j]].x;
			pts[j].y = rot_vertex[surftable[i][j]].y;
			pts[j].z = rot_vertex[surftable[i][j]].z;
			pts[j].l = 32;	/* we are NOT using any lightshadeing...*/
		}

		drv->poly (pts[0],pts[1],pts[2],surface_col[i]);
		drv->poly (pts[0],pts[2],pts[3],surface_col[i]);
	}
}

/* ######################################################################### */
/* ######################################################################### */
void init_driver (void)
{
	int i;
	/*
	 * Setup driver
	 * If this call isnt done the drv->init call does it for you...
	 * Setup checks for videomodes and such..
	 *
	 */
  if (!drv->setup())
	{
		printf("Driver setup failed(%s)\n", drv->geterror());
		exit( 1);
	}
	else
	{
		printf ("Available modes:\n");
		for(i=0; i<drv->modes; i++)
			printf ("%dx%d\n", drv->modelist[i].width, drv->modelist[i].height);
	}

	/*
	 * Init graphics driver with 16 bits output and Zbuffer
	 */
	if( !drv->init(640,480, DRVCFG_ZBUFFER | DRVCFG_16BITS))
	{
		printf("Unable to initilize %s.(%s)\n", drv->name, drv->geterror());
		exit(0);
	}

}

int main (void)
{
	RGBA RGBA_black = {0,0,0,0};
	/*
	 * Setup some variables...
	 */
	 xv=yv=zv=0;
	 xva=32;
	 yva=-29;
	 zva=31;

	/*
	 * Init matrix & vector functions...
	 * DONT forget this one... it sets up some tables!!!
	 */

	mathinit ();


	// init system...
	init_driver ();

	// load image... with "error" checking...
	if ((picture=vio_load ("bubble.vio"))==NULL)
	{
		drv->exit ();
		printf ("Unable to load bubble.vio\n");
		exit (1);
	}
	// Create buffers for picture and cube!!
	if ((picture_buffer = drv->createbuff (picture->width,picture->height))==NULL)
	{
		drv->exit ();
		printf ("Unable to create virtual screen buffer\n");
		exit (1);
	}
	if ((cube_buffer = drv->createbuff (320,240))==NULL)
	{
		drv->exit ();
		printf ("Unable to create virtual screen buffer\n");
		exit (1);
	}


	/* Copy image 32 bit data into the picture_buffer area!
	 * NOTICE the "vio->image32" access...   read in VIO.DOC for futher
	 * details...
	 */
	memcpy4 (picture_buffer->image,picture->image32,picture->width*picture->height);

	// Put picture on screen...
	drv->setbuff (picture_buffer);
	drv->copybuff (0,0);


	// Set the cube buffer as active buffer...
	drv->setbuff (cube_buffer);
	drv->clearbuff (RGBA_black);


	while(!drv->kbhit())
	{
		// Wait for vertical retrace sync!
		drv->vsync ();
		// Swap and clear current buffer (this also clears the current ZBUFFER!)
		drv->movebuff (320,240-(cube_buffer->height>>1),RGBA_black);
		docube ();
	}

	// Destroy cube_buffer & picture_buffer and exit driver...
	drv->destroybuff (cube_buffer);
	drv->destroybuff (picture_buffer);
	drv->exit ();

	return (0);
}
