#include "main.h"
#include "engine.h"
#include "loadlwo.h"
#include "util.h"

static scene_s *scene;

static int startframe;

static TIM_IMAGE TIMPart2Back;
static void SetGrey(int s);
static void PutText(int w, int state);    // 0 .. 4096

int Part2Init(int frame)
{
#ifdef DEBUG
  printf("part 2 init.\n");
#endif
  startframe=frame;
  scene=new scene_s;
#ifdef DEBUG
  printf("initializing scene 2\n");
#endif
  extern char M_02bck1[];
  extern char M_02msk1[];
  extern char M_02msk2[];
  LoadTIM(M_02bck1, &TIMPart2Back);
  LoadTIM(M_02msk1);
  LoadTIM(M_02msk2);

  extern char LWO_Sat[];
  scene->root=LoadLWO(LWO_Sat);
  scene->root->scene=scene;
  scene->root->child=0;
  return 0;
}

int Part2Frame(int frame)
{
  frame-=startframe;

  int fade=127;
                                 // setup light sources
  scene->l_dir.m[0][0]=2896;
  scene->l_dir.m[0][1]=2896;
  scene->l_dir.m[0][2]=0;

  scene->l_dir.m[1][0]=0;
  scene->l_dir.m[1][1]=0;
  scene->l_dir.m[1][2]=-4096;

  scene->l_dir.m[2][0]=0;
  scene->l_dir.m[2][1]=0;
  scene->l_dir.m[2][2]=0;
                                  // camera position
  scene->camera.pos.v.vx=0;
  scene->camera.pos.v.vy=-1200;
  scene->camera.pos.v.vz=-6000;
                                  // camera direction
  scene->camera.pos.r.vx=0;
  scene->camera.pos.r.vy=0;
  scene->camera.pos.r.vz=0;
  scene->camera.matval=0;
                                  // object position
  scene->root->matval=0;
  scene->root->pos.r.vx+=-26;
  scene->root->pos.r.vy+=10;
  scene->root->pos.r.vz+=20;
  scene->root->pos.v.vx=rsin(frame*7);
  if (frame > 557)
    scene->root->pos.v.vx+=(frame-557)*(frame-557);
  scene->root->pos.v.vy=0;
  scene->root->pos.v.vz=0;

  int farbigkeit=4096;

  int fak=4096;

  if (frame<128)
    fak=frame*32;

  if (frame<64)
    fade=frame*2;
  else if ((frame>=64) && (frame<128))
  {
    PutText(0, (frame-64)*64);
  } else if (frame<328)
    PutText(0, 4096);
  else if (frame<392)
  {
    PutText(0, (392-frame)*64);
    PutText(1, (frame-328)*64);
  } else if (frame<592)
  {
    PutText(1, 4096);
    farbigkeit=(456-frame)*64;
    if (farbigkeit<0)
      farbigkeit=0;
  } else if (frame<656)
  {
    farbigkeit=0;
    PutText(1, (656-frame)*64);
    fade=(656-frame)*2;
  } else
    return 1;

                                  // setup light colors
  scene->l_color.m[0][0]=4096*3500/4096*fak/4096;
  scene->l_color.m[1][0]=4096*3500/4096*fak/4096;
  scene->l_color.m[2][0]=fak;

  scene->l_color.m[0][1]=4096*3500/4096*fak/4096;
  scene->l_color.m[1][1]=4096*3500/4096*fak/4096;
  scene->l_color.m[2][1]=fak;

  scene->l_color.m[0][2]=4096*3500/4096*fak/4096;
  scene->l_color.m[1][2]=4096*3500/4096*fak/4096;
  scene->l_color.m[2][2]=fak;

                                  // setup ambient
  scene->l_color.t[0]=1024*fak/4096;
  scene->l_color.t[1]=1024*fak/4096;
  scene->l_color.t[2]=1024*fak/4096;

  SetGrey(farbigkeit);

  int r, g, b;

  r=g=b=fade;

  int rgb=r | (g<<8) | (b<<16);

  engineRender(scene);
  introShowPicture(640, 0, getClut(0, 480), 1, rgb);
  
  return 0;
}

int Part2Close()
{
#ifdef DEBUG
  printf("closing Part2 ... SHOULD delete objects here.\n");
#endif
  scene->root->Free();
  delete scene->root;
  delete scene;
  return 0;
}

static void SetGrey(int fak)
{
  u_short clut[256];
  for (int i=0; i<256; i++)
  {
    int clute=((u_short*)TIMPart2Back.caddr)[i];
    int tr=(clute&0x1F)<<3;
    int tg=((clute>>5)&0x1F)<<3;
    int tb=((clute>>10)&0x1F)<<3;

    int ave=(tr*3+tg*4+tb)>>3;

    tr = ave + (-ave+tr) * fak / 4096; 
    tg = ave + (-ave+tg) * fak / 4096; 
    tb = ave + (-ave+tb) * fak / 4096; 

    clut[i]=(tr>>3)|((tg>>3)<<5)|((tb>>3)<<10);
  }

  RECT rect;
  rect.x=0;
  rect.y=480;
  rect.w=256;
  rect.h=1;

  LoadImage(&rect, (unsigned long*)clut);
  DrawSync(0);  // wait until it's loaded.. :)
}

static void PutText(int which, int state)
{
  int co=state>>(which?3:4);
  if (co>(which?127:63))
    co=which?127:63;
  if (co<0)
    co=0;
  int abr=0;
  int tpage=getTPage(0, abr, 0, 256);
  int clut=getClut(0, 401);
  int v=which?35:0;
  int w=which?269:305;
  int h=which?53:35;
  int x=which?160:160;
  int y=which?200:120;

  int vsize=h, hsize=w;

  if (!which)
    vsize=state*h/4096;
  else
    hsize=state*w/4096;

  x-=hsize/2;
  y-=vsize/2;

  int r=w-256;
  int rs=256*(which?state:4096)/4096;

  char *startp=_curdisplayp->wspace + _curdisplayp->wspacepos;
  POLY_FT4 *pft4=(POLY_FT4*)startp;
  u_long *ot=_curdisplayp->ot;

  for (int i=0; i<2; i++)
  {

    setPolyFT4(pft4);
  
    pft4->tpage=tpage;
    pft4->clut=clut;
  
    pft4->r0=pft4->g0=pft4->b0=co;
  
    pft4->x0=x;
    pft4->y0=y;
  
    pft4->x1=x+rs;
    pft4->y1=y;
  
    pft4->x2=x;
    pft4->y2=y+vsize;
  
    pft4->x3=x+rs;
    pft4->y3=y+vsize;
  
    pft4->u0=0;
    pft4->v0=v;
  
    pft4->u1=255;
    pft4->v1=v;
  
    pft4->u2=0;
    pft4->v2=v+h;
  
    pft4->u3=255;
    pft4->v3=v+h;
  
    setSemiTrans(pft4, 1);
  
    addPrim(ot+OTSIZE-1, pft4);
    pft4++;
  
    setPolyFT4(pft4);
  
    pft4->tpage=getTPage(0, abr, 64, 256);
    pft4->clut=clut;
  
    pft4->r0=pft4->g0=pft4->b0=co;
  
    pft4->x0=x+rs;
    pft4->y0=y;
  
    pft4->x1=x+hsize;
    pft4->y1=y;
  
    pft4->x2=x+rs;
    pft4->y2=y+vsize;
  
    pft4->x3=x+hsize;
    pft4->y3=y+vsize;
  
    pft4->u0=0;
    pft4->v0=v;
  
    pft4->u1=r;
    pft4->v1=v;
  
    pft4->u2=0;
    pft4->v2=v+h;
  
    pft4->u3=r;
    pft4->v3=v+h;
  
    setSemiTrans(pft4, 1);
  
    addPrim(ot+OTSIZE-1, pft4);
    pft4++;
  }

  _curdisplayp->wspacepos += (char *)pft4 - startp;
}
