//-------------------------------------------------------------------------
//
// File:		Composition.h
// Desc:		Composition namespace header.
// Author:		memon <memon@inside.org>
//
//-------------------------------------------------------------------------
//	Copyright (c) 2000 Moppi Productions. All Rights Reserved.
//  This file is part of Moppi Demopaja SDK. For conditions of 
//  distribution and use, see the accompanying license.txt file.
//  http://moppi.inside.org/demopaja/
//-------------------------------------------------------------------------

#ifndef __DEMOPAJA_COMPOSITION_H__
#define __DEMOPAJA_COMPOSITION_H__

//! The composition namespace
/*!	The classes collected into the Composition namespace are
	used as parts of demo composition. The classes range from a controller
	and parameter to a layer or complete scene.
*/
namespace Composition {

	//! Common flags Effect, Gizmo, and Parameter.
	enum ItemFlagsE {
		ITEM_EXPANDED = 1,
		ITEM_SELECTED = 2,
		ITEM_VISIBLE = 4,
		ITEM_LOCKED = 8,
		ITEM_LAYER = 16,
		ITEM_EFFECT = 32,
		ITEM_GIZMO = 64,
		ITEM_PARAMETER = 128,
		ITEM_ANIMATED = 256,
		ITEM_ANIMATABLE = 512,
		ITEM_CLAMPVALUES = 1024,
		ITEM_EXPANDABLE = 2048,
		ITEM_GUIHIDDEN = 4096,
	};

};

#endif // __DEMOPAJA_COMPOSITION_H__