#if !defined(AFX_DYNDIALOG_H__3C1575C1_2514_11D4_A80C_0000E8D926FD__INCLUDED_)
#define AFX_DYNDIALOG_H__3C1575C1_2514_11D4_A80C_0000E8D926FD__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// DynDialog.h : header file
//

#include <afxtempl.h>
#include "ParamI.h"
#include "PajaTypes.h"
#include <vector>


class DynDialogCallbackC
{
public:
	DynDialogCallbackC() {};
	virtual ~DynDialogCallbackC() {};
	virtual void	parameter_changed( Composition::ParamI* param ) = 0;
};


/////////////////////////////////////////////////////////////////////////////
// CDynDialog dialog

class CDynDialog : public CDialog
{
// Construction
public:
	CDynDialog(CWnd* pParent = NULL);   // standard constructor

	virtual bool	AddParameter( Composition::ParamI* param );
	virtual void	SetCallback( DynDialogCallbackC* cb );
	virtual void	ParameterChanged( Composition::ParamI* param );

	// Dialog Data
	//{{AFX_DATA(CDynDialog)
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA


protected:

	PajaTypes::uint32	GetNextFreeID();
	void				DoCallback( Composition::ParamI* param );
	void				CutTrailingZeros( CString& str );


	class ParamItemC
	{
	public:
		ParamItemC() {};
		virtual ~ParamItemC() {};
		Composition::ParamI*	m_param;
		PajaTypes::uint32	m_id[16];
	};

	struct DLGTEMP {
		DLGTEMPLATE	tmp;
		WORD		menu;			// 0 = no menu
		WORD		clss;			// 0 = defautl class
		WORD		name;			// 0 = no name
	};


	CFont						m_boldFont;
	CFont						m_thinFont;
	PajaTypes::int32			m_boldHeight;
	PajaTypes::int32			m_thinHeight;

	DynDialogCallbackC*			m_callback;
	std::vector<ParamItemC>		m_params;
	std::vector<CWnd*>			m_controls;
	CPoint						m_curPos;

	static PajaTypes::uint32	m_nextFreeId;

	// dragging
	PajaTypes::int32			m_dragYStart;
	CRect						m_dragRect;
	bool						m_dragging;
	HCURSOR						m_oldCursor;

	bool						m_updating;

//	CArray<CDynDialogItemEx*, CDynDialogItemEx*>	m_arrDlgItemPtr;

	// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDynDialog)
	public:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL Create( const RECT& rect, CWnd* pParentWnd );
	protected:
virtual void PostNcDestroy();
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

	// Generated message map functions
	//{{AFX_MSG(CDynDialog)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	virtual BOOL OnInitDialog();
	virtual void OnOK();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_DYNDIALOG_H__3C1575C1_2514_11D4_A80C_0000E8D926FD__INCLUDED_)
