//-------------------------------------------------------------------------
//
// File:		DemopajaPlayerC.cpp
// Purpose:		Moppi Demopaja Player class header
// Author:		memon <memon@inside.org>
// Version:		0.51
//
//-------------------------------------------------------------------------
//	Copyright (c) 2000 Moppi Productions. All Rights Reserved.
//  This file is part of Moppi Demopaja SDK.
//  For conditions of distribution and use, see the accompanying license.txt file.
//  http://moppi.inside.org/demopaja/
//-------------------------------------------------------------------------


#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
#include <windows.h>

#include "PajaTypes.h"
#include "SceneC.h"
#include "FileListC.h"
#include "DemopajaVersion.h"
#include "DeviceContextC.h"
#include "TimeContextC.h"
#include <string>
#include <vector>

#include "bass.h"


//! Demopaja Player class.
/*! DemopajaPlayerC class provides easy to use stand alone player for Moppi Demopaja files.
*/
class DemopajaPlayerC
{
public:
	//! Default constructor.
	DemopajaPlayerC();
	//! Default destructor.
	virtual ~DemopajaPlayerC();

	//! Registers and internal plugin class.
	/*!	\param pDesc Plugin class to register.
		This method provides a way to include the effect code inside the player without
		loading the effect from a DLL.
		
		Example:
		\code
		// Global class descriptor.
		ImageDescC		g_rImageDesc;

		...

		rPlayer.register_plugin( &g_rImageDesc );
		\endcode
	*/
	void				register_plugin( PluginClass::ClassDescC* pDesc );

	//! Loads plugins from DLLs.
	/*! Loads plugins from specified path.
	*/
	void				load_plugins( const char* szPath );

	//! Initialises the player.
	/*!	Sets up a window and initialises the graphics device driver. Must be called before load_demo() and run().
	*/
	bool				init( HINSTANCE hInst, bool bFullScreen );

	//! Loads the demo file.
	/*!	Must be called after init().
	*/
	PajaTypes::uint32	load_demo( const char* szFileName );

	//! Runs the demo.
	/*! \returns 0 (zero) on success, else -1.
	*/
	PajaTypes::int32	run();

private:

	PajaTypes::uint32			load_scene( FileIO::LoadC* pLoad );
	void						draw_frame();
	bool						init_music_system( HWND hWnd );

	static bool					set_pixelformat( HDC hDC );
	static LRESULT CALLBACK		wnd_proc( HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam );

	PajaSystem::DeviceContextC*	m_pContext;
	PajaSystem::TimeContextC*	m_pTimeContext;
	Import::FileListC*			m_pFileList;
	Composition::SceneC*		m_pScene;
	PluginClass::FactoryC		m_rFactory;

	PajaTypes::int32			m_i32Time;
	PajaTypes::int32			m_i32MaxTime;
	PajaTypes::int32			m_i32SampleSize;
	PajaTypes::int32			m_i32Freq;
	PajaTypes::float64			m_f64TimeScale;
	PajaTypes::int32			m_i32StartTime;
	bool						m_bFullscreen;
	std::string					m_sMusicFile;

	static HSTREAM				m_hMp3Stream;
	static bool					m_bBASSPresent;
	static HDC					m_hDC;
	static HGLRC				m_hGLRC;
	static HWND					m_hWnd;
};