
#include <stdio.h>
#include <math.h>
#include "include/glut.h"
#include "core.h"
#include "wrapglut.h"
#include "particle.h"


void CParticle::SetPosition(float x,float y,float z)
{
	Position.X=x;
	Position.Y=y;
	Position.Z=z;
	size=1+f2rand()*64;
}

void CParticle::SetVelocity(float x,float y,float z)
{
	Velocity.X=x;
	Velocity.Y=y;
	Velocity.Z=z;
}

void CParticle::SetForce(float x,float y,float z)
{
	Force.X=x;
	Force.Y=y;
	Force.Z=z;
}

void CParticle::SetMass(float mass)
{
	Mass=mass;
}

void CParticle::GravityAttract(float x,float y,float z,float mass)
{
	float md=mass*Mass;
	
	float dist=length3d(x,y,z,Position.X,Position.Y,Position.Z);
	if (dist<2.0) { SetForce(0,0,0); SetVelocity(0,0,0); return; }
	float dx,dy,dz;
	if (dist!=0)
	{
		dx=dist/(Position.X-x);
		dy=dist/(Position.Y-y);
		dz=dist/(Position.Z-z);
	}

	float fresx=0,fresy=0,fresz=0,fres=0;
	if (dx!=0.0) fresx=-md/dx;
	if (dy!=0.0) fresy=-md/dy;
	if (dz!=0.0) fresz=-md/dz;

	fresx/=30;
	fresy/=30;
	fresz/=30;

	//SetPosition(Position.X+fresx,Position.Y+fresy,Position.Z+fresz);
	SetForce(Force.X+fresx,Force.Y+fresy,Force.Z+fresz);
	//SetVelocity(Velocity.X+fresx,Velocity.Y+fresy,Velocity.Z+fresz);

}


void CParticle::GravityRepel(float x,float y,float z,float mass)
{
	float md=mass*Mass;
	
	float dist=length3d(x,y,z,Position.X,Position.Y,Position.Z);
	float dx,dy,dz;
	if (dist!=0)
	{
		dx=dist/(Position.X-x);
		dy=dist/(Position.Y-y);
		dz=dist/(Position.Z-z);
	}

	float fresx=0,fresy=0,fresz=0,fres=0;
	if (dx!=0.0) fresx=md/dx;
	if (dy!=0.0) fresy=md/dy;
	if (dz!=0.0) fresz=md/dz;

	fresx/=30;
	fresy/=30;
	fresz/=30;

	//SetPosition(Position.X+fresx,Position.Y+fresy,Position.Z+fresz);
	SetForce(Force.X+fresx,Force.Y+fresy,Force.Z+fresz);
	//SetVelocity(Velocity.X+fresx,Velocity.Y+fresy,Velocity.Z+fresz);
}


void CParticle::Update(float time)
{
	Position.X+=(Velocity.X*time);
	Position.Y+=(Velocity.Y*time);
	Position.Z+=(Velocity.Z*time);

	Velocity.X+=(Force.X*time);
	Velocity.Y+=(Force.Y*time);
	Velocity.Z+=(Force.Z*time);
}	


void CParticle::Wrap(float scale)
{
	if (Position.X<-scale/1) Position.X=scale;
	if (Position.Y<-scale/1) Position.Y=scale;
	if (Position.Z<-scale/1) Position.Z=scale;
	if (Position.X>scale/1)  Position.X=-scale;
	if (Position.Y>scale/1)  Position.Y=-scale;
	if (Position.Z>scale/1)  Position.Z=-scale;
}

void CParticle::Wrap(float scalex,float scaley,float scalez)
{
	if (Position.X<-scalex/1) Position.X=scalex;
	if (Position.Y<-scaley/1) Position.Y=scaley;
	if (Position.Z<-scalez/1) Position.Z=scalez;
	if (Position.X>scalex/1)  Position.X=-scalex;
	if (Position.Y>scaley/1)  Position.Y=-scaley;
	if (Position.Z>scalez/1)  Position.Z=-scalez;
}


void CParticle::Wall(float scale,float damping)
{
	char collide;

	collide=0;
	if ( (Position.X<-scale/2) ) { Position.X=-scale/2; collide=1; Velocity.X*=-damping; }
	if ( (Position.Y<-scale/2) ) { Position.Y=-scale/2; collide=1; Velocity.Y*=-damping; }
	if ( (Position.Z<-scale/2) ) { Position.Z=-scale/2; collide=1; Velocity.Z*=-damping; }
	if ( (Position.X>scale/2)  ) { Position.X=scale/2; collide=1; Velocity.X*=-damping; }
	if ( (Position.Y>scale/2)  ) { Position.Y=scale/2; collide=1; Velocity.Y*=-damping; }
	if ( (Position.Z>scale/2)  ) { Position.Z=scale/2; collide=1; Velocity.Z*=-damping; }

	if (collide==1) 
	{ 
		//Velocity.X*=-damping;
		//Velocity.Y*=-damping;
		//Velocity.Z*=-damping;
		//Force.X*=damping;
		//Force.Y*=damping;
		//Force.Z*=damping;
	}
}


void CParticle::Rotate(float xang,float yang,float zang)
{
	m_fRot[0]=xang;
	m_fRot[1]=yang;
	m_fRot[2]=zang;
}


CParticle::CParticle()
{
	Mass=0.1;
}

CParticle::~CParticle()
{
	Mass=0.1;
}




void CCloud::Draw()
{
	float x=0,y=0,z=0;

	glPushMatrix();
	glTranslatef(Position.X,Position.Y,Position.Z);
	//glRotatef(-m_fRot[2],0,0,1);
	//glRotatef(-m_fRot[1],0,1,0);
	//glRotatef(-m_fRot[0],1,0,0);

	float xsiz=size;
	float ysiz=size;
	x=x-size/2;
	y=y-size/2;

	glBegin (GL_TRIANGLES);
		glColor4f(1,1,1,1);
		glTexCoord2i(0,1);
		glVertex3f (x,y,z);
		glTexCoord2i(1,1);
		glVertex3f (x+xsiz,y,z);
		glTexCoord2i(1,0);
		glVertex3f (x+xsiz,y+ysiz,z);

		glTexCoord2i(0,1);
		glVertex3f (x,y,z);
		glTexCoord2i(1,0);
		glVertex3f (x+xsiz,y+ysiz,z);
		glTexCoord2i(0,0);
		glVertex3f (x,y+ysiz,z);
	glEnd ();
	//glDisable(GL_TEXTURE_2D);
	//glDisable(GL_BLEND);
	glPopMatrix();
}


void CCloud::SetColor(float r,float g,float b)
{
	m_fColor[0]=r;
	m_fColor[1]=g;
	m_fColor[2]=b;
}

CCloud::CCloud() : CParticle()
{

}

CCloud::~CCloud()
{

}






void CStar::Draw()
{
	float x=Position.X;
	float y=Position.Y;
	float z=Position.Z;

	glPushMatrix();
	glTranslatef(x,y,z);
	//glRotatef(-m_fRot[2],0,0,1);
	//glRotatef(-m_fRot[1],0,1,0);
	//glRotatef(-m_fRot[0],1,0,0);

	x=0;
	y=0;
	z=0;

	float xsiz=2;
	float ysiz=2;
	x=x-(xsiz/2);
	y=y-(ysiz/2);

	glBegin (GL_TRIANGLES);
		glColor3f(1,1,1);
		glTexCoord2i(0,1);
		glVertex3f (x,y,z);
		glTexCoord2i(1,1);
		glVertex3f (x+xsiz,y,z);
		glTexCoord2i(1,0);
		glVertex3f (x+xsiz,y+ysiz,z);

		glTexCoord2i(0,1);
		glVertex3f (x,y,z);
		glTexCoord2i(1,0);
		glVertex3f (x+xsiz,y+ysiz,z);
		glTexCoord2i(0,0);
		glVertex3f (x,y+ysiz,z);
	glEnd ();
	//glDisable(GL_TEXTURE_2D);
	//glDisable(GL_BLEND);
	glPopMatrix();
}


void CStar::SetColor(float r,float g,float b)
{
	m_fColor[0]=r;
	m_fColor[1]=g;
	m_fColor[2]=b;
}

CStar::CStar() : CParticle()
{

}

CStar::~CStar()
{

}






void cAttractor::Draw()
{
	glColor3f(0,0,1);
	glPushMatrix();
	glTranslatef(Position.X,Position.Y,Position.Z);
	glutWireSphere(2,10,10);
	glPopMatrix();
}



void cAttractor::SetColor(float r,float g,float b)
{
	m_fColor[0]=r;
	m_fColor[1]=g;
	m_fColor[2]=b;
}

cAttractor::cAttractor() : CParticle()
{
	Mass=0.08;
}

cAttractor::~cAttractor()
{

}





void cRepeller::Draw()
{
	glColor3f(1,0,0);
	glPushMatrix();
	glTranslatef(Position.X,Position.Y,Position.Z);
	glutWireSphere(2,10,10);
	glPopMatrix();
}



void cRepeller::SetColor(float r,float g,float b)
{
	m_fColor[0]=r;
	m_fColor[1]=g;
	m_fColor[2]=b;
}

cRepeller::cRepeller() : CParticle()
{
	Mass=0.08;
}

cRepeller::~cRepeller()
{

}
