
#include "plasma.h"



cPlasma::cPlasma()
{
	ptr=NULL;
	surface=NULL;
	Mode=PLASMA_COLOR;
	RandSeed=0;
	start1=45;
	start2=230;
	start3=345;
	transparency=0;
}

cPlasma::~cPlasma()
{
	delete surface;
}

cPlasma::Init(int xdim,int ydim)
{
	surface = new CSurface(xdim,ydim,32);
	ptr=(unsigned int*)surface->data;
	GLindex=GetFreeTextureIndex();
	surface->Bind(GLindex);
	surface->transparency=1;
 
	for (int i=0; i<360; i++)
	{
		sintab[i]=sin(i*3.14159265/180)*32768;
		costab[i]=cos(i*3.14159265/180)*32768;
	}
	start1=rand();
	start2=rand();
	start3=rand();
	up1=fabs( frand()*2 );
	up2=fabs( frand()*2 );
	up3=fabs( frand()*2 );
}

cPlasma::SetMode(int mode)
{
	Mode=mode;
}

cPlasma::SetSpeed(int sp1,int sp2,int sp3)
{
	up1=sp1;
	up2=sp2;
	up3=sp3;
}

cPlasma::Update(float time)
{
	start1+=(up1*time);
	start2+=(up2*time);
	start3+=(up3*time);

	srand(RandSeed);

	if (Mode==PLASMA_COLOR)
		ColorPlasma();
	if (Mode==PLASMA_MONO)
		MonoPlasma();
	if (Mode==PLASMA_ALPHA)
		AlphaPlasma();
}

cPlasma::Draw()
{
	surface->Update(GLindex);
	surface->DrawAsBackground();
}

cPlasma::ColorPlasma()
{
	unsigned int *pointy;
	pointy=ptr;
	int pos=0;

    int r,g,b;
    int tr1,tr2,tr3;    int tra1,tra2,tra3;
    int tg1,tg2,tg3;    int tga1,tga2,tga3;
    int tb1,tb2,tb3;    int tba1,tba2,tba3;
	int tr4,tg4,tb4;
	tra1=start1*2; tr1=0;
	tra2=start2*4; tr2=0;
	tra3=start3*6; tr3=0;
	tga1=start1*2; tg1=0;
	tga2=start2*6; tg2=0;
	tga3=start3*5; tg3=0;
	tba1=start1*6; tb1=0;
	tba2=start2*4; tb2=0;
	tba3=start3*2; tb3=0;
	for (int y=0; y<surface->ydim; y++)
		{
		tra2+=(1*1); tra1=tra2; tra3+=up3;
		tga2-=(1*1); tga1=tga2; tga3+=up1;
		tba2+=(1*1); tba1=tba2; tba3+=up2;
		for (int x=0; x<surface->xdim; x++)
			{
				tra1+=(2*1);
				tga1+=(1*1);
				tba1-=(3*1);
				tr1=sintab[tra1%360];
				tr2=costab[(tga2+tra1)%360];
				tr3=sintab[(tba3+tga1)%360];
				tr4=costab[tba1%360];

				tg1=sintab[tga1%360];
				tg2=costab[(tra2+tba1)%360];
				tg3=costab[(tga3+tra1)%360];
				tg4=costab[tba2%360];

				tb1=sintab[tba3%360];
				tb2=sintab[(tga2+tra2)%360];
				tb3=costab[(tba1+tga2)%360];
				tb4=sintab[tra1%360];

				r=(tr1+tr2+tr3+tr4) >> 2; r=r>>7;if (r<0) r=0;
				g=(tg1+tg2+tg3+tg4) >> 2; g=g>>7;if (g<0) g=0;
				b=(tb1+tb2+tb3+tb4) >> 2; b=b>>7;if (b<0) b=0;

				int color=r+(g<<8)+(b<<16)+(255<<24);
				pointy[pos]=color;
				pos++;
			}
		}
}



cPlasma::MonoPlasma()
{
	unsigned int *pointy;
	pointy=ptr;
	int pos=0;

    int r;
    int tr1,tr2,tr3;    int tra1,tra2,tra3;
    int tg1,tg2,tg3;    int tga1,tga2,tga3;
    int tb1,tb2,tb3;    int tba1,tba2,tba3;
	int tr4;
	tra1=start1*1; tr1=0;
	tra2=start2*2; tr2=0;
	tra3=start3*3; tr3=0;
	tga1=start1*1; tg1=0;
	tga2=start2*3; tg2=0;
	tga3=start3*2; tg3=0;
	tba1=start1*3; tb1=0;
	tba2=start2*2; tb2=0;
	tba3=start3*1; tb3=0;
	for (int y=0; y<surface->ydim; y++)
		{
		tra2+=1; tra1=tra2; tra3+=up3;
		tga2-=1; tga1=tga2; tga3+=up1;
		tba2+=1; tba1=tba2; tba3+=up2;
		for (int x=0; x<surface->xdim; x++)
			{
				tra1+=2;
				tga1+=1;
				tba1-=3;
				tr1=sintab[tra1%360];
				tr2=costab[tga2%360];
				tr3=sintab[tba3%360];
				tr4=costab[tba1%360];
				r=(tr1+tr2+tr3+tr4) >> 2; r=r>>7;if (r<0) r=0;
				int color=r+(r<<8)+(r<<16)+(255<<24);
				pointy[pos]=color;
				pos++;
			}
		}
}




cPlasma::AlphaPlasma()
{
	unsigned int *pointy;
	pointy=ptr;
	int pos=0;

	int color;
    int r;
    int tr1,tr2,tr3;    int tra1,tra2,tra3;
    int tg1,tg2,tg3;    int tga1,tga2,tga3;
    int tb1,tb2,tb3;    int tba1,tba2,tba3;
	int tr4;
	tra1=start1*2; tr1=0;
	tra2=start2*4; tr2=0;
	tra3=start3*6; tr3=0;
	tga1=start1*2; tg1=0;
	tga2=start2*6; tg2=0;
	tga3=start3*4; tg3=0;
	tba1=start1*6; tb1=0;
	tba2=start2*4; tb2=0;
	tba3=start3*2; tb3=0;
	for (int y=0; y<surface->ydim; y++)
		{
		tra2+=(4*1); tra1=tra2; tra3+=up3;
		tga2-=(4*1); tga1=tga2; tga3+=up1;
		tba2+=(4*2); tba1=tba2; tba3+=up2;
		for (int x=0; x<surface->xdim; x++)
			{
				tra1+=(2*4);
				tga1+=(1*4);
				tba1-=(2*4);
				tr1=sintab[tra1%360];
				tr2=costab[(tga2+tra1)%360];
				tr3=sintab[(tba3+tga1)%360];
				tr4=costab[tba1%360];
				r=(tr1+tr2+tr3+tr4) >> 2; r=r>>7;
				if (r<0) r=0;
				r+=transparency;
				if (r<0) r=0;
				if (r>255) r=255;
				color=(r<<24);
				pointy[pos]=color;
				pos++;
			}
		}
}