
#ifndef _FIREEFFECT
#define _FIREEFFECT

#include "core.h"
#include "firepart.h"
#include "surface.h"

class cFireTorch
{
	public:
		cFireTorch();
		~cFireTorch();

		Init(float x,float y,float z,char *file1,char *file2);
		Pos(float x,float y,float z);
		Draw();
		update(float time);

	private:
		float			angx,angy,angz;
		int				m_intNumFlames;
		int				m_intNumSparks;

		CSurface		*m_pGfx_flame;
		CSurface		*m_pGfx_spark;
		cFireParticle	*m_pFlame;		//1000
		cFireParticle	*m_pSpark;		//50

		int				Flameindex;
		int				Sparkindex;
		float			xpos,ypos,zpos;

		UpdateFlame();
		UpdateSpark();
		DrawFire();
		DrawSparks();
};

#endif


