
#include "include/glut.h"
#include <stdlib.h>
#include "core.h"
#include "wrapglut.h"
#include "clouds.h"



void cClouds::Init(int numclouds,float scale)
{
	if (numclouds>0)
	{
		m_fScaleX=scale;
		m_fScaleY=scale;
		m_fScaleZ=scale;
		m_intNumClouds=numclouds;
		if (m_pCloud!=NULL) delete [] m_pCloud;
		m_pCloud = new CCloud[m_intNumClouds];
	}
}

void cClouds::Init(int numclouds,float scalex,float scaley,float scalez)
{
	if (numclouds>0)
	{
		m_fScaleX=scalex;
		m_fScaleY=scaley;
		m_fScaleZ=scalez;
		m_intNumClouds=numclouds;
		if (m_pCloud!=NULL) delete [] m_pCloud;
		m_pCloud = new CCloud[m_intNumClouds];
	}
}

void cClouds::SetRotate(float rotx,float roty,float rotz)
{
	m_fRot[0]=rotx;
	m_fRot[1]=roty;
	m_fRot[2]=rotz;
	for (int i=0; i<m_intNumClouds; i++)
	{
		m_pCloud[i].Rotate(rotx,roty,rotz);
	}
}

void cClouds::SetVelocity(float x,float y,float z)
{
	int i;
	for (i=0; i<m_intNumClouds; i++)
	{
		m_pCloud[i].SetVelocity(x,y,z);
	}
	for (i=0; i<m_intNumAttractors; i++)
	{
		m_pAttractor[i].SetVelocity(x,y,z);
	}
	for (i=0; i<m_intNumRepellers; i++)
	{
		m_pRepeller[i].SetVelocity(x,y,z);
	}
}

void cClouds::SetForce(float x,float y,float z)
{
	int i;
	for (i=0; i<m_intNumClouds; i++)
	{
		m_pCloud[i].SetForce(x,y,z);
	}
	for (i=0; i<m_intNumAttractors; i++)
	{
		m_pAttractor[i].SetForce(x,y,z);
	}
	for (i=0; i<m_intNumRepellers; i++)
	{
		m_pRepeller[i].SetForce(x,y,z);
	}
}

void cClouds::SetCloudTexture(char *filename)
{
	m_pCloudSurface.LoadTGARAR(filename);
	m_intCloudGLIndex=GetFreeTextureIndex();
	m_pCloudSurface.Bind(m_intCloudGLIndex);	
}


void cClouds::Randomise()
{
	int i;
	for (i=0; i<m_intNumClouds; i++)
	{
		m_pCloud[i].SetPosition(frand()*m_fScaleX,frand()*m_fScaleY,frand()*m_fScaleZ);
		m_pCloud[i].SetVelocity(frand(),frand(),frand());
		m_pCloud[i].SetColor(f2rand(),f2rand(),f2rand());
	}
	for (i=0; i<m_intNumAttractors; i++)
	{
		m_pAttractor[i].SetPosition(frand()*m_fScaleX,frand()*m_fScaleY,frand()*m_fScaleZ);
		m_pAttractor[i].SetVelocity(frand(),frand(),frand());
		m_pAttractor[i].SetColor(f2rand(),f2rand(),f2rand());
	}
	for (i=0; i<m_intNumRepellers; i++)
	{
		m_pRepeller[i].SetPosition(frand()*m_fScaleX,frand()*m_fScaleY,frand()*m_fScaleZ);
		m_pRepeller[i].SetVelocity(frand(),frand(),frand());
		m_pRepeller[i].SetColor(f2rand(),f2rand(),f2rand());
	}
}


void cClouds::CreateAttractors(int num)
{
	if (num>0)
	{
		m_intNumAttractors=num;
		if (m_pAttractor!=NULL) delete [] m_pAttractor;
		m_pAttractor = new cAttractor[m_intNumAttractors];
	}
}

void cClouds::CreateRepellers(int num)
{
	if (num>0)
	{
		m_intNumRepellers=num;
		if (m_pRepeller!=NULL) delete [] m_pRepeller;
		m_pRepeller = new cRepeller[m_intNumRepellers];
	}
}


void cClouds::Update(float time)
{
	int i,j;
	for (i=0; i<m_intNumClouds; i++)
	{
		for (j=0; j<m_intNumAttractors; j++)
		{
			m_pCloud[i].GravityAttract(
				m_pAttractor[j].GetX(),
				m_pAttractor[j].GetY(),
				m_pAttractor[j].GetZ(),
				m_pAttractor[j].GetMass());
		}
		for (j=0; j<m_intNumRepellers; j++)
		{
			m_pCloud[i].GravityRepel(
				m_pRepeller[j].GetX(),
				m_pRepeller[j].GetY(),
				m_pRepeller[j].GetZ(),
				m_pRepeller[j].GetMass());
		}
		m_pCloud[i].Update(time);
		if(wrap) m_pCloud[i].Wrap(m_fScaleX,m_fScaleY,m_fScaleZ);
		//m_pCloud[i].Wall(m_fScale,m_fWallDamping);
	}
/*
	for (i=0; i<m_intNumRepellers; i++)
	{
		m_pRepeller[i].Update(time);
		m_pRepeller[i].Wall(m_fScale,m_fWallDamping);
	}
	for (i=0; i<m_intNumAttractors; i++)
	{
		m_pAttractor[i].Update(time);
		m_pAttractor[i].Wall(m_fScale,m_fWallDamping);
	}*/
}

void cClouds::Draw()
{
	int i;


	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glTranslatef(0,0,-50);
	glRotatef(m_fRot[0],1,0,0);
	glRotatef(m_fRot[1],0,1,0);
	glRotatef(m_fRot[2],0,0,1);
	m_pCloudSurface.Bind(m_intCloudGLIndex);

	glDisable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);
	glDisable(GL_LIGHTING);
	glDisable(GL_COLOR_MATERIAL);
	glEnable(GL_TEXTURE_2D);

	for (i=0; i<m_intNumClouds; i++)
	{
		m_pCloud[i].Draw();
	}

}



cClouds::cClouds()
{
	m_pCloud=NULL;
	m_intNumClouds=0;
	m_fScaleX=0;
	m_fScaleY=0;
	m_fScaleZ=0;
	m_fRot[0]=0;
	m_fRot[1]=0;
	m_fRot[2]=0;
	m_fWallDamping=0.8;
	m_pAttractor=NULL;
	m_intNumAttractors=0;
	m_pRepeller=NULL;
	m_intNumRepellers=0;
}

cClouds::~cClouds()
{
	if (m_pCloud!=NULL) delete [] m_pCloud;
	m_pCloud=NULL;
	m_intNumClouds=0;
	m_fScaleX=0;
	m_fScaleY=0;
	m_fScaleZ=0;
	m_fRot[0]=0;
	m_fRot[1]=0;
	m_fRot[2]=0;
	m_fWallDamping=1;
	if (m_pAttractor!=NULL) delete [] m_pAttractor;
	m_pAttractor=NULL;
	m_intNumAttractors=0;
	if (m_pRepeller!=NULL) delete [] m_pRepeller;
	m_pRepeller=NULL;
	m_intNumRepellers=0;
}
