


typedef struct _Member_st Member_st;
typedef struct _Member Member;
struct _Member_st {
  Stereotype basis;
  Member *(*find)(Member *, char *);
  void (*render)(Member *);
};
struct _Member {
  union { Stereotype *Individual; Member_st *Member; Index master; } norms;
  char *handle;
};

#define member_render(s) ((s)->norms.Member->render((Member*)(s)))
#define member_find(s, c) ((s)->norms.Member->find((Member*)(s), (c)))


typedef struct _Design_st Design_st;
typedef struct _Design Design;
struct _Design_st {
  Member_st basis;
};
struct _Design {
  union { Stereotype *Individual; Member_st *Member; Design_st *Design; Member master; } norms;
  Index *verts, *faces;
};



typedef struct _Group_st Group_st;
typedef struct _Group Group;
struct _Group_st {
  Member_st basis;
  void (*add)(Group *, Member *, float *);
};
struct _Group {
  union { Stereotype *Individual; Member_st *Member; Group_st *Group; Member master; } norms;
  Region *contents;
};

#define group_add(u, s, m) ((u)->norms.Group->add((Group*)(u), (Member*)(s), (m)))



typedef struct _Demodesign Demodesign;
typedef struct _Demogroup Demogroup;


struct _Demodesign {
  union { Stereotype *Individual; Member_st *Member; Design_st *Design; Design master; } norms;
  Register *verts, *faces;
  Region *vp, *vn, *vc, *vl, *ve, *vt, *fi;
  Space *spc;
  int listno, flags;
};
struct _Demogroup {
  union { Stereotype *Individual; Member_st *Member; Group_st *Group; Group master; } norms;
  Space *spc;
};




Demodesign *demodesign(Space *, char *n, int);
void design_unitize(Design *);
void design_calcnormals(Design *);
void demogroup_lue3ds(Demogroup *, char *, int, int);
Register *spaceregister(Space *);
Demogroup *demogroup(Space *, char *n);
Region *spaceregion(Space *m, int elsize, int cnt);
void demodesign_colourize(Demodesign *c, float *col);
void demodesign_doradio(Demodesign *c, Demogroup *g, float k);
void demogroup_doradio(Demogroup *g, float k);

void demogroup_export(Group *g, FILE *fp);
void demogroup_import(Group *g, FILE *fp, int flags);


