#include <stdio.h>
#include <stdlib.h>

#define xres 320
#define yres 240
#define tres 512
#define bs_x 16
#define bs_y 16
#define bs_t 16
#define bs_all (bs_x*bs_y*bs_t)

#define x_cnt (xres/bs_x)
#define y_cnt (yres/bs_y)
#define t_cnt (tres/bs_t)

typedef struct {
  int xr, yr, tr;
  unsigned char *dat;
} Blok;


Blok *new_blk() {
  Blok *b=malloc(sizeof(Blok));
  b->dat=malloc(bs_all); b->xr=4; b->yr=4; b->tr=4;
  return b;
}
void blk_write(Blok *b, FILE *fp) {
  int i;
  unsigned char pakres;
  pakres=b->tr*36+b->yr*6+b->xr;
  fwrite(&pakres, 1, 1, fp);
//  for (i=0; i<1<<b->xr+b->yr+b->tr; i++) b->dat[i]&=~63;
  fwrite(b->dat, 1, 1<<b->xr+b->yr+b->tr, fp);
}

void blk_low(Blok *b) {
  int i, a;
  int xcost=0, ycost=0, tcost=0, cost=0;
  unsigned char *dat2;
  for (i=0; i<1<<b->xr+b->yr+b->tr; i++) {
    a=b->dat[i]-b->dat[i^1]; xcost+=a*a;
    a=b->dat[i]-b->dat[i^1<<b->xr]; ycost+=a*a;
    a=b->dat[i]-b->dat[i^1<<b->xr+b->yr]; tcost+=a*a;
  }
  if (!b->xr) xcost=0x7fffffff;
  if (!b->yr) ycost=0x7fffffff;
  if (!b->tr) tcost=0x7fffffff;
  cost=xcost<ycost&&xcost<tcost?xcost:ycost<tcost?ycost:tcost;
  if (cost>>((b->xr+b->yr+b->tr)*3>>1) > 80) return;
  dat2=malloc(1<<b->xr+b->yr+b->tr);
  if (xcost<ycost && xcost<tcost) {
    b->xr--;
    for (i=0; i<1<<b->xr+b->yr+b->tr; i++) dat2[i]=b->dat[i+i];
  } else if (ycost<tcost) {
    b->yr--;
    for (i=0; i<1<<b->xr+b->yr+b->tr; i++) dat2[i]=b->dat[i+(i&-(1<<b->xr))];
  } else {
    b->tr--;
    for (i=0; i<1<<b->xr+b->yr+b->tr; i++) dat2[i]=b->dat[i+(i&-(1<<b->xr+b->yr))];
  }
  free(b->dat); b->dat=dat2;
}




void packseq(char *pics) {
  Blok **blox=malloc(x_cnt*y_cnt*t_cnt*sizeof(Blok*));
  Blok *b;
  char *bp, *pp;
  int x, y, t, xx, yy, tt;
  for (t=0; t<t_cnt; t++) for (y=0; y<y_cnt; y++) for (x=0; x<x_cnt; x++) {
    b=blox[(t*y_cnt+y)*x_cnt+x]=new_blk();
    bp=b->dat;
    pp=pics+(t*bs_t*0*yres+y*bs_y)*xres+x*bs_x;
    for (tt=0; tt<bs_t; tt++) for (yy=0; yy<bs_y; yy++) for (xx=0; xx<bs_x; xx++)
      bp[(tt*bs_y+yy)*bs_x+xx]=pp[((((t*bs_t+tt))+1)*yres+yy)*xres+xx];
    b->xr=4; b->yr=4; b->tr=4;
    blk_low(b);
    blk_low(b);
    blk_low(b);
    blk_low(b);
    blk_low(b);
    blk_low(b);
    blk_low(b);
    blk_low(b);
  }
  {
    FILE *fp=fopen("pakked.dat", "w");
    for (t=0; t<t_cnt; t++) for (y=0; y<y_cnt; y++) for (x=0; x<x_cnt; x++) {
      b=blox[(t*y_cnt+y)*x_cnt+x];
      blk_write(b, fp);
    }
    fclose(fp);
  }  
  free(blox);
}


char dat[xres*yres*tres];
int main(int argc, char *argv[]) {
  int i, j;
  static char buffi[xres*yres*3], *dp;
  
  for (i=0; i<tres; i++) {
    char buf[256];
    int klu;
    FILE *fp=fopen((sprintf(buf, "ppms/lsd%04i", i), buf), "r");
    if (fp) {
      fgets(buf, sizeof(buf), fp); 
      klu=buf[1]=='6';
      fgets(buf, sizeof(buf), fp); 
      fgets(buf, sizeof(buf), fp);
      dp=dat+i*xres*yres;
      if (klu) {
        fread(buffi, xres*yres*3, 1, fp);
        for (j=0; j<xres*yres; j++) dp[j]=buffi[j*3+1];
      } else
        fread(dat+i*xres*yres, xres*yres, 1, fp);
      fclose(fp);
    }
  }
  packseq(dat);
  return 0;
}
