
uniform sampler2D intex;
uniform float xtiles;
uniform float ytiles;
uniform float pureColor;

void main() {
	vec2 tc = gl_TexCoord[0].xy;
		
	vec2 point = vec2(mod(tc.x, 1.0/xtiles), mod(tc.y, 1.0/ytiles));
	vec2 mid = vec2(1.0/xtiles*0.5, 1.0/ytiles*0.5);
	float dist = length(point-mid)*(xtiles+ytiles)*0.75;
	
	tc -= point;

	vec4 col = texture2D(intex, tc);

	if (col.r < dist) col.r = 0.0; else col.r = mix(col.r, 1.0, pureColor);
	if (col.g < dist) col.g = 0.0; else col.g = mix(col.g, 1.0, pureColor);
 	if (col.b < dist) col.b = 0.0; else col.b = mix(col.b, 1.0, pureColor);

	
	gl_FragColor = col;
}
