 
/*

  video functions header

*/

#ifndef VIDEOWIN_H
#define VIDEOWIN_H

#define DIRECTDRAW_VERSION 0x0300

#include <ddraw.h>
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

#include "framebuffer.h"

class videowin
{
private:

	HINSTANCE hinst; 
	IDirectDraw2* g_pDD2;
	IDirectDrawSurface* g_pDD2SPrimary;
	IDirectDrawSurface* g_pDD2SBack;
	HINSTANCE hdll;
	int oldresX,oldresY,oldresBPP;
	int vbufx,vbufy;
	int m_fullscreen;
	int g_videomode;
	unsigned long int colorLut[0x10000];
	HWND hwin;

	enum { rx0=-1, rx1=320, rx2=800, rx3=160*2 } xresenum;
	enum { ry0=-1, ry1=240, ry2=600, ry3=144*2 } yresenum;

	int x_res[4];
	int y_res[4];

public:

	videowin();
	void setViewport(int vbx,int vby);
	int init(framebuffer*,int,int);
	void free(framebuffer*);
	void blit(framebuffer*);
	void clear(framebuffer*,PIXEL color);

	void remapCursor(int vm,int*,int*);
	void setHinstance(HINSTANCE hi);
	HWND getHwnd();
};

#endif