   
/*
	
	  video class implementation
	  28/10/2001

*/ 


#include "videowin.h"
#include "omnilog.h"

static RECT g_rcScreen;
extern omnilog* theLog;

//
// constructor
//

videowin::videowin()
{
	m_fullscreen=0;
	g_videomode=-1;
	vbufx=0;
	vbufy=0;
	g_pDD2=0;
	g_pDD2SPrimary=0;
	g_pDD2SBack=0;

	//

	x_res[0]=rx0; x_res[1]=rx1; x_res[2]=rx2; x_res[3]=rx3;
	y_res[0]=ry0; y_res[1]=ry1; y_res[2]=ry2; y_res[3]=ry3;

	//

	theLog->write("building LUT for 16->32bit conversion...\n");

	for (int i=0;i<0x10000;i++)
	{
		int sho=i;

		colorLut[i]=((((sho))&0x1f)<<3) |
				    ((((sho)>>5)&0x3f)<<10) |
				    ((((sho)>>11)&0x1f)<<19);
	}

	theLog->write("done...\n");
}

void videowin::clear(framebuffer* fb,PIXEL color)
{
	for (int j=0;j<vbufy*vbufx;j++)
	{
		fb->vbuf[j]=color;
	}
}

//
// blitter
//

void videowin::blit(framebuffer* fb)
{
	PIXEL* buf=fb->vbuf;

	if (m_fullscreen)
	{
		HRESULT hres;
		unsigned short int* pBits;
		PIXEL* pSrc=buf;
		DDSURFACEDESC ddsd1;
		memset(&ddsd1,0,sizeof(ddsd1));
		ddsd1.dwSize=sizeof(ddsd1);

		g_pDD2SBack->GetSurfaceDesc(&ddsd1);

		hres=g_pDD2SBack->Lock(NULL,&ddsd1,DDLOCK_SURFACEMEMORYPTR|DDLOCK_WAIT,NULL);
		if (hres==DD_OK)
		{
			pBits=(unsigned short int*)ddsd1.lpSurface;
			int ptc=ddsd1.lPitch/2;
			unsigned short int* ppbits;

			for (int i=0;i<vbufy;i++)
			{
				int yv=((y_res[g_videomode]-vbufy)/2)*x_res[g_videomode]+ptc*i;
				ppbits=&pBits[yv+((x_res[g_videomode]-vbufx)/2)];

				memcpy(ppbits,pSrc,vbufx*2);
				pSrc+=vbufx;
			}
		
			g_pDD2SBack->Unlock(NULL);
		}

		// flip
		g_pDD2SPrimary->Flip(0,0);
	}
	else
	{
		HRESULT hres;
		DDSURFACEDESC ddsd1;
		PIXEL* pSrc=buf;

		memset(&ddsd1,0,sizeof(ddsd1));
		ddsd1.dwSize=sizeof(ddsd1);

		g_pDD2SBack->GetSurfaceDesc(&ddsd1);

		if (oldresBPP==16)
		{
			hres=g_pDD2SBack->Lock(NULL,&ddsd1,DDLOCK_SURFACEMEMORYPTR|DDLOCK_WAIT,NULL);
			if (hres==DD_OK)
			{
				PIXEL* pBits=(PIXEL*)ddsd1.lpSurface;
				int ptch=ddsd1.lPitch/2;
				int yoff=0;
				PIXEL* ppbits;

				for (int i=0;i<vbufy;i++)
				{
					ppbits=&pBits[yoff];
					memcpy(ppbits,pSrc,vbufx*sizeof(PIXEL));

					pSrc+=vbufx;
					yoff+=ptch;
				}
				
				g_pDD2SBack->Unlock(NULL);
			}
		}
		else if (oldresBPP==32)
		{
			hres=g_pDD2SBack->Lock(NULL,&ddsd1,DDLOCK_WAIT,NULL);
			if (hres==DD_OK)
			{
				int yoff=0;
				unsigned long int* pBits=(unsigned long int*)ddsd1.lpSurface;
				int ptch=ddsd1.lPitch/4;
				unsigned long int* ppbits;

				for (int i=0;i<vbufy;i++)
				{
					ppbits=&pBits[yoff];

					for (int r=0;r<vbufx;r++)
					{
						ppbits[r]=colorLut[*pSrc];
						pSrc++;
					}

					yoff+=ptch;
				}
			
				g_pDD2SBack->Unlock(NULL);
			}
		}

		// flip screen
		hres=g_pDD2SPrimary->Blt(&g_rcScreen,g_pDD2SBack,0,DDBLT_WAIT,NULL);
	}
}

void videowin::setHinstance(HINSTANCE hi)
{
	hinst=hi;
}

//
// window proc
//

long CALLBACK WindowProc( HWND hWnd, UINT wmess, WPARAM wParam, LPARAM lParam )
{
	int nVirtKey;
	int lKeyData;

	switch (wmess)
	{
		case WM_CREATE:
		{
			break;
		}
		case WM_DESTROY: 
		{
			PostQuitMessage(0);
			break;
		}
		case WM_PAINT:
		{
			break;
		}
		case WM_MOVE:
		{
			GetClientRect(hWnd, &g_rcScreen);
			ClientToScreen(hWnd, (POINT*)&g_rcScreen.left);
			ClientToScreen(hWnd, (POINT*)&g_rcScreen.right);
			break;
		}
		case WM_LBUTTONDOWN:
		{
			break;
		}
		case WM_LBUTTONUP:
		{
			break;
		}
		case WM_RBUTTONDOWN:
		{
			break;
		}
		case WM_RBUTTONUP:
		{
			break;
		}
		case WM_MOUSEMOVE:
		{
			break;
		}
		case WM_KEYDOWN:
		{
			nVirtKey=(int)wParam;
			lKeyData = lParam;   

			if (nVirtKey==VK_ESCAPE)
			{
				PostQuitMessage(0);
			}

			break;
		}
		case WM_KEYUP:
		{
			nVirtKey=(int)wParam;
			lKeyData = lParam;   
			break;
		}
	}

	return DefWindowProc(hWnd, wmess, wParam, lParam);
}

//
// init of display
// videomodes:
//		1 - 640x480
//		2 - 800x600
//		3 - 1024x748
//

int videowin::init(framebuffer* fb,int videomode,int fullscreen)
{
	WNDCLASS wc;
	HRESULT hres;
	const char* appName="win32 viagra";

	int dimx;
	int dimy;

	theLog->write("video interface creation starts...\n");

	// check if this is a re-init

	if (g_videomode!=-1)
	{
		// dispose old video
		PIXEL* vb=fb->vbuf;
		delete [] vb;

		if (m_fullscreen)
		{
			g_pDD2->SetDisplayMode(oldresX,oldresY,oldresBPP, 0, 0);
		}
		if (g_pDD2 != NULL)
		{
			if (g_pDD2SPrimary != NULL)
			{
				g_pDD2SPrimary->Release();
				g_pDD2SPrimary = NULL;
			}

			g_pDD2->Release();
			g_pDD2 = NULL;
		}

        FreeLibrary(hdll);

		// delete old win
		DestroyWindow(hwin);
	}

	// store videomode info

	g_videomode=videomode;
	m_fullscreen=fullscreen;

	// init dimensions

	vbufx=x_res[videomode];
	vbufy=y_res[videomode];
	dimx=x_res[videomode];
	dimy=y_res[videomode];

	fb->vbuf=new PIXEL [dimx*dimy];
	fb->bufx=dimx;
	fb->bufy=dimy;
	memset(fb->vbuf,0,dimx*dimy*sizeof(PIXEL));

	// create different windows
	// for different videomodes

	// dx fullscreen 
	if (m_fullscreen)
	{
		wc.style=0;
		wc.lpfnWndProc=WindowProc;
		wc.cbClsExtra=0;
		wc.cbWndExtra=0;
		wc.hInstance=hinst;
		wc.hIcon=LoadIcon(hinst,NULL);
		wc.hCursor=LoadCursor(0, IDC_ARROW);
		wc.hbrBackground=(struct HBRUSH__ *)GetStockObject(BLACK_BRUSH);
		wc.lpszMenuName=0;
		wc.lpszClassName="daHit";
		RegisterClass(&wc);

		RECT r;
		r.top=0;
		r.left=0;
		r.bottom=dimy;
		r.right=dimx;

		unsigned long style=WS_POPUP;
		unsigned long styleex=0;

		hwin=CreateWindowEx(styleex,"daHit",appName,style,
					        r.left,r.top,
							r.right,r.bottom,
							NULL,NULL,hinst,NULL);

		if (!hwin) 
		{
			theLog->write("unable to create fullscreen window\n");
			return 1;
		}

		ShowWindow(hwin,SW_SHOW);
		UpdateWindow(hwin);
		SetFocus(hwin);
	}
	// dx window
	else
	{
		//display window

		theLog->write("creating window (tm)...\n");

		wc.style=0;
		wc.lpfnWndProc=WindowProc;
		wc.cbClsExtra=0;
		wc.cbWndExtra=0;
		wc.hInstance=hinst;
		wc.hIcon=LoadIcon(hinst,NULL);
		wc.hCursor=LoadCursor(0, IDC_ARROW);
		wc.hbrBackground=(struct HBRUSH__ *)GetStockObject(BLACK_BRUSH);
		wc.lpszMenuName=0;
		wc.lpszClassName="daHit";
		RegisterClass(&wc);
		unsigned long style=WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX;

		// calcul8 *real* window size

		RECT re;
		re.top=0; re.left=0; re.right=dimx; re.bottom=dimy;
		AdjustWindowRect(&re,style,FALSE);
/*
		char strappo[2048];
		sprintf(strappo,"t [%d] l [%d] r [%d] b [%d]\n",re.top,re.left,re.right,re.bottom);
		theLog->write(strappo);
*/
		int realx,realy;
		realx=abs(re.left)+re.right;
		realy=abs(re.top)+re.bottom;
		hwin = CreateWindow("daHit",appName,style,
							  0,0,realx,
							  realy,
							  NULL,NULL,hinst,NULL);
		if (!hwin)
		{
			theLog->write("unable to create window\n");
			return 1;
		}

		theLog->write("done...\n");

		int xs=GetSystemMetrics(SM_CXSCREEN);
		int ys=GetSystemMetrics(SM_CYSCREEN);

		SetWindowPos(hwin,HWND_TOP,
					 (xs-realx)/2,
					 (ys-realy)/2,
					 0,0,SWP_NOSIZE);
		ShowWindow(hwin,SW_SHOW);
		UpdateWindow(hwin);
		SetFocus(hwin);

		theLog->write("window positioned...\n");
	}

	//
	// set up dx and surfaces
	//

	if (m_fullscreen)
	{
	    DDSURFACEDESC ddsd1;
		IDirectDraw* dd_directx1;
		typedef HRESULT (WINAPI* ddc_proc)(GUID FAR *lpGUID,        
										   LPDIRECTDRAW FAR *lplpDD,  
										   IUnknown FAR *pUnkOuter); 

		ddc_proc ddcreateFunc;

	    hdll=LoadLibrary("ddraw.dll");
		if (hdll==NULL)
		{
			MessageBox(NULL,"error","unable to load ddraw.dll",MB_OK);
			return 1;
		}

		// attach function
		ddcreateFunc=(ddc_proc)GetProcAddress(hdll, "DirectDrawCreate");
		if (ddcreateFunc == NULL)
		{
			MessageBox(NULL,"error","unable to attach DirectDrawCreate",MB_OK);
			return 1;
		}

		// create dx interface object
		hres=ddcreateFunc(NULL,&dd_directx1,NULL);
		if (hres!=DD_OK)
		{
			MessageBox(NULL,"error","unable to create DX interface",MB_OK);
			return 1;
		}

		//
		hres=dd_directx1->QueryInterface(IID_IDirectDraw2,(void **)&g_pDD2);
		if (hres!=DD_OK)
		{
			MessageBox(NULL,"error","unable to query DX interface",MB_OK);
			return 1;
		}
		dd_directx1->Release();
 
		// try to guess which videomode and bpp are we using

		DDSURFACEDESC sd;
		memset(&sd,0,sizeof(sd));
		sd.dwSize=sizeof(sd);
		hres=g_pDD2->GetDisplayMode(&sd);
		if (hres!=DD_OK)
		{
			MessageBox(NULL,"error","unable to get video mode",MB_OK);
			return 1;
		}

		oldresX=sd.dwWidth;
		oldresY=sd.dwHeight,
		oldresBPP=sd.ddpfPixelFormat.dwRGBBitCount;

		// set cooperative level
		hres=g_pDD2->SetCooperativeLevel(hwin,DDSCL_EXCLUSIVE|DDSCL_FULLSCREEN);
		if (hres!=DD_OK)
		{
			MessageBox(NULL,"error","unable to set cooperative level",MB_OK);
			return 1;
		}

		// set videomode
		hres=g_pDD2->SetDisplayMode(dimx,dimy,16,0,0);
		if (hres!=DD_OK)
		{
			MessageBox(NULL,"error","unable to set fullscreen display mode",MB_OK);
			return 1;
		}

		// Create the primary surface with 1 back buffer
		ZeroMemory(&ddsd1, sizeof(ddsd1));
		ddsd1.dwSize = sizeof(ddsd1);
		ddsd1.dwHeight=dimy;
		ddsd1.dwWidth=dimx;
		ddsd1.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
		ddsd1.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE |
                			  DDSCAPS_FLIP |
                			  DDSCAPS_COMPLEX;
        ddsd1.dwBackBufferCount = 1;

		hres=g_pDD2->CreateSurface(&ddsd1,&g_pDD2SPrimary,NULL);
		if (hres != DD_OK)
		{
			char err[256];
			sprintf(err,"primary surface err %d",hres);
			g_pDD2->SetDisplayMode(oldresX,oldresY,oldresBPP, 0, 0);
			MessageBox(NULL,"error",err,MB_OK);
			return 1;
		}

		// create backbuffer
		memset(&ddsd1.ddsCaps,0,sizeof(ddsd1.ddsCaps));
		ddsd1.ddsCaps.dwCaps=DDSCAPS_BACKBUFFER; 
        hres = g_pDD2SPrimary->GetAttachedSurface(&ddsd1.ddsCaps, &g_pDD2SBack);
		if (hres != DD_OK)
		{
			g_pDD2->SetDisplayMode(oldresX,oldresY,oldresBPP, 0, 0);
			MessageBox(NULL,"error","secondary surface",MB_OK);
			return 1;
		}

		// fill surfaces with black 

		DDBLTFX ddbltfx; 
	    ddbltfx.dwSize = sizeof(ddbltfx); 
		ddbltfx.dwFillColor = 0;
		g_pDD2SPrimary->Blt(0,0,0,DDBLT_COLORFILL,&ddbltfx);
		g_pDD2SBack->Blt(0,0,0,DDBLT_COLORFILL,&ddbltfx);
	}
	else
	{
		IDirectDraw* dd_directx1;
		typedef HRESULT (WINAPI* ddc_proc)(GUID FAR *lpGUID,        
										   LPDIRECTDRAW FAR *lplpDD,  
										   IUnknown FAR *pUnkOuter); 
		ddc_proc ddcreateFunc;

	    hdll=LoadLibrary("ddraw.dll");
		if (hdll==NULL)
		{
			MessageBox(NULL,"error","unable to load ddraw.dll",MB_OK);
			return 1;
		}

		// attach function
		ddcreateFunc=(ddc_proc)GetProcAddress(hdll, "DirectDrawCreate");
		if (ddcreateFunc == NULL)
		{
			MessageBox(NULL,"error","unable to attach DirectDrawCreate",MB_OK);
			return 1;
		}

		theLog->write("ddraw.dll loaded and attached...\n");

		// create dx interface object
		hres=ddcreateFunc(NULL,&dd_directx1,NULL);
		if (hres!=DD_OK)
		{
			MessageBox(NULL,"error","unable to create DX interface",MB_OK);
			return 1;
		}

		//
		hres=dd_directx1->QueryInterface(IID_IDirectDraw2,(void **)&g_pDD2);
		if (hres!=DD_OK)
		{
			MessageBox(NULL,"error","unable to query DX interface",MB_OK);
			return 1;
		}
		dd_directx1->Release();
 
		// try to guess which videomode and bpp are we using

		DDSURFACEDESC sd;
		memset(&sd,0,sizeof(sd));
		sd.dwSize=sizeof(sd);
		hres=g_pDD2->GetDisplayMode(&sd);
		if (hres!=DD_OK)
		{
			MessageBox(NULL,"error","unable to get video mode",MB_OK);
			return 1;
		}

		oldresX=sd.dwWidth;
		oldresY=sd.dwHeight,
		oldresBPP=sd.ddpfPixelFormat.dwRGBBitCount;

		if ( (oldresBPP!=16) && (oldresBPP!=32) )
		{
			MessageBox(NULL,"Sorry, only 16 and 32 bpp videomodes are supported in this release.","error",MB_OK);
			theLog->write("Sorry, only 16 and 32 bpp videomodes are supported in this release.");
			return 1;
		}

		theLog->write("setting cooperative level...\n");

		// set cooperative level
		hres=g_pDD2->SetCooperativeLevel(hwin,DDSCL_NORMAL);
		if (hres!=DD_OK)
		{
			MessageBox(NULL,"error","unable to set cooperative level",MB_OK);
			return 1;
		}

		theLog->write("set...\n");

		// Create the primary surface
	    DDSURFACEDESC ddsd1;
		memset(&ddsd1,0,sizeof(ddsd1));
		ddsd1.dwSize=sizeof(ddsd1);
//		ddsd1.dwHeight=dimy;
//		ddsd1.dwWidth=dimx;
		ddsd1.dwFlags=DDSD_CAPS;
		ddsd1.ddsCaps.dwCaps=DDSCAPS_PRIMARYSURFACE|DDSCAPS_VIDEOMEMORY;

		theLog->write("creating primary surface...\n");

		hres=g_pDD2->CreateSurface(&ddsd1,&g_pDD2SPrimary,NULL);
		if (hres != DD_OK)
		{
			MessageBox(NULL,"error","primary surface",MB_OK);
			return 1;
		}

		theLog->write("primary surface created...\n");
		
		// back buffer
		memset(&ddsd1,0,sizeof(ddsd1));
		ddsd1.dwSize=sizeof(ddsd1);
		ddsd1.dwFlags=DDSD_WIDTH|DDSD_HEIGHT|DDSD_CAPS;
		ddsd1.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN;

		/* always use video memory (?) */
//		ddsd1.ddsCaps.dwCaps|=DDSCAPS_SYSTEMMEMORY;
		ddsd1.ddsCaps.dwCaps|=DDSCAPS_VIDEOMEMORY; 

		if (videomode==3)
		{
			ddsd1.dwWidth=dimx/2;
			ddsd1.dwHeight=dimy/2;
		}
		else
		{
			ddsd1.dwWidth=dimx;
			ddsd1.dwHeight=dimy;
		}

		theLog->write("creating secondary surface...\n");

		hres=g_pDD2->CreateSurface(&ddsd1,&g_pDD2SBack,NULL);
		if (hres != DD_OK)
		{
			MessageBox(NULL,"error","secondary surface",MB_OK);
			return 1;
		}

		theLog->write("secondary surface created...\n");

		// clipper
		typedef HRESULT (WINAPI *DDCreateClipperFun) ( DWORD dwFlags, LPDIRECTDRAWCLIPPER FAR *lplpDDClipper, IUnknown FAR *pUnkOuter );
		IDirectDrawClipper *pddcClipper=NULL;
		DDCreateClipperFun DDCreateClipper=NULL;

		DDCreateClipper=(DDCreateClipperFun)GetProcAddress(hdll,"DirectDrawCreateClipper");
		if (DDCreateClipper!=NULL)
		{
			hres=DDCreateClipper(0,&pddcClipper,NULL);
			if (hres!=DD_OK)
			{
				MessageBox(0,"error","creating clipper",MB_OK);
				return 1;
			}
		}

		if (pddcClipper!=NULL)
		{
			hres=pddcClipper->SetHWnd(0,hwin);
			if (hres==DD_OK)
			{
				g_pDD2SPrimary->SetClipper(pddcClipper);
				pddcClipper->Release();
			}
			else
			{
				MessageBox(0,"error","setting clipper",MB_OK);
				return 1;
			}
		}

		// fill surfaces with black 

		DDBLTFX ddbltfx; 
	    ddbltfx.dwSize = sizeof(ddbltfx); 
		ddbltfx.dwFillColor = 0;
		g_pDD2SPrimary->Blt(0,0,0,DDBLT_COLORFILL,&ddbltfx);
		g_pDD2SBack->Blt(0,0,0,DDBLT_COLORFILL,&ddbltfx);
	}

	theLog->write("video interface creation ends...\n");

	return 0;
}

// get HWND

HWND videowin::getHwnd()
{
	return hwin;
}

//  freeDisplay

void videowin::free(framebuffer* fb)
{
	PIXEL* vb=fb->vbuf;
	delete [] vb;

	if (m_fullscreen)
	{
		g_pDD2->SetDisplayMode(oldresX,oldresY,oldresBPP, 0, 0);
	}

	if (g_pDD2 != NULL)
	{
		if (g_pDD2SPrimary != NULL)
		{
			g_pDD2SPrimary->Release();
			g_pDD2SPrimary = NULL;
		}

		g_pDD2->Release();
		g_pDD2 = NULL;
	}

    FreeLibrary(hdll);
}

