 
/*

  timing.cpp

*/

#include "timing.h"

//

timing* theTimer;

//

timing::timing(int frequency)
{
	BOOL rv;
	LARGE_INTEGER pfq;
	LARGE_INTEGER initime;

	// check for high precision timer

	rv=QueryPerformanceFrequency(&pfq);
	if (rv==0)
	{
		MessageBox(0,"this machine doesn't support RDTSC (486?).","error",MB_OK);
		return ;
	}

	pfq64=pfq.QuadPart;
	oneframe=pfq64/frequency;

	rv=QueryPerformanceCounter(&oldt);
	if (rv==0)
	{
		MessageBox(0,"this machine doesn't support RDTSC (486?).","error",MB_OK);
		return ;
	}

	QueryPerformanceCounter(&initime);
	initime64=initime.QuadPart;
	curt=oldt;
	oldframes=0;
	curframes=0;
	oldsec=0;
	gfps=0;

	// load in font

	font1=new font(font1_normal,FONT1_WIDTH,FONT1_HEIGHT,256);
}

//

void timing::trimSpeed()
{
	__int64 curt64,oldt64;
	
	QueryPerformanceCounter(&curt);

	curt64=curt.QuadPart;
	oldt64=oldt.QuadPart;

	while ((curt64-oldt64)<oneframe)
	{
		QueryPerformanceCounter(&curt);
		curt64=curt.QuadPart;
	}

	oldt=curt;
}

float timing::secsElapsed()
{
	__int64 curt64;
	LARGE_INTEGER curtime;
	
	QueryPerformanceCounter(&curtime);
	curt64=curtime.QuadPart;

	float fct=(float)curt64;
	float fot=(float)initime64;
	float ffq=(float)pfq64;
	return ((fct-fot)/ffq);
}

void timing::drawFps(framebuffer* fb)
{
	int sec=(int)secsElapsed();

	curframes++;

	if (sec>oldsec)
	{
		// one second is elapsed:
		// update oldsec, update oldframes
		// count fps

		gfps=(curframes-oldframes);
		oldframes=curframes;
		oldsec=sec;
	}

	char strfps[16];
	sprintf(strfps,"[%3d][%3.3d]",oldsec,gfps);
//	font1->drawString(fb,strfps,fb->bufx-font1->getWidth()*16,10,0,0xffff,0);
	font1->drawString(fb,strfps,0,0,0,0xffff,0);
}

//

timing::~timing()
{
	delete(font1);
}