  
/*

  font class
  hittracker

  10/5/2002

*/
 
#include "font.h"

//

font::font(unsigned char* pdata,int width,int height,int nc)
{
	m_width=width;
	m_height=height;
	numchars=nc;
	m_pdata=pdata;

/*
	// init color scale

	for (int i=0;i<256;i++)
	{
		int r,g,b;

		int rc=Get16bRedComponent(m_color)<<3;
		int gc=Get16bGreenComponent(m_color)<<2;
		int bc=Get16bBlueComponent(m_color)<<3;

		r=((0*(256-i))+(rc*i))>>8;
		g=((0*(256-i))+(gc*i))>>8;
		b=((0*(256-i))+(bc*i))>>8;

		colscale[255-i]=Make16bColor8bpp(r,g,b);		
	}
*/
}

// unclipped
void font::drawString(framebuffer* fb,char* s,int x,int y,int blend,PIXEL color,PIXEL bgcolor)
{
	int i=0;

	while (*s)
	{
		// font image is 8 chars * 32 chars

		unsigned char* pm=&m_pdata[((*s)&7)*m_width+((*s)>>3)*8*m_width*m_height];
		PIXEL* vbp=&fb->vbuf[x+(i*m_width)+y*fb->bufx];

		if (blend)
		{
			for (int yp=0;yp<m_height;yp++)
			{
				for (int xp=0;xp<m_width;xp++)
				{
					if ((*pm)!=0xff)
					{
						*vbp=color;
					}

					pm++;
					vbp++;
				}

				pm+=7*m_width;
				vbp+=fb->bufx-m_width;
			}
		}
		else
		{
			for (int yp=0;yp<m_height;yp++)
			{
				for (int xp=0;xp<m_width;xp++)
				{
					if ((*pm)!=0xff)
					{
						*vbp=color;
					}
					else
					{
						*vbp=bgcolor;
					}

					pm++;
					vbp++;
				}

				pm+=7*m_width;
				vbp+=fb->bufx-m_width;
			}
		}

		s++;
		i++;
	}
}

int font::getHeight()
{
	return m_height;
}

int font::getWidth()
{
	return m_width;
}