.386p
Rlens equ 64
Dlens equ Rlens*2
;˻
;̹     SHOARMA - 64K INTRO FOR TAKEOVER '98                                ̹
;ʼ
_TEXT   segment use32 dword public 'CODE'
        assume  cs:_TEXT,ds:_DATA
        include pushregs.mac
start:  jmp short _main
        db 'WATCOM'
_main:
        sti
        cld

        call    initialize
        jc      main_vaud
        call    start_muziek

        call    part_one
        call    part_two
        call    part_three
        call    part_four

        call    clear_keybuffer
        call    xmpStop_
        call    logout
        call    showpic
        mov     ax,4c00h
        int     21h

main_vaud:
        mov     ax,3
        int     10h
        mov     eax,0900h
        int     21h
        mov     ax,4c00h
        int     21h

;ͻ
;      MAIN ROUTINES/LOOPS                                                 
;ͼ

PART_ONE PROC
        call    rain_pall
mainl1:
        call    update_rain
        mov     esi,rain
        mov     edi,vga
        call    wait_retrace
        call    wait_retrace
        call    smallflip
        call    xmpGetPos_
        cmp     ah,1
        jb      mainl1
        call    wobble          ;+wobble
mainl2:
        call    update_rain     ;rain
        mov     esi,rain
        mov     edi,vga
        call    wait_retrace
        call    wait_retrace
        call    smallflip
        call    xmpGetPos_
        cmp     ah,5
        jb      mainl2

        call    savepall
        mov     ecx,30
        push    ecx
mainl3:
        mov     edi,rain
        call    blur
        mov     esi,rain
        mov     edi,vga
        call    wait_retrace
        call    smallflip
        mov     ebx,dword ptr[esp]
        shl     ebx,1
        mov     ecx,255
        mov     ebp,0
        call    wait_retrace
        call    pallfade
        dec     dword ptr[esp]
        jnz     mainl3
        add     esp,4

        ret
PART_ONE ENDP

PART_TWO PROC
        xor     eax,eax
        mov     ecx,320*200
        mov     edi,vga
        call    clear

        mov     esi,offset ali
        mov     edi,vaddr5
        call    flip
        call    wait_retrace
        call    alishredderpal
        call    savepall
        call    water           ;water
        ret
PART_TWO ENDP

PART_THREE PROC
        mov     esi,offset shoarma
        mov     edi,vga
        call    smallflip
        call    wait_retrace
        mov     edx,3c8h
        mov     al,1
        out     dx,al
        inc     edx
        mov     al,63
        out     dx,al
        out     dx,al
        out     dx,al

mains_l1:
        call    xmpgetpos_
        cmp     ah,14
        jb      mains_l1

mains_l2:
        call    xmpgetpos_
        cmp     al,50
        jb      mains_l2

        xor     eax,eax
        mov     edi,vga
        mov     ecx,320*200
;        call    clear
        call    init_bump
        call    rain_pall


        call    xmpgetpos_
        movzx   ebx,ah
        inc     ebx
        mov     eax,10
        call    credits

        call    xmpgetpos_
        movzx   ebx,ah
        inc     ebx
        mov     eax,12
        call    credits

        call    xmpgetpos_
        movzx   ebx,ah
        inc     ebx
        mov     eax,14
        call    credits

        call    xmpgetpos_
        movzx   ebx,ah
        inc     ebx
        mov     eax,16
        call    credits
        call    fadedown

        ret
PART_THREE ENDP

PART_FOUR PROC
                        ;cometen(1)+lens(2)+blurrende groeten(3)
        mov     ecx,320*200
        mov     edi,vga
        call    clear
        call    comet_pal
partfour_l1:

        call    maak_bewegende_kometen

        mov     esi,cometscherm
        mov     edi,vaddr2
        call    flip

        call    xmpgetpos_

        test    al,32
        jnz     part4_z1

        xor     eax,eax
        mov     ecx,320*200
        mov     edi,vaddr3
        call    clear


        call    xmpgetpos_
        movzx   eax,ah
        sub     eax,13
        shl     eax,1
        add     eax,1
        cmp     eax,44
        ja      part4_einde
        push    eax
        mov     dword ptr [advert_pos],eax
        mov     edi,vaddr3
        add     edi,320*100
        call    schrijfadvert3          ;vanaf 19
        pop     eax
        inc     eax

        mov     dword ptr [advert_pos],eax
        mov     edi,vaddr3
        add     edi,320*150
        call    schrijfadvert3          ;vanaf 19
        jmp     part4_nz1
part4_z1:
        mov     edi,vaddr3
        call    blur
part4_nz1:

        mov     dword ptr [advert_pos],18
        mov     edi,vaddr2
        add     edi,320*10
        call    schrijfadvert3          ;vanaf 19

        mov     ecx,320*200
        mov     esi,vaddr3
        mov     edi,vaddr2
part4_l2:
        mov     al,[esi+ecx-1]
        cmp     al,0
        je      part4_e1
        mov     [edi+ecx-1],al
part4_e1:
        dec     ecx
        jnz     part4_l2


        mov     esi,vaddr2
        mov     edi,vaddr4
        call    flip

        mov     esi,vaddr2
        mov     edi,vaddr4
        call    lensje


        mov     eax,lensxdir
        add     dword ptr[lens_x],eax
        cmp     dword ptr[lens_x],220
        jb      part4_lb1
        neg     dword ptr[lensxdir]
part4_lb1:
        cmp     dword ptr[lens_x],1
        jnb     part4_lb3
        neg     dword ptr[lensxdir]
part4_lb3:
        mov     eax,lensydir
        add     dword ptr[lens_y],eax
        cmp     dword ptr[lens_y],110
        jb      part4_lb2
        neg     dword ptr[lensydir]
part4_lb2:
        cmp     dword ptr[lens_y],1
        jnb     part4_lb4
        neg     dword ptr[lensydir]
part4_lb4:

        mov     esi,vaddr4
        mov     edi,vga
        call    wait_retrace
        call    smallflip

        jmp     partfour_l1
part4_einde:
        mov     ecx,30
        push    ecx
part4_l3:
        mov     edi,vaddr4
        call    blur
        mov     esi,vaddr4
        mov     edi,vga
        call    wait_retrace
        call    smallflip
        dec     dword ptr[esp]
        jnz     part4_l3
        add     esp,4
        ret
PART_FOUR ENDP

;ͻ
;      TEXTMODE                                                           
;ͼ
SHOWPIC PROC
        mov     esi,offset ansi
        mov     edi,0b8000h
        mov     ecx,160*19/4
        push    es
        push    ds
        pop     es
        rep     movsd
        pop     es

        mov     ah,2
        xor     bx,bx
        mov     dh,19
        xor     dl,0
        int     10h
        ret
SHOWPIC ENDP

;ͻ
;      LENS                                                               
;ͼ

INIT_LENS PROC
;dittum
        mov     edi,offset lens_transform
        xor     ecx,ecx
lensje_l7:
        xor     edx,edx
lensje_l8:                      ;ecx:y  edx:x < tellers, niet veranderen
        push    ecx
        sub     dword ptr[esp],Rlens
        push    edx
        sub     dword ptr[esp],Rlens

        fild    dword ptr[esp+4]
        fmul    st(0),st(0)
        fild    dword ptr[esp]
        fmul    st(0),st(0)
        faddp
        fsqrt
        fistp   dword ptr[esp+4]

        add     esp,4
        pop     ebx     ;=afstand tot midden..

        cmp     ebx,Rlens+1
        jnb     lensje_groterdan16

        ;i=x * d / ( rc^2 + d^2 - x^2 )^0.5
        ;j=y * d / ( rc^2 + d^2 - y^2 )^0.5

        push    ecx
        sub     dword ptr[esp],Rlens

        fild    dword ptr[esp]
        fild    lens_afstand
        fmulp
        fild    lens_straal
        fmul    st(0),st(0)
        fild    lens_afstand
        fmul    st(0),st(0)
        faddp
        fild    dword ptr[esp]
        fmul    st(0),st(0)
        fsubp
        fsqrt
        fdivp
        fistp   dword ptr[esp]

        pop     eax
        add     eax,Rlens

        push    edx
        sub     dword ptr[esp],Rlens

        fild    dword ptr[esp]
        fild    lens_afstand
        fmulp
        fild    lens_straal
        fmul    st(0),st(0)
        fild    lens_afstand
        fmul    st(0),st(0)
        faddp
        fild    dword ptr[esp]
        fmul    st(0),st(0)
        fsubp
        fsqrt
        fdivp
        fistp   dword ptr[esp]

        pop     ebx
        add     ebx,Rlens

        imul    eax,320
        add     eax,ebx         ;en   ebx=x      "   "  edx
        jmp     lensje_nieuwewaardeOK
lensje_groterdan16:

        mov     eax,ecx
        imul    eax,320
        add     eax,edx

lensje_nieuwewaardeOK:

        mov     [edi+edx*4],eax
        inc     edx
        cmp     edx,Dlens
        jne     lensje_l8
        add     edi,Dlens*4
        inc     ecx
        cmp     ecx,Dlens
        jne     lensje_l7

;hiero
        ret
INIT_LENS ENDP


LENSJE PROC
        ;in:esi=bron
        ;   edi=doel

        mov     ebp,offset lens_transform

        mov     ebx,lens_Y
        imul    ebx,320
        add     ebx,lens_X
        add     esi,ebx

        mov     ecx,0           ;y
lensje_l2:
        mov     edx,0           ;x
lensje_l1:
        mov     eax,[ebp]
        mov     al,[esi+eax]    ;no way, 64/320 schaal
        mov     byte ptr[edi+ebx],al

        inc     ebx
        add     ebp,4
        inc     edx
        cmp     edx,Dlens
        jb      lensje_l1
        add     ebx,320-Dlens
        inc     ecx
        cmp     ecx,Dlens
        jb      lensje_l2

        ret
LENSJE ENDP


;ͻ
;      KOMETEN                                                            
;ͼ


MAKECOS PROC
        ;cosindex[x] == 10(cos(x/10)+1) range: [0;20]
        ;in     nothing
        ;out            cosindex = 2000 cosinus values
        ;fuzzed                 ECX,EDX
        mov     ecx,2000                        ;2000 cosinus-values
        mov     dword ptr coscounter,0
        mov     dword ptr temp,1
        mov     dword ptr temp2,10
        mov     dword ptr temp3,10
        mov     edi,offset cosindex
cosl1:
        fild    dword ptr coscounter
        fidiv   dword ptr temp3
        fcos
        fiadd   dword ptr temp
        fimul   dword ptr temp2
        fistp   dword ptr [edi]

        add     dword ptr coscounter,1
        add     edi,4
        dec     ecx
        JNZ     COSL1
        ret
MAKECOS ENDP

MAAK_BEWEGENDE_KOMETEN PROC
        ;in     ebp                             ;djezus.. dit sucked:)
        ;               out     ebp
        ;                       fuzzed  esi, edi, ecx, ebx, eax, edx
        mov     esi,offset spritepos    ;esi: points to spritepos
        mov     edi,offset cosindex     ;edi: points to cosinus-index
downupl1:
        push    ebp
        mov     ebp,offset spritecospos ;ebp: first pushed, cos-counter
        mov     ecx,8                   ;ecx: number of komets
downupl2:

        mov     ebx,ecx
        dec     ebx
        shl     ebx,2
        xor     eax,eax
        xor     edx,edx
        mov     ax,[esi+ebx+2]          ;comet xpos

        cmp     ax,291                  ;clipping
        jb      comet_maxX_OK
        mov     word ptr [esi+ebx+2],36
        jmp     dontchangeax
comet_maxX_OK:
        cmp     ax,35
        jnb     comet_minX_OK
        mov     word ptr [esi+ebx+2],290
        jmp     dontchangeax
comet_minX_OK:
        mov     edx,[spritedir+ebx]
        add     word ptr [esi+ebx+2],dx ;increase xpos
dontchangeax:

        shl     eax,16
        mov     dx,[esi+ebx]            ;comet ypos
        cmp     dx,198
        jb      incdx
        mov     word ptr [esi+ebx],0
        jmp     dontchangedx
incdx:
        push    edx
        mov     dx,word ptr [esi+ebx]

        add     dx,1
        mov     word ptr [esi+ebx],dx  ;increase ypos
        pop     edx
dontchangedx:
        add     eax,edx                 ;put 'em together

        fild    dword ptr [ebp+ebx]     ;calculate cosinus' change
        mov     temp,10
        fidiv   dword ptr temp
        fcos
        mov     temp,1
        fiadd   dword ptr temp
        mov     temp,10
        fimul   dword ptr temp
        fistp   dword ptr temp

        cmp     temp,10
        jne     tempnotzero
        inc     [spritel+ebx]
        cmp     [spritel+ebx],4
        jne     tempnotzero
        neg     [spritedir+ebx]
        mov     [spritel+ebx],0
tempnotzero:

        add     eax,temp                ;put 'em together
        inc     dword ptr [ebp+ebx]     ;increase cosinus-pos
        pushall
        call    putsprite
        popall

        dec     ecx
        jnz     downupl2

        mov     edi,cometscherm
        call    blur_all

        add     esp,4
        ret
MAAK_BEWEGENDE_KOMETEN ENDP

PUTSPRITE PROC
        mov     esi, offset sprite01
        mov     edi, cometscherm

        xor     edx,edx
        mov     dx,ax

        mov     ebx,edx
        shl     ebx,6
        shl     edx,8
        add     edx,ebx

        shr     eax,16
        add     edx,eax

        mov     ebx,8
spritewritel2:
        mov     ecx,8
spritewritel1:
        mov     al, byte ptr [esi]
        cmp     edx,320*200
        jnb     putsprite_ohow
        add     byte ptr [edi+edx], al
        inc     edx
        inc     esi
        dec     ecx
        JNZ     SPRITEWRITEL1
        add     edx,320-8
        dec     ebx
        JNZ     SPRITEWRITEL2
putsprite_ohow:
        ret
PUTSPRITE ENDP

;ͻ
;      BUMPLOOP                                                           
;ͼ

CREDITS PROC
        push    ebx             ;eax 9 ebx xmpgetpos
        push    eax
        mov     esi,randomscherm_2
        mov     edi,randomscherm_1
        call    flip
        mov     dword ptr [advert_pos],eax
        mov     edi,randomscherm_1
        add     edi,320*70
        call    schrijfadvert2
        pop     eax
        inc     eax
        mov     dword ptr [advert_pos],eax
        mov     edi,randomscherm_1
        add     edi,320*120
        call    schrijfadvert2

        mov     ecx,500
random_l1:
        mov     esi,randomscherm_1
        mov     edi,vaddr2
        mov     edx,bumpy
        shl     edx,16
        add     edx,bumpx
        call    bump2
        mov     edi,vaddr2
        mov     ecx,200
lalala:
        imul    ebx,ecx,320
        mov     byte ptr[edi+ebx],0
        dec     ecx
        jnz     lalala

        mov     esi,vaddr2
        mov     edi,vga
        call    smallflip

        add     bumpx,3
        cmp     bumpxdir,0
        je      random_e1
        sub     bumpx,6
random_e1:
        cmp     bumpx,320
        jb      random_b1
        xor     dword ptr bumpxdir,1
random_b1:
        mov     eax,bumpydir
        add     dword ptr bumpy,2
        cmp     bumpydir,0
        je      random_e2
        sub     bumpy,4
random_e2:
        cmp     bumpy,200
        jb      random_b2
        xor     dword ptr bumpydir,1
random_b2:

        mov     ebx,[esp]
        call    xmpgetpos_
        movzx   eax,ah
        cmp     eax,ebx
        jbe     random_l1
        add     esp,4
        ret
CREDITS ENDP


;ͻ
;      RANDOM BACKGROUND                                                   
;ͼ

RANDOM_BACKGD PROC
        ;in     edi:dest.
        mov     ecx,320*200
rbgd_l1:
        in      ax,40h
        add     eax,random
        ror     eax,3
        add     random,eax
        mov     [edi+ecx],al
        dec     ecx
        jnz     rbgd_l1
        ret
RANDOM_BACKGD ENDP

;ͻ
;      RAIN                                                                
;ͼ


update_rain PROC
        pushall
        mov     edi,rain
        mov     ecx,320
upd_l3:
        in      al,40h
        add     eax,edx
        add     edx,eax
        mov     [edi+ecx-1],al
        mov     [edi+ecx+319],al
        dec     ecx
        jnz     upd_l3
        mov     esi,rain
        mov     ebp,641
        mov     edi,197
upd_l1:
        mov     ecx,318
upd_l2:
        movzx   eax,byte ptr[esi+ebp-320]
        add     eax,eax
        movzx   ebx,byte ptr[esi+ebp-640]
        movzx   edx,byte ptr[esi+ebp]
        add     eax,ebx
        add     eax,edx
        shr     eax,2
        cmp     eax,220
        jna     upd_na1
        dec     eax
upd_na1:
        mov     byte ptr[esi+ebp],al
        add     ebp,1
        dec     ecx
        jnz     upd_l2
        add     ebp,2
        dec     edi
        jnz     upd_l1
        popall
        ret
update_rain ENDP

;ͻ
;      BUMPMAPPING                                                         
;ͼ

INIT_BUMP PROC
        mov     edi,randomscherm_1
        call    random_backgd
        mov     edi,randomscherm_1
        call    blur
        mov     esi,randomscherm_1
        mov     edi,randomscherm_2
        call    flip
        mov     bumpx,50
        mov     bumpy,120
        mov     edi,offset enviromentmap
        mov     ebp,255*255
        xor     ebp,ebp
        mov     ecx,256
init_bump_l1:
        mov     edx,256
init_bump_l2:
        mov     eax,edx         ;x
        mov     ebx,ecx         ;y
        sub     eax,128
        sub     ebx,128
        push    eax
        fild    dword ptr[esp]
        fmul    st(0),st(0)
        push    ebx
        fild    dword ptr[esp]
        fmul    st(0),st(0)
        faddp
        fadd    st(0),st(0)
        fsqrt
        pop     eax
        fistp   dword ptr[esp]
        pop     ebx
        mov     eax,128
        sub     eax,ebx

        cmp     eax,256
        jb      init_bump_b1
        mov     eax,0 ;255
init_bump_b1:

        mov     [edi+ebp],al

        inc     ebp
        dec     edx
        jnz     init_bump_l2
;        add     ebp,320-256
        dec     ecx
        jnz     init_bump_l1
        ret
INIT_BUMP ENDP

BUMP2 PROC
        ;in:            esi: bron
        ;               edi: doel

;        mov     esi,vaddr2
;        mov     edi,vaddr3
        mov     ebx,offset enviromentmap
        push    ebx
        mov     ebp,320*200
        mov     ecx,200*256*256
bump2_l1:
        mov     cx,320
bump2_l2:
        movzx   ax,byte ptr[esi+ebp-1]
        movzx   bx,byte ptr[esi+ebp+1]
        sub     ax,bx
        push    ecx
        sub     cx,dx
        sub     ax,cx
        add     ax,128

        test    ax,0FF00h
        jz      bump2_z1
        xor     ax,ax
bump2_z1:
        push    ax                      ;de X!!

        movzx   ax,byte ptr[esi+ebp-320]
        movzx   bx,byte ptr[esi+ebp+320]
        sub     ax,bx

        sub     ecx,edx
        shr     ecx,16
        sub     ax,cx
        add     ax,128


        test    ax,0FF00h
        jz      bump2_z2
        xor     ax,ax
bump2_z2:
        pop     bx                      ;x in bx, y in ax, offset in envmap
        pop     ecx

        shl     ax,8
        add     ax,bx
        mov     ebx,[esp]
        mov     al,byte ptr[ebx+eax]
        mov     byte ptr[edi+ebp],al

        dec     ebp
        dec     cx
        jnz     bump2_l2

        sub     ecx,010000h
        and     ecx,0FFFF0000h
        jnz     bump2_l1
        add     esp,4
        ret
BUMP2 ENDP

;ͻ
;      FAKE SINUS WOBBLER                                                  
;ͼ

WOBBLE PROC
        mov     dword ptr[teller1],20
        mov     dword ptr[teller2],300
        mov     dword ptr[teller3],0
        mov     ebp,600
wobble_l3:
        call    update_rain
        mov     esi,rain
        mov     edi,vaddr2
        call    flip
        mov     edi,vaddr2
        mov     dword ptr[teller4],ebp
        sub     dword ptr[teller4],400
        mov     ecx,320
wobble_l1:
        mov     ebx,ecx
        add     ebx,dword ptr[teller4]
        push    ebx
        fild    dword ptr[esp]
        fiadd   dword ptr[teller3]
        fild    dword ptr[teller1]
        fdivp
        fsin
        fild    dword ptr[teller4]
        fmulp   st(1),st(0)
        fild    dword ptr[teller2]
        fdivp
        mov     dword ptr[esp],20
        add     dword ptr[esp],ecx
        fild    dword ptr[esp]
        fmulp
        fistp   dword ptr[esp]
        pop     ebx
        mov     edx,199*320
        add     edx,ecx
        dec     edx

        mov     eax,ebx
        shl     ebx,8
        shl     eax,6
        add     ebx,eax
        add     ebx,edx
wobble_l2:
        cmp     ebx,200*320
        jae     wobble_a1
        mov     al,byte ptr[shoarma+ebx]
        cmp     al,1
        je      wobble_a1
        mov     byte ptr [edi+edx],al
wobble_a1:
        sub     ebx,320
        sub     edx,320

        jnc     wobble_l2

        dec     ecx
        jnz     wobble_l1
        dec     dword ptr[teller3]
        call    wait_retrace
        mov     esi,vaddr2
        mov     edi,vga
        call    wait_retrace
        call    smallflip
        sub     ebp,2           ;sincounter
        jnc     wobble_l3
        ret
WOBBLE ENDP

;ͻ
;      WATER                                                               
;ͼ
WATER PROC
;water part


        xor     eax,eax
        mov     edi,vaddr2
        call    clear

        call    waterloop
        call    fadedown
        ret
WATER ENDP

WATERLOOP PROC
        call    savepall
        call    text_pall
water_l1:
        mov     esi,vaddr5
        mov     edi,vaddr2   ;of andersom;)
        call    maak_water
        in      ax,40h
        add     eax,random
        ror     eax,3
        add     random,eax
        and     al,127
        cmp     al,20
        jnb     waterloop_nb1
        call    add_turbulence
waterloop_nb1:
        call    calc_hoogtemap

        call    xmpGetPos_
        movzx   ebx,al
        cmp     ah,5
        jne     water_shredder
        mov     ecx,63+13
        mov     ebp,64
        call    pallfade
        mov     ebx,10
        mov     ecx,64+31
        mov     ebp,64+16
        call    pallfade


water_shredder:
        cmp     ah,9
        jne     water_ne1
        call    text_pall2
        neg     ebx
        add     ebx,63
        mov     ecx,64+13          ;ecx max ebp min
        mov     ebp,64
        call    pallfade
        neg     ebx
        add     ebx,63
        mov     ecx,64+31
        mov     ebp,64+16
        call    pallfade
water_ne1:

        mov     edi,vaddr2
        call    schrijfadvert
        mov     esi,vaddr2
        mov     edi,vga
        call    wait_retrace
        call    smallflip
        mov     eax,water_1
        mov     ebx,water_2
        mov     water_2,eax
        mov     water_1,ebx
        call    xmpGetPos_
        cmp     ah,14

        jb      water_l1
        ret
WATERLOOP ENDP

ADD_TURBULENCE PROC
        mov     edi,water_1
        in      ax,40h
        add     eax,random
        ror     eax,3
        add     random,eax
        and     eax,127
        mov     ebp,eax
        shl     ebp,8
        shl     eax,6
        add     ebp,eax
        in      ax,40h
        add     eax,random
        ror     eax,3
        add     random, eax
        and     eax,255-32
        add     ebp,eax

;        mov     ebp,50*320+100
        mov     ecx,40
at_l1:  mov     edx,40
at_l2:  push    ecx
        sub     dword ptr[esp],20
        fild    dword ptr[esp]
        fmul    st(0),st(0)
        push    edx
        sub     dword ptr[esp],20
        fild    dword ptr[esp]
        fmul    st(0),st(0)
        faddp
        fsqrt
        fistp   dword ptr[esp]
        pop     eax
        add     esp,4
        cmp     eax,21
        jb      at_b1
        xor     eax,eax
        jmp     at_jump
at_b1:
        add     eax,30
at_jump:
        shl     eax,3

        mov     dword ptr[edi+ebp*4],eax
        add     ebp,1
        dec     edx
        jnz     at_l2
        add     ebp,320-40
        dec     ecx
        jnz     at_l1
        ret
ADD_TURBULENCE ENDP

MAAK_WATER PROC
        ;       in:esi:bron
        ;          edi:doel

        mov     edx,water_1
;        mov     edi,vaddr2
;        mov     esi,vaddr5
        push    esi
        mov     ebp,321
        mov     ecx,198
mw_l1:
        mov     esi,318
mw_l2:
        mov     eax,[edx+ebp*4]
        mov     ebx,eax
        sub     eax,[edx+ebp*4+4]
        sub     ebx,[edx+ebp*4+320*4]
        sar     ebx,3
        imul    ebx,320
        sar     eax,3
        add     eax,ebx
        add     eax,ebp
        mov     ebx,[esp]
        cmp     eax,64000
        jb      mw_b1
        mov     eax,64000
mw_b1:
        mov     al,[ebx+eax]
        mov     [edi+ebp],al
        inc     ebp
        dec     esi
        jnz     mw_l2
        add     ebp,2
        dec     ecx
        jnz     mw_l1
        add     esp,4
        ret
MAAK_WATER ENDP

CALC_HOOGTEMAP PROC
        mov     esi,water_1
        mov     edi,water_2
        mov     ebp,321
        mov     ecx,198
ch_l1:
        mov     edx,318
ch_l2:
        mov     eax,[esi+(ebp+320  )*4]
        add     eax,[esi+(ebp-320  )*4]
        add     eax,[esi+(ebp    +1)*4]
        add     eax,[esi+(ebp    -1)*4]
        add     eax,[esi+(ebp+320-1)*4]
        add     eax,[esi+(ebp-320-1)*4]
        add     eax,[esi+(ebp+320+1)*4]
        add     eax,[esi+(ebp-320+1)*4]
        sar     eax,2
        sub     eax,[edi+ebp*4]
        jnc     ch_nc1
        xor     eax,eax
ch_nc1:
        mov     ebx,eax
        sar     ebx,4
        sub     eax,ebx
        mov     [edi+ebp*4],eax

        inc     ebp
        dec     edx
        jnz     ch_l2
        add     ebp,2
        dec     ecx
        jnz     ch_l1
        ret
CALC_HOOGTEMAP ENDP

;ͻ
;      TEXTEN                                                              
;ͼ
MAKE_TEXTEN PROC
        ;advert_line            ;esi moet geincreased worden
        ;letterstart
        ;letterwidth
        ;font
        ;vaddr3

        ;mik de adverts allemaal op vaddr3
        mov     edi,textscherm
        mov     ecx,320*1050
        mov     eax,0
        call    clear

        mov     edx,textscherm
        mov     esi,offset advert_line
        dec     esi     ;because i'm stupid
        xor     edi,edi
        mov     ebx,offset font
ma_l1:
        inc     esi
        cmp     byte ptr[esi],1
        je      ma_skip
        cmp     byte ptr[esi],2
        je      ma_skip

        ;hiero de letter nog plaatsen..
        xor     ecx,ecx
        mov     cl,byte ptr[esi]

        mov     eax,[letterstart+ecx*4] ;offset van start letter in font
        mov     ecx,[letterwidth+ecx*4] ;breedte van letter

        add     eax,ebx
        push    ebx
        push    edx
        add     edx,edi
        mov     ch,30
        mov     ebp,ecx
        and     ebp,255
ma_l2:
        mov     bh,byte ptr[eax+ebp-1]
        cmp     bh,255
        jne     ma_l3
        sub     bh,ch
        mov     byte ptr[edx+ebp],bh    ;edx is gepushed, edi is een soort van breedte-index: niet aankomen..
ma_l3:

        dec     ebp
        jnz     ma_l2

        add     edx,320
        add     eax,450
        mov     ebp,ecx
        and     ebp,255
        dec     ch
        jnz     ma_l2
        ;ch is sowieso nul
        add     edi,ecx
        inc     edi

        pop     edx
        pop     ebx
ma_skip:
        cmp     byte ptr[esi],2
        je      ma_klaar
        cmp     byte ptr[esi],1
        jne     ma_l1
        inc     dword ptr[advert_numbers]
        add     edx,320*30
        xor     edi,edi
        jmp     ma_l1
ma_klaar:
        ret
MAKE_TEXTEN ENDP

SCHRIJFADVERT3 PROC
        pushall
        mov     eax,320*30
        imul    eax,dword ptr[advert_pos]
        mov     esi,textscherm
        add     esi,eax
        mov     ecx,320*30

sa3_l1:
        mov     bl,byte ptr[esi+ecx]
        cmp     bl,0
        je      sa3_skip
        sub     bl,128+64
        mov     [edi+ecx],bl
        mov     [edi+ecx+321],bl
sa3_skip:                                ;van doortellen via advert_counter
        dec     ecx                     ;naar tellen via GetTimer()
        jnz     sa3_l1
        popall
        ret
SCHRIJFADVERT3 ENDP


SCHRIJFADVERT2 PROC
        pushall
        mov     eax,320*30
        imul    eax,dword ptr[advert_pos]
        mov     esi,textscherm
        add     esi,eax
        mov     ecx,320*30

sa_l1:
        mov     bl,byte ptr[esi+ecx]
        cmp     bl,0
        je      sa_skip
        mov     [edi+ecx],bl
        mov     [edi+ecx+321],bl
sa_skip:                                ;van doortellen via advert_counter
        dec     ecx                     ;naar tellen via GetTimer()
        jnz     sa_l1
        popall
        ret
SCHRIJFADVERT2 ENDP

SCHRIJFADVERT PROC
        ;in:edi
        call    xmpGetPos_
        movzx   eax,ah
        sub     eax,5
        mov     dword ptr[advert_pos],eax
        mov     eax,320*30

        imul    eax,dword ptr[advert_pos]
        mov     esi,textscherm
        add     esi,eax
        mov     ecx,320*30
        add     edi,320*170

sa2_l1:
        mov     bl,byte ptr[esi+ecx]
        cmp     bl,0
        je      sa2_skip
        mov     [edi+ecx],bl
sa2_skip:                                ;van doortellen via advert_counter
        dec     ecx                     ;naar tellen via GetTimer()
        jnz     sa2_l1

;        inc     dword ptr[advert_counter]
;        cmp     dword ptr[advert_counter],100
;        jne     sa_moeven
;        inc     dword ptr[advert_pos]
;        mov     dword ptr[advert_counter],0
;        mov     eax,dword ptr[advert_pos]
;        cmp     eax,dword ptr[advert_numbers]
;        jne     sa_moeven
;        mov     dword ptr[advert_pos],0
sa_moeven:
        ret
SCHRIJFADVERT ENDP

;ͻ
;      PALLETTES                                                           
;ͼ
SAVEPALL PROC
        mov     ecx,256
sp_l1:
        mov     al,cl
        mov     edx,03c7h
        out     dx,al
        mov     edx,03c9h
        in      al,dx
        mov     [pal+ecx*2+ecx],al
        in      al,dx
        mov     [pal+ecx*2+ecx+1],al
        in      al,dx
        mov     [pal+ecx*2+ecx+2],al

        dec     ecx
        jnz     sp_l1
        ret
SAVEPALL ENDP

PALLFADE PROC
        ;in:            ebx: val[0..64]
;                        ecx: max
;                        ebp: min
pf_l1:
        mov     edx,03c8h
        mov     al,cl
        out     dx,al
        mov     edx,03c9h

        movzx   eax,byte ptr[pal+ecx*2+ecx]
        imul    eax,ebx
        shr     eax,6
        out     dx,al
        movzx   eax,byte ptr[pal+ecx*2+ecx+1]
        imul    eax,ebx
        shr     eax,6
        out     dx,al
        movzx   eax,byte ptr[pal+ecx*2+ecx+2]
        imul    eax,ebx
        shr     eax,6
        out     dx,al

        dec     ecx
        cmp     ecx,ebp
        jne     pf_l1
        ret
PALLFADE ENDP

ALISHREDDERPAL PROC
        mov     ecx,16
        mov     esi,offset alipal
        xor     ebp,ebp
        xor     ebx,ebx
asp_l1:
        mov     edx,03c8h
        mov     eax,ebp
        add     eax,64
        out     dx,al
        inc     edx
        mov     al,[esi+ebx]
        shr     al,2
        out     dx,al
        mov     al,[esi+ebx+1]
        shr     al,2
        out     dx,al
        mov     al,[esi+ebx+2]
        shr     al,2
        out     dx,al
        add     ebx,3
        inc     ebp
        dec     ecx
        jnz     asp_l1

        mov     ecx,16
        mov     esi,offset shredderpal
        xor     ebp,ebp
        xor     ebx,ebx
asp_l2:
        mov     edx,03c8h
        mov     eax,ebp
        add     eax,16+64
        out     dx,al
        inc     edx
        mov     al,[esi+ebx]
        shr     al,2
        out     dx,al
        mov     al,[esi+ebx+1]
        shr     al,2
        out     dx,al
        mov     al,[esi+ebx+2]
        shr     al,2
        out     dx,al
        add     ebx,3
        inc     ebp
        dec     ecx
        jnz     asp_l2


        ret
ALISHREDDERPAL ENDP

RAIN_PALL PROC
        mov     ecx,64
Rp_l1:
        mov     edx,03c8h
        mov     al,cl
        out     dx,al
        mov     edx,03c9h

        out     dx,al

        xor     al,al
        out     dx,al

        xor     al,al
        out     dx,al

        dec     ecx
        jns     Rp_l1
        mov     ecx,64
Rp_l2:
        mov     edx,03c8h
        mov     al,cl
        add     al,63
        out     dx,al
        mov     edx,03c9h

        mov     al,63
        sub     al,cl
        out     dx,al

        mov     al,cl
        shr     al,1
        out     dx,al

        shr     al,3
        out     dx,al

        dec     ecx
        jns     Rp_l2
        mov     ecx,64
Rp_l3:
        mov     edx,03c8h
        mov     al,cl
        add     al,127
        out     dx,al
        mov     edx,03c9h

        mov     bl,cl
        shr     bl,1
        mov     al,31
        add     al,bl
        out     dx,al

        out     dx,al

        out     dx,al

        dec     ecx
        jns     Rp_l3
        mov     ecx,64
Rp_l4:
        mov     edx,03c8h
        mov     al,cl
        add     al,63+128
        out     dx,al
        mov     edx,03c9h

        shr     al,4
        out     dx,al

        mov     al,cl
        add     al,128+63
        shr     al,3
        add     al,32
        out     dx,al

        sub     al,32
        out     dx,al

        dec     ecx
        jns     Rp_l4

        ret
RAIN_PALL ENDP

TEXT_PALL PROC
        mov     ecx,30
tp_l1:
        mov     edx,3c8h
        mov     al,cl
        add     al,255-30
        out     dx,al
        inc     edx
        mov     al,byte ptr[textpal+ecx*2+ecx]
        add     al,10
        and     al,63
        out     dx,al
        mov     al,byte ptr[textpal+ecx*2+ecx+1]
        add     al,10
        and     al,63
        out     dx,al
        mov     al,byte ptr[textpal+ecx*2+ecx+2]
        add     al,10
        and     al,63
        out     dx,al
        dec     ecx
        jnz     tp_l1
        ret
TEXT_PALL ENDP

TEXT_PALL2 PROC
        mov     ecx,30
tp2_l1:
        mov     edx,3c8h
        mov     al,cl
        add     al,255-30
        out     dx,al
        inc     edx
        mov     al,byte ptr[textpal+ecx*2+ecx]
        out     dx,al
        mov     al,byte ptr[textpal+ecx*2+ecx+1]
        out     dx,al
        mov     al,byte ptr[textpal+ecx*2+ecx+2]
        out     dx,al
        dec     ecx
        jnz     tp2_l1
        ret
TEXT_PALL2 ENDP

COMET_PAL PROC
        mov     esi,offset firepal
        mov     ecx,71
cp_l1:
        mov     edx,03c8h
        mov     al,cl
        out     dx,al
        inc     edx
        mov     ebx,ecx
        shl     ebx,1
        add     ebx,ecx
        mov     al,byte ptr[esi+ebx-3]
        out     dx,al
        mov     al,byte ptr[esi+ebx-2]
        out     dx,al
        mov     al,byte ptr[esi+ebx-1]
        out     dx,al

        dec     ecx
        jnz     cp_l1
        ret
COMET_PAL ENDP
;ͻ
;      INITIALIZATION                                                      
;ͼ

INITIALIZE PROC
        mov     ah,9
        lea     edx,copyright
        int     21h
        mov     ecx,320*200
        call    get_hi_mem
        jc      ohoow
        mov     dword ptr handle2,esi
        mov     dword ptr vaddr2,ebx
        mov     ecx,320*200
        mov     edi,vaddr2
        xor     eax,eax
        call    clear
        mov     ecx,320*200*4
        call    get_hi_mem
        jc      ohoow
        mov     dword ptr handle3,esi
        mov     dword ptr vaddr3,ebx
        mov     ecx,320*200*4
        mov     edi,vaddr3
        xor     eax,eax
        call    clear
        mov     ecx,320*200
        call    get_hi_mem
        jc      ohoow
        mov     dword ptr handle4,esi
        mov     dword ptr vaddr4,ebx
        mov     ecx,320*200
        mov     edi,vaddr4
        xor     eax,eax
        call    clear
        mov     ecx,320*200
        call    get_hi_mem
        jc      ohoow
        mov     dword ptr handle5,esi
        mov     dword ptr vaddr5,ebx
        mov     ecx,320*200
        mov     edi,vaddr5
        xor     eax,eax
        call    clear
        mov     ecx,320*200
        call    get_hi_mem
        jc      ohoow
        mov     dword ptr handle6,esi
        mov     dword ptr rain,ebx
        mov     ecx,320*200
        mov     edi,rain
        xor     eax,eax
        call    clear
        mov     ecx,320*1650
        call    get_hi_mem
        jc      ohoow
        mov     dword ptr handle7,esi
        mov     dword ptr textscherm,ebx
        mov     ecx,320*1650
        mov     edi,textscherm
        xor     eax,eax
        call    clear
        mov     ecx,320*200*4
        call    get_hi_mem
        jc      ohoow
        mov     dword ptr handle8,esi
        mov     dword ptr water_1,ebx
        mov     ecx,320*200*4
        mov     edi,water_1
        xor     eax,eax
        call    clear
        mov     ecx,320*200*4
        call    get_hi_mem
        jc      ohoow
        mov     dword ptr handle9,esi
        mov     dword ptr water_2,ebx
        mov     ecx,320*200*4
        mov     edi,water_2
        xor     eax,eax
        call    clear
        mov     ecx,320*200
        call    get_hi_mem
        jc      ohoow
        mov     dword ptr handle10,esi
        mov     dword ptr cometscherm,ebx
        mov     ecx,320*200
        mov     edi,cometscherm
        xor     eax,eax
        call    clear
        mov     ecx,320*200
        call    get_hi_mem
        jc      ohoow
        mov     dword ptr handle11,esi
        mov     dword ptr randomscherm_1,ebx
        mov     ecx,320*200
        call    get_hi_mem
        jc      ohoow
        mov     dword ptr handle12,esi
        mov     dword ptr randomscherm_2,ebx
        mov     ecx,320*200
        call    get_hi_mem
        jc      ohoow
        mov     dword ptr handle13,esi
        mov     dword ptr vaddr2,ebx
        call    make_texten


        mov     esi,offset ali
        mov     ecx,320*200
init_l2:
        mov     al,[esi+ecx]
        add     al,64
        mov     [esi+ecx],al
        dec     ecx
        jnz     init_l2
        mov     edi,offset ali
        mov     esi,offset shredder
        mov     ecx,320*200
init_l1:
        mov     al,[esi+ecx]
        cmp     al,15
        jnb     init_nb1
        add     al,16+64
        mov     [edi+ecx],al
init_nb1:
        dec     ecx
        jnz     init_l1
        call    makecos
        jc      ohoow
        call    init_lens

        mov     ax,13h
        int     10h
ohoow:
        ret
INITIALIZE ENDP

LOGOUT PROC
        mov     ax,3h
        int     10h
        mov     esi,dword ptr handle2
        call    free_hi_mem
        mov     esi,dword ptr handle3
        call    free_hi_mem
        mov     esi,dword ptr handle4
        call    free_hi_mem
        mov     esi,dword ptr handle5
        call    free_hi_mem
        mov     esi,dword ptr handle6
        call    free_hi_mem
        mov     esi,dword ptr handle7
        call    free_hi_mem
        mov     esi,dword ptr handle8
        call    free_hi_mem
        mov     esi,dword ptr handle9
        call    free_hi_mem
        mov     esi,dword ptr handle10
        call    free_hi_mem
        mov     esi,dword ptr handle11
        call    free_hi_mem
        mov     esi,dword ptr handle12
        call    free_hi_mem
        mov     esi,dword ptr handle13
        call    free_hi_mem
        ret
LOGOUT ENDP

START_MUZIEK PROC
        global xmpInit_:near
        global xmpSetVolume_:near
        global xmpGetSync_:near
        global xmpGetPos_:near
        global xmpPlay_:near
        global xmpStop_:near
        global xmpGetTimer_:near
        global xmpGetEnvPtrDPMI_:near
        global xmpGetGUSPort_:near
        MXMINTMODEDPMI=1
        MXMINTMODEDOS=1
        mov     __psp,es
        push    ds
        pop     es
        movzx   eax,__psp
        call    xmpGetEnvPtrDPMI_
        call    xmpGetGUSPort_
        lea     ebx,mxmdata
        mov     ecx,65536
        mov     esi,offset module
        mov     dl,MXMINTMODEDOS
        call    xmpInit_
        xor     eax,eax
        call    xmpPlay_
        ret
START_MUZIEK ENDP

include global.inc
_TEXT   ends
extrn   module:byte
extrn   ali:byte
extrn   shredder:byte
extrn   shoarma:byte
_DATA   segment use32 dword public 'DATA'
;ͻ
;      DATA                                                                 
;ͼ
ermsg1                  db 'Joh, goochum, je hebt een memory-probleem!',13,10,'$'
quitmsg1                db 'Wiehah! ciao!!',13,10,'$'
advert_pos      dd 0
advert_numbers  dd 0
advert_counter  dd 0
advert_line     db '  shall i conquer the space'
                db '        for you sir'
                db ' shall i reclaim what once'
                db '       has been yours'
                db '         ah space '
                db '   it only exists within'
                db ' the boundries of a universe'
                db ' it is of futile importance'
                db '  just finish your shoarma'
                db '  just finish your shoarma'
                db '    coding '
                db '      aspasia'
                db '  art'
                db '      colloss'
                db ' music'
                db '   butterbrain'
                db 'mental support'
                db '    sfinx'
                db '          greetings'
                db ''
                db ''
                db '   scid'
                db '          ramjam'
                db '  sentinel    riplin   xoror'
                db '    infuse                  '
                db '    jace     nix'
                db '         the black lotus'
                db '  buckshag'
                db '       superstition'
                db '   sagacity  sarix  skin'
                db '          quad'
                db '    deadline       inopia '
                db '              quad'
                db '       stryker'
                db ''
                db ' amnesia  derange  mindtwist'
                db '      impulse               '
                db '            silence         '      ;deze gaat fout
                db ''
                db '       the takeover crew'
                db ''
                db '      paula                '       ;en deze
                db ''
                db '                   david   '
                db ''



                db ''
advert_line_pos dd 0
label font
include cs.inc                        ;97=a 48=0
letterstart     dd 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0     ;0 - 31
                dd 440,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 292, 305, 315, 327, 339, 352, 365, 378, 391, 403, 0,0,0,0,0,0 ;32 - 63
                dd 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0       ;64 - 95
                dd 0,  5, 17, 29, 40, 52, 64, 75, 86, 99, 102, 113, 125, 129, 145, 156, 168, 178, 189, 199, 210, 220, 231, 241, 255, 268, 279 ;96 - 122

letterwidth     dd 10,10,10,10,10,10,10,10, 10,10,10,10,10,10,10,10, 10,10,10,10,10,10,10,10, 10,10,10,10,10,10,10,10     ;0 - 31
                dd 10,10,10,10,10,10,10,10, 10,10,10,10,10,10,10,10, 12, 7, 10, 10, 12, 12, 11, 12, 11, 12, 10,10,10,10,10,10 ;32 - 63
                dd 10,10,10,10,10,10,10,10, 10,10,10,10,10,10,10,10, 10,10,10,10,10,10,10,10, 10,10,10,10,10,10,10,10       ;64 - 95
                dd 10, 11, 11, 11, 10, 12, 10, 10, 10, 3, 8, 10, 3, 15, 10, 10, 8, 10, 9, 10, 9, 10, 9, 13, 12, 10, 11   ;96 - 122
label alipal
include ali.pal
label shredderpal
include shredder.pal
label textpal
include cs.pal
label firepal
include fire.pal
visible                 dd 0
vga                     dd 0a0000h
vaddr2                  dd 0
vaddr3                  dd 0
vaddr4                  dd 0
vaddr5                  dd 0
rain                    dd 0
water_1                 dd 0
water_2                 dd 0
textscherm              dd 0
cometscherm             dd 0
randomscherm_1          dd 0
randomscherm_2          dd 0
vaddr13                 dd 0
handle2                 dd 0
handle3                 dd 0
handle4                 dd 0
handle5                 dd 0
handle6                 dd 0
handle7                 dd 0
handle8                 dd 0
handle9                 dd 0
handle10                dd 0
handle11                dd 0
handle12                dd 0
handle13                dd 0

teller1                 dd 0
teller2                 dd 0
teller3                 dd 0
teller4                 dd 0
wobbler_teller          dd 0
wobbler_sinval          dd 10
wobbler_sinval2         dd 200/2
fadedown_cols           db 255
random                  dd 0
enviromentmap   db 256*256 dup(0)

coscounter      dd 0
temp            dd 0
temp2           dd 0
temp3           dd 0
cosindex        dd 2000 dup(0)

sprite01        db 8,16,22,22,22,22,16,8
                db 16,22,22,28,28,22,22,16
                db 16,22,28,28,28,28,22,16
                db 22,28,28,28,28,28,28,22
                db 22,28,28,28,28,28,28,22
                db 16,22,28,28,28,28,22,16
                db 16,22,22,28,28,22,22,16
                db 8,16,22,22,22,22,16,8
pal             db 256*3 dup(0)

spritepos       dw 40,30, 140,20, 20,60, 230,120, 110,190, 220,180, 60,110, 40,170
spritecospos    dd 3,100,148,032,240,60,300,120
spritedir       dd 4,-3,-4,-3,-4,-3,4,3
spritediry      dd 1,1,1,1,1,1,1,1
spritel         dd 0,0,0,0,0,0,0,0
bumpx           dd 0
bumpy           dd 0
bumpxdir        dd 0
bumpydir        dd 0
lens_afstand            dd 40
lens_straal             dd Rlens
lens_X          dd 10
lens_Y          dd 50
lensxdir        dd 2
lensydir        dd 1

lens_orig       db Dlens*Dlens dup(0)  ;32x32
lens_transform  dd Dlens*Dlens dup(0)                 ;DD!!!
lens_end        db Dlens*Dlens dup(0)

label ansi
include bye.pic
copyright db "tiny gus xm player (c) '95/96 Niklas Beisert / pascal",10,10,13,'$'
__psp dw 0

                        wasm_bug_repair_bit db 01h ;laten staan!!!! voor wasm
_DATA   ends
_BSS segment dword public use32 'BSS'
        mxmdata db 4000h dup (?)
_BSS ends
;ͻ
;      STACK                                                                
;ͼ
_stack  segment para stack 'STACK'
        db 100h dup(?)
_stack  ends
end start
