class tube
{
	private:
		GLuint texture;
		int beginning;
		int current;
		int text_phase;
		SDL_Surface *temp;
		GLUquadric* tuube;
	public:
		tube();
		void run();
		void draw();
};

tube::tube()
{
	glClearColor(0.1f, 0.1f, 0.1f, 0.0f);
	
	glGenTextures(2,&texture);
	glBindTexture(GL_TEXTURE_2D,texture);
 
 	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
 	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);

	int i;
	
	glBindTexture(GL_TEXTURE_2D,texture);
	temp = IMG_Load("tube_texture.png");
		
	gluBuild2DMipmaps(GL_TEXTURE_2D,4,temp->w,temp->h,GL_RGBA,GL_UNSIGNED_BYTE,temp->pixels);
	
	beginning = SDL_GetTicks();
	
	SDL_FreeSurface(temp);
	
	tuube =  gluNewQuadric();
	gluQuadricTexture (tuube, 1);
	
	glBlendFunc (GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
	
		GLfloat LightAmbient[]= { 1.0f, 0.5f, 0.5f, 1.0f };
	GLfloat LightDiffuse[]= { 1.0f, 1.0f, 1.0f, 1.0f };
	GLfloat LightPosition[]= { 5.0f, 2.0f, -10.0f, 1.0f };
	
	glLightfv(GL_LIGHT1, GL_AMBIENT, LightAmbient);
	glLightfv(GL_LIGHT1, GL_DIFFUSE, LightDiffuse);	
	glLightfv(GL_LIGHT1, GL_POSITION,LightPosition);
	
	glEnable(GL_LIGHT1);
	
	glEnable(GL_LIGHTING);
	
	gluQuadricOrientation(tuube, GLU_INSIDE);
}

void tube::run()
{	
	current = SDL_GetTicks() - beginning;
	
	glTranslatef(0,0,0);
	
	draw();
}

void tube::draw()
{
	glBindTexture(GL_TEXTURE_2D,texture);
	glEnable(GL_TEXTURE_2D);

	
	glDisable(GL_BLEND);
	glEnable(GL_DEPTH_TEST);
	
	if (current < 20000)
	for (float i = 0+current/2000.; i < 25+current/2000.; i++)
	{
		glTranslatef(0,0,-9.6+i);
		glRotatef(sin((i*100))*19, 0,0,1);
		gluCylinder(tuube, 2, 2, 1+current/10000., 40, 40);
	}
}
