class swastika
{
	private:
		GLuint texture;
		int beginning;
		int current;
		int text_phase;
		SDL_Surface *temp;
	public:
		swastika();
		void run();
		void roll();
		void draw();
		void noise();
		void text();
};

swastika::swastika()
{
	glClearColor(1.0f, 1.0f, 1.0f, 0.0f);
	
	glGenTextures(2,&texture);
	glBindTexture(GL_TEXTURE_2D,texture);
 
 	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
 	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);

	int i;
	
	glBindTexture(GL_TEXTURE_2D,texture+1);
	
	temp = IMG_Load("text.png");
	
	gluBuild2DMipmaps(GL_TEXTURE_2D,4,temp->w,temp->h,GL_RGBA,GL_UNSIGNED_BYTE,temp->pixels);
		
	if (temp)
	{
		SDL_FreeSurface(temp);
	}
	
	glBindTexture(GL_TEXTURE_2D,texture);
	temp = IMG_Load("swastika.png");
		
	gluBuild2DMipmaps(GL_TEXTURE_2D,4,temp->w,temp->h,GL_RGBA,GL_UNSIGNED_BYTE,temp->pixels);
	
	beginning = SDL_GetTicks();
}

void swastika::run()
{
	noise();
	
	current = SDL_GetTicks() - beginning;
	
	glPushMatrix();
		
		glRotatef(45,0,0,1);
		glColor4f(1,1,1,0.4);
		glTranslatef(0,0,-1);
		draw();
			
	glPopMatrix();
	
	glPushMatrix();
	
		glColor4f(1,1,1,1);
		glTranslatef(0.2,2.0,-5);
		text();
	
	glPopMatrix();
	
	glPushMatrix();
	
	glColor4f(1,1,1,1);
	roll();
	for (int i = 0; i < 20; i++)
	{
		glTranslatef(0,0,-0.008);
		draw();
	}
	glPopMatrix();
}

void swastika::roll()
{
	glTranslatef(0,0,-5);
	glRotatef(sin((current%360))*360.0, 1, 1, 1);
}

void swastika::draw()
{
	glBindTexture(GL_TEXTURE_2D,texture);
	glEnable(GL_TEXTURE_2D);
	
	glBlendFunc (GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
	glEnable (GL_BLEND);
	
	GLfloat modifier;
	
	glBegin(GL_QUADS);
	
			glTexCoord2d(0,1); glVertex3f(-1, 1, 0); // Upper left
			glTexCoord2d(0,0); glVertex3f(-1,-1, 0); // Bottom left
			glTexCoord2d(1,0); glVertex3f( 1,-1, 0); // Bottom right
			glTexCoord2d(1,1); glVertex3f( 1, 1, 0); // Upper Right
	glEnd();
	
	/*glBegin(GL_POLYGON);
	for (int i = 0; i < 100; i++)
	{
		modifier = 3;
		if (i%3)
			modifier = -0.5;
		glTexCoord2d(i/100.,1); glVertex3f(-1+(i/50.), 1+modifier, 0); // Upper Left to Right
	}
	for (int i = 0; i < 100; i++)
	{
			glTexCoord2d(1-i/100.,0); glVertex3f( 1-(i/50.),-1-modifier, 0); // Bottom Right to Left
	}
	glEnd();*/
}

void swastika::text()
{
	glBindTexture(GL_TEXTURE_2D,texture+1);
	glEnable(GL_TEXTURE_2D);
	
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
	glEnable (GL_BLEND);
	
	glRotatef(180,1,0,0);
	
	for (int i = 0; i < 2; i++)
	{
	GLfloat cut_top = (((int)(current/(100*pow((i+1),3)))%6)*(1/6.));
	GLfloat cut_bottom = cut_top - (1/6.);
	
	glBegin(GL_POLYGON);
			glTexCoord2d(0,cut_top); glVertex3f(-3, 0.5, 0); // Upper left
			glTexCoord2d(0,cut_bottom); glVertex3f(-3,-0.5, 0); // Bottom left
			glTexCoord2d(1,cut_bottom); glVertex3f( 3,-0.5, 0); // Bottom right
			glTexCoord2d(1,cut_top); glVertex3f( 3, 0.5, 0); // Upper Right
	glEnd();
	glTranslatef(0,4,0);
	
	glColor4f(sin(current/10.),tan(current/100.),tan(current/10.),cos(current/(100*pow((i+1),3))));
	}
}

void swastika::noise()
{
	
}
