// motherparticle is the mother of all particles! It holds the most important data to create a basic particle,
// that are easily extandable by adding methods and data members.

#include "main.h"

class MotherParticle // Holding all required data for a particle without any special qualities
{
	public:
		
		GLuint nelio;
		
		MotherParticle();
		
		GLfloat color[3];
		
		GLfloat starting_points[3]; // The starting point of a particle
		
		GLfloat l_x, l_y, l_z; // The location of a particle
		GLfloat v_x, v_y, v_z; // The velocity vectors
		GLfloat a_x, a_y, a_z; // The acceleration vectors
		
		GLfloat burning; // Reaching zero the particle is reinitialized - This is also the brightness of the particle
		GLfloat fading_speed; // The speed of fading
		
		void Run(); // Executes all functions defined under, takes care of new initialization if needed, decrements 'burning'
		
		void LocationInit(); // Initialize location for a particle
		void SpeedInit(); // Initialize speed for a particle
		void AccInit(); // Initialize acceleration for a particle
		
		void ColorBurnInit(); // Initialize the color, state of brightness (e.g. 'burn) and fading speed
		
		void Burn();
		void AddAcceleration();
		void AddVelocity();
		void Draw();
};

MotherParticle::MotherParticle()
{	
	burning = 0;
	fading_speed = 0;
	
	starting_points[0] = -1.5;
	starting_points[1] = -1.5;
	starting_points[2] = 0;
	
	
	
		
	glNewList(nelio,GL_COMPILE);
	
		glBegin(GL_TRIANGLE_STRIP);
	
	/*
		glTexCoord2d(1,1); glVertex3f( 1.0f, 1.0f, 0.0f); // Top Right
		glTexCoord2d(0,1); glVertex3f(-1.0f, 1.0f, 0.0f); // Top Left
		glTexCoord2d(1,0); glVertex3f( 1.0f,-1.0f, 0.0f); // Bottom Right
		glTexCoord2d(0,0); glVertex3f(-1.0f,-1.0f, 0.0f); // Bottom Left
	*/
	
		glVertex3f( 0.1f, 0.1f, 0.0f); // Top Right
		glVertex3f(-0.1f, 0.1f, 0.0f); // Top Left
		glVertex3f( 0.1f,-0.1f, 0.0f); // Bottom Right
		glVertex3f(-0.1f,-0.1f, 0.0f); // Bottom Left
	
		glEnd();
	
	glEndList();
}

void MotherParticle::LocationInit()
{
	l_x = starting_points[0];
	l_y = starting_points[1];
	l_z = starting_points[2];
}

void MotherParticle::SpeedInit()
{
	// Randomizing the speeds. Else-scenario is made to first guess whether the speed is negative or positive

	if (rand()%2 != 0)
		v_x = (rand()%400/12800.0);
	else
		v_x = -(rand()%400/12800.0);
	if (rand()%2 != 0)
		v_y = (rand()%400/12800.0);
	else
		v_y = -(rand()%400/12800.0);
	if (rand()%2 != 0)
		v_z = (rand()%400/12800.0);
	else
			v_z = -(rand()%400/12800.0);
}

void MotherParticle::AccInit()
{
	a_x = 0;
	a_y = 0;
	a_z = 0;
}

void MotherParticle::ColorBurnInit()
{
	fading_speed = 0.05;
	
	burning = 0.75;
		
	color[0] = (rand()%100)/100.0;
	color[1] = (rand()%100)/100.0;
	color[2] = (rand()%100)/100.0;
}

void MotherParticle::Burn()
{
	burning -= fading_speed;
}

void MotherParticle::Run()
{
	if (burning <= 0)
	{	
		LocationInit();
		SpeedInit();
		AccInit();
		
		ColorBurnInit();
	}
	
	Burn();
	AddAcceleration();
	AddVelocity();
	Draw();
}

void MotherParticle::AddAcceleration()
{
	v_x += a_x;
	v_y += a_y;
	v_z += a_z;
}

void MotherParticle::AddVelocity()
{
	l_x += v_x;
	l_y += v_y;
	l_z += l_z;
}

void MotherParticle::Draw()
{
	glPushMatrix();

	glTranslatef(l_x, l_y, l_z-4);
	glScalef(0.08,0.08,0.08);
	
	glColor4f(color[0], color[1], color[2], burning);

	glCallList(nelio);
	
	glPopMatrix();
}
