#include <iostream>
#include <math.h>
#include <vector>
#include <time.h>
#include <stdlib.h>

#include <SDL/SDL.h>
#include <SDL/SDL_opengl.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_mixer.h>

/* Defines for library initializations etc */
#define S_WIDTH 1024
#define S_HEIGHT 768
#define BPP 32
#define S_FLAGS SDL_OPENGL | SDL_FULLSCREEN

#include "FPSlimit.h"
#include "intro.h"


void InitStuff(); /* screen initialization functions, misc. variables' values assigned, the particle engine's initialization functions called here */

void Events();
SDL_Event event;
Uint8* pressed_key;

bool running;
/* */

int main()
{	
	InitStuff();
	
	FPS_Limiter FPS_Limit;
	
	int TEST_REMOVE = SDL_GetTicks();
	int TEST_REMOVE2 = 0;
	int FPS_REMOVE = 0;
	
	intro Intro;
	
	while (running)
	{
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		glLoadIdentity();
		glTranslatef( 0.0f, 0.0f,-1.0f);
		
		glPushMatrix();
		Intro.run();
		glPopMatrix();
		
		Events();

		SDL_GL_SwapBuffers();
		FPS_Limit.Limit();
		
		if (SDL_GetTicks() - TEST_REMOVE > 1000)
		{
			
			std::cout<<"FPS: "<<FPS_REMOVE<<"\n";
			
			FPS_REMOVE = 0;
			TEST_REMOVE = SDL_GetTicks();
			printf("Seconds: %d\n", SDL_GetTicks()/1000);
		}
		FPS_REMOVE++;
		
		if (SDL_GetTicks() - Intro.beginning > 59000)
			running = 0;
	}
	
	SDL_Quit();
	return 0;
}

void InitStuff()
{
	/* Particle engine and misc. variables */
	running = 1;
	
	/* Random generator */
	time_t seed;
    time(&seed);

    srand(seed);
    /* .. */
	
	
	/* Library, screen initializations */
	SDL_Init(0);
	SDL_SetVideoMode(S_WIDTH, S_HEIGHT, BPP, S_FLAGS);
	
		
		
	SDL_ShowCursor(0);
	
	Mix_OpenAudio(44100, MIX_DEFAULT_FORMAT, 2, 1024);
		
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	gluPerspective(45.0f,(GLfloat)S_WIDTH/(GLfloat)S_HEIGHT,0.1f,100.0f);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	
	glShadeModel(GL_SMOOTH);
	glClearDepth(1.0f);
	glDepthFunc(GL_LEQUAL);
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
	
// 	glEnable(GL_TEXTURE_2D);

	glBlendFunc(GL_SRC_ALPHA,GL_ONE);
	
	glEnable(GL_BLEND);
	glDisable(GL_DEPTH_TEST);

}

void Events()
{	
	SDL_PollEvent(&event);
	if ( event.type == SDL_QUIT )
		running = 0;

	pressed_key = SDL_GetKeyState(NULL);
	if ( pressed_key[SDLK_ESCAPE] )
		running = 0;
}
