
/*

   AFM v1.0 (w) 2001 by Silpheed/Hitmen, Groepaz/Hitmen  www.hitmen-console.org

   Example Code for GCC... you need your own startup-code to compile this.

   for more info look in afm.h

 */

/* afm header */
#include <afm.h>

#define PALETTE (*(volatile unsigned short*)0x05000000)
#define DISPCNT (*(volatile unsigned short*)0x04000000)
#define VCOUNT  (*(volatile unsigned short*)0x04000006)
#define KEYS    (*(volatile unsigned short*)0x04000130)

/* modfile data */
extern const _binary_zak_mod_start;

/* wait for rasterline */
void waitline(unsigned long line){
    while(VCOUNT!=line){};
}

void main(void) {
unsigned short key,vol=0xff,ch=2;

    DISPCNT=0;

    /* install player */
    afm_install();

    /* initialize module */
    afm_init(&_binary_zak_mod_start);

    while(1) {

        /* wait so player/mixer is executed in visible area */
        waitline (30);
        PALETTE = 0xff;

        /* call this every frame
           this routine may be delayed
         */
        afm_update();

        PALETTE = 0x00;

        key=KEYS^0xffff;

        if(key&0x0010)  ch=2;  /* set stereo replay */
        if(key&0x0020)  ch=1;  /* set mono replay */
        if(key&0x0040)  if(vol<0xff) vol++; /* volume up */
        if(key&0x0080)  if(vol>0) vol--;    /* volume down */
        if(key!=0x0000) afm_sound_param(vol>>2,ch); /* set sound params */

        /* wait for vblank */
        waitline(160);
        /* must call this right at the start of vblank
           with minimum delay
         */
        afm_sync();

    }

    /* deinstall player, stop playing any sound */
    afm_deinit();

}
