/*
 * makeverts.c -- Build display lists for all letters
 *
 * This is one of the most interesting bits of code.
 * It generates a display list from a set of vertices.
 */

#include "demo.h"
#include "model.h"
#include <gu.h>


void MakeObject(Gfx *l,int index);
/* Declare size to be big to be safe */
extern Gfx mtglist[NUMOBJECTS][MTGLISTSIZE];  /* Display lists for all meshes */

/* Externals */
extern dynamic_stuff rsp_dynamic;  /* RSP-Addressable version of dynamic DL */

/*
 * build a display list for a mesh of a letter
 *
 * Gfx contains pointer to destination for display list, index is number of mesh.
 */
void MakeObject(Gfx *l, int index) 
{
  int f;
  Vtx *ModelVerts;

  /* 
   * Get pointer to vertex data. Data is in Vtx format already
   * so it's ready to be loaded into the vertex buffer by the display list
   */
  ModelVerts=(Vtx*)AbetVertData[index];

  /* 
   * Create display list for drawing faces
   * 
   * Normally you will want to add texturing code in here too, but since all the faces
   * have the same texture it is faster to leave it out.
   *
   * Note: Every face has it's own unique vertices, which is neccesary to give them different
   * vertex normals. A lot of space is wasted though because a lot of these triangles will be
   * forming quads so they will have the same normals anyway. For laziness they are simply
   * defined twice.
   */

  for (f=0; f<AbetNumFaces[index]-4; f+=5)
  {
	// Load 15 vertices into the vertex buffer (5 sets of 3 verts, 3 verts per face)
	// gSPVertex(lpDP, address of vertices, number of verts, index of first vert in vertex buffer)
	gSPVertex(l++, &(ModelVerts[f*3]), 15, 0);

	// Draw 5 faces out of these triangles.
	// gSP1Triangle(lpDP, index of vert 1, vert 2, vert 3, flags)
    gSP1Triangle(l++, 0,1,2,0);
    gSP1Triangle(l++, 3,4,5,0);
    gSP1Triangle(l++, 6,7,8,0);
    gSP1Triangle(l++, 9,10,11,0);
    gSP1Triangle(l++, 12,13,14,0);
  }
  // Draw the last couple of faces (if the number of faces isn't a multiple of 5)
  for ( ;f<AbetNumFaces[index]; f++)
  {
	gSPVertex(l++, &(ModelVerts[f*3]), 3, 0);
    gSP1Triangle(l++, 0,1,2,0);
  }

  // That's all
  gSPEndDisplayList(l++);

} 


