#version 330 core

uniform sampler2D normal_depth;
uniform sampler2D lowres_normal_depth;
uniform sampler2D lowres_mssao;

in vec2 uv;

layout (location = 0) out vec4 frag_color;

#include <deferred/gbuffer_read_include.frag>

#include <post/mssao_include.frag>


void main()
{
	vec4 nd = texture(normal_depth, uv);
	vec3 currPos = calc_position(uv, nd.w);
	float occlusion = 0.0;
	float sampleCount = 0.0001;
	float rangeMax = min(r / abs(currPos.z), rMax);
	for (float x=1.0; x <= rangeMax; x+=2.0)
	{
		for (float y=1.0; y < rangeMax; y+=2.0)
		{
			vec2 scale = vec2(x, y)*TexelSize;
			computeOcclusion(normal_depth, uv + offsets[0]*scale, currPos, nd.xyz, occlusion, sampleCount);
			computeOcclusion(normal_depth, uv + offsets[1]*scale, currPos, nd.xyz, occlusion, sampleCount);
			computeOcclusion(normal_depth, uv + offsets[2]*scale, currPos, nd.xyz, occlusion, sampleCount);
			computeOcclusion(normal_depth, uv + offsets[3]*scale, currPos, nd.xyz, occlusion, sampleCount);
		}
	}

	vec3 smp = upsampleAO(lowres_normal_depth, lowres_mssao, uv, currPos, nd.xyz);
	
	frag_color = vec4(max(smp.x, occlusion / sampleCount), smp.y + occlusion, smp.z + sampleCount, 0.0);
}
