#version 330 core

uniform sampler2D color_buffer;
uniform sampler2D depth_buffer;

// The fragment sampling matrix is as follows (x is the current fragment)
// 0 1 2
// 3 x 4
// 5 6 7
uniform vec2 sampleMatrix[8];

uniform vec2 camera_params; // near, (far - near) / far

uniform vec2 edge_params; // threshold=0.25, force=0.6

in vec2 uv;

layout(location = 0) out vec4 frag_color;

float get_depth(in vec2 coord)
{
	float one_m_depth = -1.0 + texture(depth_buffer, coord).x;
	return -camera_params.x / (one_m_depth * camera_params.y);
}

void main(void)
{
	float maxDepth, minDepth;
	maxDepth = minDepth = get_depth(uv);
	for (int i = 0; i < 8; i++)
	{
		float d = get_depth(uv + sampleMatrix[i]);
		maxDepth = max(maxDepth, d);
		minDepth = min(minDepth, d);
	}

	float depthDiff = maxDepth - minDepth;

	frag_color.rgb = texture2D(color_buffer, uv).rgb * mix(edge_params.y, 1.0, float(depthDiff  > edge_params.x) );
	frag_color.a = 1.0;
}
